/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.export.ExportYAML;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.report.SingleProblemReport;
import edu.csus.ecs.pc2.imports.ccs.ContestYAMLLoader;
import edu.csus.ecs.pc2.ui.FileNameExtensionFilter;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleDataSetPaneNew;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class EditProblemPaneNew
extends JPanePlugin {
    public static final String DEFAULT_INTERNATIONAL_VALIDATOR_COMMAND = "{:validator} {:infile} {:outfile} {:ansfile} {:resfile} ";
    private static boolean debug22EditProblem = false;
    private static final long serialVersionUID = -1060536964672397704L;
    private String lastSaveDirectory = null;
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private Problem problem = null;
    private JTabbedPane mainTabbedPane = null;
    private JPanel generalPane = null;
    private JPanel judgingTypePane = null;
    private JTextField problemNameTextField = null;
    private JTextField timeOutSecondTextField = null;
    private JCheckBox problemRequiresInputDataCheckBox = null;
    private JPanel teamReadsFromPanel = null;
    private JRadioButton stdinRadioButton = null;
    private JRadioButton fileRadioButton = null;
    private JLabel problemNameLabel = null;
    private JLabel timeoutLabel = null;
    private Log log = null;
    private boolean populatingGUI = true;
    private String lastDirectory;
    private String lastYamlLoadDirectory;
    protected ProblemDataFiles originalProblemDataFiles;
    protected ProblemDataFiles newProblemDataFiles;
    private ButtonGroup teamReadsFrombuttonGroup = null;
    private ButtonGroup judgingTypeGroup = null;
    private JPanel validatorPane = null;
    private JRadioButton useNOValidatatorRadioButton = null;
    private JRadioButton usePC2ValidatorRadioButton = null;
    private JRadioButton useExternalValidatorRadioButton = null;
    private JCheckBox showValidatorToJudges = null;
    private JPanel pc2ValidatorFrame = null;
    private JPanel externalValidatorFrame = null;
    private JLabel validatorOptionsLabel = null;
    private JComboBox<String> pc2ValidatorOptionComboBox = null;
    private JCheckBox ignoreCaseCheckBox = null;
    private JLabel validatorProgramLabel = null;
    private JPanel externalValidatorPane = null;
    private JButton validatorProgramJButton = null;
    private JLabel lblValidatorCommandLine = null;
    private JTextField validatorCommandLineTextBox = null;
    private JLabel externalValidatorLabel = null;
    private JCheckBox showCompareCheckBox = null;
    private JCheckBox doShowOutputWindowCheckBox = null;
    private ButtonGroup validatorChoiceButtonGroup = null;
    private static final String NL = System.getProperty("line.separator");
    private JRadioButton computerJudging = null;
    private JRadioButton manualJudging = null;
    private JCheckBox manualReview = null;
    private JCheckBox prelimaryNotification = null;
    private JCheckBox deleteProblemCheckBox = null;
    private boolean listenersAdded = false;
    private JButton loadButton = null;
    private ContestYAMLLoader loader = null;
    private JButton exportButton = null;
    private JButton reportButton = null;
    private JPanel judgeTypeInnerPane = null;
    private JPanel ccsSettingsPane = null;
    private JCheckBox ccsValidationEnabledCheckBox = null;
    private boolean usingExternalDataFiles = false;
    private String loadPath;
    private JTextField shortNameTextfield;
    private String fileNameOne;
    private JPanel problemDescriptionPanel;
    private JPanel problemDataFilesPanel;
    private JLabel lblSpacer1;
    private JLabel lblSpacer2;
    private JPanel judgingDisplayOptionsPanel;
    private JPanel inputDataStoragePanel;
    private JRadioButton rdbtnCopyFilesToInternal;
    private JRadioButton rdbtnKeepFilesExternal;
    private Component horizontalStrut_4;
    private Component horizontalStrut_5;
    private JTextField teamFileNameTextField;
    private JLabel lblTeamReadsFromFileName;
    private JCheckBox judgesHaveProvidedAnswerFilesCheckBox;
    private MultipleDataSetPaneNew multipleDataSetPane;

    public EditProblemPaneNew() {
        this.setMaximumSize(new Dimension(900, 500));
        this.setPreferredSize(new Dimension(900, 576));
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainTabbedPane(), "Center");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        String value;
        super.setContestAndController(inContest, inController);
        this.addWindowListeners();
        this.getMultipleDataSetPane().setContestAndController(inContest, inController);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditProblemPaneNew.this.getLoadButton().setVisible(Utilities.isDebugMode());
                EditProblemPaneNew.this.getExportButton().setVisible(Utilities.isDebugMode());
            }
        });
        if (IniFile.isFilePresent() && (value = IniFile.getValue("client.debug")) != null) {
            debug22EditProblem = value.equalsIgnoreCase("true");
        }
    }

    private void addWindowListeners() {
        if (this.listenersAdded) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditProblemPaneNew.this.getParentFrame() != null) {
                    EditProblemPaneNew.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            EditProblemPaneNew.this.handleCancelButton();
                        }

                        @Override
                        public void windowOpened(WindowEvent e) {
                            EditProblemPaneNew.this.getProblemNameTextField().requestFocus();
                        }

                        @Override
                        public void windowActivated(WindowEvent e) {
                            EditProblemPaneNew.this.getProblemNameTextField().requestFocus();
                        }
                    });
                    EditProblemPaneNew.this.listenersAdded = true;
                }
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Edit Problem Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getReportButton(), null);
            this.buttonPane.add((Component)this.getLoadButton(), null);
            this.buttonPane.add((Component)this.getExportButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.addProblem();
                }
            });
        }
        return this.addButton;
    }

    protected void addProblem() {
        if (this.problemNameTextField.getText().trim().length() < 1) {
            this.showMessage("Enter a problem name");
            return;
        }
        if (this.getShortNameTextfield().getText().trim().length() < 1) {
            this.showMessage("Enter a problem short name");
            return;
        }
        if (!this.validateProblemFields()) {
            return;
        }
        Problem newProblem = null;
        try {
            SerializedFile sFile;
            this.newProblemDataFiles = this.getProblemDataFilesFromFields();
            newProblem = this.getProblemFromFields(null, this.newProblemDataFiles, true);
            if (this.newProblemDataFiles.getJudgesDataFiles().length == 1 && (sFile = this.newProblemDataFiles.getJudgesDataFile()) != null) {
                this.checkFileFormat(sFile);
                if (this.checkFileFormat(sFile)) {
                    this.newProblemDataFiles.setJudgesDataFile(sFile);
                }
            }
            if (this.newProblemDataFiles.getJudgesAnswerFiles().length == 1 && (sFile = this.newProblemDataFiles.getJudgesAnswerFile()) != null && this.checkFileFormat(sFile)) {
                this.newProblemDataFiles.setJudgesAnswerFile(sFile);
            }
            if ((sFile = this.newProblemDataFiles.getValidatorFile()) != null && this.checkFileFormat(sFile)) {
                this.newProblemDataFiles.setValidatorFile(sFile);
            }
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        if (!newProblem.getElementId().equals(this.newProblemDataFiles.getProblemId())) {
            ProblemDataFiles clone = new ProblemDataFiles(newProblem);
            clone.setSiteNumber(this.newProblemDataFiles.getSiteNumber());
            clone.setValidatorFile(this.newProblemDataFiles.getValidatorFile());
            clone.setValidatorRunCommand(this.newProblemDataFiles.getValidatorRunCommand());
            clone.setValidatorFile(this.newProblemDataFiles.getValidatorRunFile());
            clone.setJudgesAnswerFiles(this.newProblemDataFiles.getJudgesAnswerFiles());
            clone.setJudgesDataFiles(this.newProblemDataFiles.getJudgesDataFiles());
            clone.setValidatorFiles(this.newProblemDataFiles.getValidatorFiles());
            this.newProblemDataFiles = clone;
        }
        this.getController().addNewProblem(newProblem, this.newProblemDataFiles);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void enableUpdateButton() {
        String updateToolTip;
        boolean enableButton;
        block15: {
            if (this.populatingGUI) {
                return;
            }
            enableButton = false;
            updateToolTip = "";
            if (this.problem != null) {
                try {
                    ProblemDataFiles pdf;
                    ProblemDataFiles myProblemDataFiles = new ProblemDataFiles(this.problem);
                    Problem changedProblem = this.getProblemFromFields(null, this.newProblemDataFiles, false);
                    if (!this.problem.isSameAs(changedProblem) || this.getMultipleDataSetPane().hasChanged(myProblemDataFiles)) {
                        enableButton = true;
                        updateToolTip = "Problem changed";
                    }
                    if ((pdf = this.getContest().getProblemDataFile(this.problem)) != null) {
                        int fileChanged = 0;
                        String fileName = changedProblem.getDataFileName();
                        if (fileName != null && fileName.length() > 0 && !this.fileSameAs(pdf.getJudgesDataFile(), changedProblem.getDataFileName())) {
                            enableButton = true;
                            ++fileChanged;
                            updateToolTip = updateToolTip.equals("") ? "Judges data" : ", Judges data";
                        }
                        if ((fileName = changedProblem.getAnswerFileName()) != null && fileName.length() > 0 && !this.fileSameAs(pdf.getJudgesAnswerFile(), changedProblem.getAnswerFileName())) {
                            enableButton = true;
                            ++fileChanged;
                            updateToolTip = updateToolTip.equals("") ? "Judges answer" : String.valueOf(updateToolTip) + ", Judges answer";
                        }
                        fileName = changedProblem.getValidatorProgramName();
                        if (!this.problem.isUsingPC2Validator() && fileName != null && fileName.length() > 0 && !this.fileSameAs(pdf.getValidatorFile(), changedProblem.getValidatorProgramName())) {
                            enableButton = true;
                            ++fileChanged;
                            updateToolTip = updateToolTip.equals("") ? "Validator" : String.valueOf(updateToolTip) + ", Validator";
                        }
                        if (fileChanged > 0) {
                            updateToolTip = fileChanged == 1 ? String.valueOf(updateToolTip) + " file changed" : String.valueOf(updateToolTip) + " files changed";
                        }
                        break block15;
                    }
                    this.logDebugException("No ProblemDataFiles for " + this.problem);
                }
                catch (InvalidFieldValue e) {
                    this.logDebugException("Input Problem (but not saving) ", e);
                    enableButton = true;
                }
                catch (Exception ex) {
                    this.logDebugException("Edit Problem ", ex);
                    this.showMessage("Error, check logs.  " + ex.getMessage());
                }
            } else if (this.getAddButton().isVisible()) {
                enableButton = true;
            }
        }
        if (updateToolTip.equals("")) {
            this.getUpdateButton().setToolTipText(null);
        } else {
            this.getUpdateButton().setToolTipText(updateToolTip);
        }
        this.enableUpdateButtons(enableButton);
    }

    private void logDebugException(String string) {
        if (Utilities.isDebugMode()) {
            System.err.print("Debug message " + string);
        }
        this.getLog().log(Log.DEBUG, string);
    }

    private void logDebugException(String string, Exception e) {
        if (Utilities.isDebugMode()) {
            System.err.print("Debug message " + string);
            e.printStackTrace(System.err);
        }
        this.getLog().log(Log.DEBUG, string, e);
    }

    private boolean fileSameAs(SerializedFile file, String fileName) {
        if (fileName != null && !fileName.trim().equals("")) {
            if (file != null && !fileName.equals(file.getName())) {
                return true;
            }
            return !this.needsFreshening(file, fileName);
        }
        return true;
    }

    public Problem getProblemFromFields(Problem checkProblem, ProblemDataFiles dataFiles, boolean isAdding) {
        if (debug22EditProblem) {
            Utilities.dump(this.newProblemDataFiles, "debug 22 in getProblemFromFields start");
        }
        if (checkProblem == null) {
            checkProblem = new Problem(this.problemNameTextField.getText());
            isAdding = true;
            if (this.newProblemDataFiles == null) {
                this.newProblemDataFiles = new ProblemDataFiles(checkProblem);
            }
        } else {
            checkProblem.setDisplayName(this.problemNameTextField.getText());
            checkProblem.setElementId(this.problem);
            this.newProblemDataFiles = dataFiles;
            isAdding = false;
        }
        if (debug22EditProblem) {
            Utilities.dump(this.newProblemDataFiles, "debug 22 in getProblemFromFields after IF");
        }
        checkProblem.setUsingExternalDataFiles(this.usingExternalDataFiles);
        int secs = this.getIntegerValue(this.timeOutSecondTextField.getText());
        checkProblem.setTimeOutInSeconds(secs);
        boolean deleted = this.getDeleteProblemCheckBox().isSelected();
        checkProblem.setActive(!deleted);
        checkProblem.setCcsMode(this.getCcsValidationEnabledCheckBox().isSelected());
        checkProblem.setShortName(this.shortNameTextfield.getText());
        if (!checkProblem.isValidShortName()) {
            throw new InvalidFieldValue("Invalid problem short name");
        }
        if (this.getProblemRequiresInputDataCheckBox().isSelected()) {
            System.err.println("EditProblemPaneNew.getProblemFromFields(): Warning: processing for 'problem requires data' checkbox is commented out!");
        }
        if (this.getJudgesHaveProvidedAnswerFilesCheckBox().isSelected()) {
            System.err.println("EditProblemPaneNew.getProblemFromFields(): Warning: processing for 'judges have provided answer files' checkbox is commented out!");
        }
        if (this.stdinRadioButton.isSelected() && this.fileRadioButton.isSelected()) {
            throw new InvalidFieldValue("Pick just one radio button");
        }
        if (this.fileRadioButton.isSelected()) {
            checkProblem.setReadInputDataFromSTDIN(false);
        } else if (this.stdinRadioButton.isSelected()) {
            checkProblem.setReadInputDataFromSTDIN(true);
        }
        checkProblem.setValidatedProblem(!this.useNOValidatatorRadioButton.isSelected());
        if (checkProblem.isValidatedProblem()) {
            checkProblem.setUsingPC2Validator(this.usePC2ValidatorRadioButton.isSelected());
        }
        checkProblem.setValidatorCommandLine(this.validatorCommandLineTextBox.getText());
        checkProblem.setWhichPC2Validator(0);
        checkProblem.setIgnoreSpacesOnValidation(false);
        checkProblem.setValidatorProgramName(null);
        if (checkProblem.isUsingPC2Validator()) {
            checkProblem.setWhichPC2Validator(this.getPc2ValidatorComboBox().getSelectedIndex());
            checkProblem.setIgnoreSpacesOnValidation(this.getIgnoreCaseCheckBox().isSelected());
            checkProblem.setValidatorCommandLine("{:validator} {:infile} {:outfile} {:ansfile} {:resfile}  -pc2 " + checkProblem.getWhichPC2Validator() + " " + checkProblem.isIgnoreSpacesOnValidation());
            checkProblem.setValidatorProgramName("pc2.jar edu.csus.ecs.pc2.validator.Validator");
        }
        checkProblem.setShowValidationToJudges(this.showValidatorToJudges.isSelected());
        checkProblem.setHideOutputWindow(!this.getDoShowOutputWindowCheckBox().isSelected());
        checkProblem.setShowCompareWindow(this.getShowCompareCheckBox().isSelected());
        String newValidatorFileName = this.externalValidatorLabel.getText();
        newValidatorFileName = newValidatorFileName != null ? newValidatorFileName.trim() : "";
        if (this.useExternalValidatorRadioButton.isSelected() && newValidatorFileName.length() > 0) {
            String existingValidatorFilename = newValidatorFileName;
            if (existingValidatorFilename.length() != this.externalValidatorLabel.getToolTipText().length()) {
                existingValidatorFilename = String.valueOf(this.externalValidatorLabel.getToolTipText());
            }
            if (isAdding) {
                SerializedFile serializedFile = new SerializedFile(existingValidatorFilename);
                if (serializedFile.getBuffer() == null) {
                    throw new InvalidFieldValue("Unable to read file " + existingValidatorFilename + " choose validator file again (adding)");
                }
                checkProblem.setValidatorProgramName(serializedFile.getName());
                this.newProblemDataFiles.setValidatorFile(serializedFile);
            } else {
                SerializedFile serializedFile = this.getController().getProblemDataFiles(this.problem).getValidatorFile();
                if (newValidatorFileName.equals(existingValidatorFilename)) {
                    if (serializedFile != null) {
                        serializedFile = this.freshenIfNeeded(serializedFile, existingValidatorFilename);
                        this.newProblemDataFiles.setValidatorFile(serializedFile);
                        checkProblem.setValidatorProgramName(serializedFile.getName());
                    } else {
                        this.newProblemDataFiles.setValidatorFile(null);
                        checkProblem.setValidatorProgramName(existingValidatorFilename);
                    }
                } else {
                    serializedFile = new SerializedFile(newValidatorFileName);
                    this.checkFileFormat(serializedFile);
                    this.newProblemDataFiles.setValidatorFile(serializedFile);
                    checkProblem.setValidatorProgramName(serializedFile.getName());
                }
            }
        }
        checkProblem.setComputerJudged(this.computerJudging.isSelected());
        if (this.computerJudging.isSelected()) {
            checkProblem.setManualReview(this.manualReview.isSelected());
            if (this.manualReview.isSelected()) {
                checkProblem.setPrelimaryNotification(this.prelimaryNotification.isSelected());
            } else {
                checkProblem.setPrelimaryNotification(false);
            }
        } else {
            checkProblem.setManualReview(false);
            checkProblem.setPrelimaryNotification(false);
        }
        checkProblem.setExternalDataFileLocation(this.loadPath);
        if (debug22EditProblem) {
            Utilities.dump(this.newProblemDataFiles, "debug 22 before populateProblemTestSetFilenames");
        }
        if (dataFiles == null) {
            System.err.println("EditProblemPaneNew.getProblemFromFields(): Warning: processing for 'input parameter datafiles is null' is commented out!");
        } else {
            this.populateProblemTestSetFilenames(checkProblem, dataFiles);
        }
        if (debug22EditProblem) {
            Utilities.dump(this.newProblemDataFiles, "debug 22 after populateProblemTestSetFilenames");
        }
        return checkProblem;
    }

    private String getName(SerializedFile serializedFile) {
        if (serializedFile != null) {
            return serializedFile.getName();
        }
        return null;
    }

    private void populateProblemTestSetFilenames(Problem inProblem, ProblemDataFiles dataFiles) {
        String[] dataList = this.getTestDataList(dataFiles);
        String[] answerList = this.getTestAnswerList(dataFiles);
        inProblem.removeAllTestCaseFilenames();
        if (dataList != null) {
            int i = 0;
            while (i < dataList.length) {
                inProblem.addTestCaseFilenames(dataList[i], answerList[i]);
                ++i;
            }
        }
    }

    private String[] getTestAnswerList(ProblemDataFiles dataFiles) {
        ArrayList<String> list = new ArrayList<String>();
        SerializedFile[] filelist = dataFiles.getJudgesAnswerFiles();
        SerializedFile[] dataFileList = dataFiles.getJudgesDataFiles();
        SerializedFile[] serializedFileArray = filelist;
        int n = filelist.length;
        int n2 = 0;
        while (n2 < n) {
            SerializedFile serializedFile = serializedFileArray[n2];
            list.add(serializedFile.getName());
            ++n2;
        }
        this.padListIfNeeded(list, filelist, dataFileList);
        return list.toArray(new String[list.size()]);
    }

    private String[] getTestDataList(ProblemDataFiles dataFiles) {
        SerializedFile[] dataFileList;
        ArrayList<String> list = new ArrayList<String>();
        SerializedFile[] filelist = dataFiles.getJudgesAnswerFiles();
        SerializedFile[] serializedFileArray = dataFileList = dataFiles.getJudgesDataFiles();
        int n = dataFileList.length;
        int n2 = 0;
        while (n2 < n) {
            SerializedFile serializedFile = serializedFileArray[n2];
            list.add(serializedFile.getName());
            ++n2;
        }
        this.padListIfNeeded(list, filelist, dataFileList);
        return list.toArray(new String[list.size()]);
    }

    private void padListIfNeeded(ArrayList<String> stringList, SerializedFile[] filelist, SerializedFile[] dataFileList) {
        int max = Math.max(filelist.length, dataFileList.length);
        int i = 0;
        while (i < max - stringList.size()) {
            stringList.add("");
            ++i;
        }
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.updateProblem();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateProblem() {
        if (!this.validateProblemFields()) {
            return;
        }
        Problem newProblem = null;
        try {
            ProblemDataFiles dataFiles = this.getProblemDataFilesFromFields();
            newProblem = this.getProblemFromFields(this.problem, dataFiles, false);
        }
        catch (InvalidFieldValue e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        this.getController().updateProblem(newProblem, this.newProblemDataFiles);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    protected ProblemDataFiles getProblemDataFilesFromFields() {
        this.newProblemDataFiles = this.multipleDataSetPane.getProblemDataFiles();
        if (debug22EditProblem) {
            Utilities.dump(this.newProblemDataFiles, "debug 22 in getProblemDataFilesFromFields");
        }
        return this.newProblemDataFiles;
    }

    private boolean validateProblemFields() {
        if (this.problemNameTextField.getText().trim().length() < 1) {
            this.showMessage("Enter a problem name");
            return false;
        }
        if (this.getUsePC2ValidatorRadioButton().isSelected() && this.pc2ValidatorOptionComboBox.getSelectedIndex() < 1) {
            this.showMessage("Select a Validator option");
            return false;
        }
        if (this.getProblemRequiresInputDataCheckBox().isSelected()) {
            System.err.println("EditProblemPaneNew.validateProblemFields(): Warning: processing for 'problem requires data' checkbox is commented out!");
        }
        if (this.getJudgesHaveProvidedAnswerFilesCheckBox().isSelected()) {
            System.err.println("EditProblemPaneNew.getProblemFromFields(): Warning: processing for 'judges have provided answer files' checkbox is commented out!");
        }
        if (this.getComputerJudging().isSelected() && this.useNOValidatatorRadioButton.isSelected()) {
            this.showMessage("Computer Judging selected, must select a validator");
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isFile()) {
                if (file.canRead()) return true;
                this.showMessage("Could not read file " + fileName);
                return false;
            }
            this.showMessage(String.valueOf(fileName) + " is not a file");
            return false;
        }
        Object[] options = new Object[]{"Ok", "Cancel", "Ignore"};
        int n = JOptionPane.showOptionDialog(null, String.valueOf(fileName) + " does not exist", "Message", 2, 1, null, options, options[0]);
        if (n >= 2) return true;
        return false;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Problem modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addProblem();
                } else {
                    this.updateProblem();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(final Problem inProblem, final ProblemDataFiles problemDataFiles) {
        this.problem = inProblem;
        this.newProblemDataFiles = null;
        this.originalProblemDataFiles = problemDataFiles;
        this.fileNameOne = this.createProblemReport(inProblem, problemDataFiles, "stuf1");
        if (debug22EditProblem) {
            Utilities.dump(this.originalProblemDataFiles, "debug 22   ORIGINAL  setProblem");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditProblemPaneNew.this.getMultipleDataSetPane().clearDataFiles();
                EditProblemPaneNew.this.getMultipleDataSetPane().setProblemDataFiles(problemDataFiles);
                EditProblemPaneNew.this.populateGUI(inProblem);
                EditProblemPaneNew.this.populatingGUI = true;
                EditProblemPaneNew.this.setForm(inProblem, problemDataFiles);
                EditProblemPaneNew.this.getAddButton().setVisible(true);
                EditProblemPaneNew.this.getUpdateButton().setVisible(false);
                EditProblemPaneNew.this.enableUpdateButtons(true);
                EditProblemPaneNew.this.enableValidatorComponents();
                EditProblemPaneNew.this.enableRequiresInputDataComponents(EditProblemPaneNew.this.getProblemRequiresInputDataCheckBox().isSelected());
                EditProblemPaneNew.this.enableProvideAnswerFileComponents(EditProblemPaneNew.this.getJudgesHaveProvidedAnswerFilesCheckBox().isSelected());
                EditProblemPaneNew.this.populatingGUI = false;
            }
        });
    }

    public void setJudgingTestSetOne(ProblemDataFiles datafiles) {
        boolean assignedValues = false;
        if (datafiles == null) {
            this.deleteAllDataSets();
        } else {
            SerializedFile[] answerFiles = datafiles.getJudgesAnswerFiles();
            if (answerFiles.length > 0) {
                this.getJudgesHaveProvidedAnswerFilesCheckBox().setSelected(true);
                this.getProblemRequiresInputDataCheckBox().setSelected(true);
                assignedValues = true;
            }
        }
        if (!assignedValues) {
            this.getJudgesHaveProvidedAnswerFilesCheckBox().setSelected(false);
            this.getProblemRequiresInputDataCheckBox().setSelected(false);
        }
        this.enableRequiresInputDataComponents(this.getProblemRequiresInputDataCheckBox().isSelected());
        this.enableProvideAnswerFileComponents(this.getJudgesHaveProvidedAnswerFilesCheckBox().isSelected());
    }

    private void deleteAllDataSets() {
        ProblemDataFiles dataFiles = this.getMultipleDataSetPane().getProblemDataFiles();
        if (dataFiles != null) {
            dataFiles.removeAll();
        }
        this.getMultipleDataSetPane().setProblemDataFiles(dataFiles);
    }

    public void setProblem(final Problem problem) {
        this.problem = problem;
        this.newProblemDataFiles = null;
        this.originalProblemDataFiles = null;
        this.usingExternalDataFiles = false;
        this.fileNameOne = this.createProblemReport(problem, this.originalProblemDataFiles, "stuf1");
        System.out.println("Created problem report " + this.fileNameOne);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditProblemPaneNew.this.getMultipleDataSetPane().clearDataFiles();
                EditProblemPaneNew.this.populateGUI(problem);
                if (problem == null) {
                    EditProblemPaneNew.this.enableUpdateButtons(false);
                } else {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            }
        });
    }

    private void populateGUI(Problem inProblem) {
        block9: {
            this.populatingGUI = true;
            if (debug22EditProblem) {
                Utilities.dump(this.originalProblemDataFiles, "debug 22   ORIGINAL  populateGUI A");
            }
            if (inProblem != null) {
                this.getAddButton().setVisible(false);
                this.getUpdateButton().setVisible(true);
                this.setForm(inProblem, this.originalProblemDataFiles);
                this.getCcsValidationEnabledCheckBox().setSelected(inProblem.isCcsMode());
                try {
                    this.getProblemFromFields(inProblem, this.originalProblemDataFiles, false);
                }
                catch (InvalidFieldValue e) {
                    this.logException("Problem with input Problem fields", e);
                    e.printStackTrace(System.err);
                }
            } else {
                this.clearForm();
            }
            this.enableValidatorComponents();
            this.enableRequiresInputDataComponents(this.getProblemRequiresInputDataCheckBox().isSelected());
            this.enableProvideAnswerFileComponents(this.getJudgesHaveProvidedAnswerFilesCheckBox().isSelected());
            if (debug22EditProblem) {
                Utilities.dump(this.originalProblemDataFiles, "debug 22 ORIGINAL  populateGUI B");
            }
            try {
                this.getMultipleDataSetPane().setProblemDataFiles(this.problem, this.originalProblemDataFiles);
            }
            catch (Exception e) {
                String message = "Error loading/editing problem data files: " + e.getMessage();
                this.showMessage(String.valueOf(message) + " check logs.");
                this.getLog().log(Log.WARNING, message, e);
                if (!debug22EditProblem) break block9;
                e.printStackTrace();
            }
        }
        this.getMainTabbedPane().setSelectedIndex(0);
        this.populatingGUI = false;
        if (debug22EditProblem) {
            Utilities.dump(this.originalProblemDataFiles, "debug 22   ORIGINAL  populateGUI Z");
        }
    }

    private void dumpProblem(String filename, ProblemDataFiles pdf) {
        PrintWriter out = new PrintWriter(System.out, true);
        ProblemsReport report = new ProblemsReport();
        report.setContestAndController(this.getContest(), this.getController());
        report.writeProblemDataFiles(out, pdf);
        if (filename != null) {
            try {
                FileOutputStream stream = new FileOutputStream(filename, false);
                out = new PrintWriter(stream, true);
                out.println("Problem = " + this.problem);
                report.writeProblemDataFiles(out, pdf);
                out.close();
                out = null;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
            }
        }
        System.out.flush();
        System.err.flush();
        System.err.println("Write to vi " + filename);
    }

    private void setForm(Problem inProblem, ProblemDataFiles problemDataFiles) {
        this.problem = inProblem;
        this.originalProblemDataFiles = problemDataFiles;
        this.problemNameTextField.setText(inProblem.getDisplayName());
        this.timeOutSecondTextField.setText(String.valueOf(inProblem.getTimeOutInSeconds()));
        this.getProblemRequiresInputDataCheckBox().setSelected(inProblem.getDataFileName() != null);
        if (inProblem.isReadInputDataFromSTDIN()) {
            this.getFileRadioButton().setSelected(false);
            this.getLblTeamReadsFromFileName().setEnabled(false);
            this.getTeamFileNameTextField().setEnabled(false);
            this.getStdinRadioButton().setSelected(true);
        } else {
            this.getFileRadioButton().setSelected(true);
            this.getLblTeamReadsFromFileName().setEnabled(true);
            this.getTeamFileNameTextField().setEnabled(true);
            this.getStdinRadioButton().setSelected(false);
        }
        this.getPc2ValidatorComboBox().setSelectedIndex(0);
        this.getIgnoreCaseCheckBox().setSelected(true);
        this.externalValidatorLabel.setText("");
        this.externalValidatorLabel.setToolTipText("");
        this.ignoreCaseCheckBox.setSelected(false);
        if (inProblem.isValidatedProblem()) {
            if (inProblem.isUsingPC2Validator()) {
                this.getValidatorCommandLineTextBox().setText(DEFAULT_INTERNATIONAL_VALIDATOR_COMMAND);
                this.usePC2ValidatorRadioButton.setSelected(true);
                this.pc2ValidatorOptionComboBox.setSelectedIndex(inProblem.getWhichPC2Validator());
                this.ignoreCaseCheckBox.setSelected(inProblem.isIgnoreSpacesOnValidation());
            } else {
                this.getValidatorCommandLineTextBox().setText(inProblem.getValidatorCommandLine());
                this.useExternalValidatorRadioButton.setSelected(true);
                this.externalValidatorLabel.setText(inProblem.getValidatorProgramName());
                this.externalValidatorLabel.setToolTipText(inProblem.getValidatorProgramName());
                SerializedFile sFile = problemDataFiles.getValidatorFile();
                if (sFile != null) {
                    if (sFile.getAbsolutePath() != null) {
                        this.externalValidatorLabel.setToolTipText(sFile.getAbsolutePath());
                    } else {
                        this.externalValidatorLabel.setToolTipText("");
                    }
                }
            }
        } else {
            this.getValidatorCommandLineTextBox().setText(DEFAULT_INTERNATIONAL_VALIDATOR_COMMAND);
            this.useNOValidatatorRadioButton.setSelected(true);
        }
        this.getShowValidatorToJudges().setSelected(inProblem.isShowValidationToJudges());
        this.getDoShowOutputWindowCheckBox().setSelected(!inProblem.isHideOutputWindow());
        this.getShowCompareCheckBox().setSelected(inProblem.isShowCompareWindow());
        this.getShowCompareCheckBox().setEnabled(this.getDoShowOutputWindowCheckBox().isSelected());
        this.getDeleteProblemCheckBox().setSelected(!inProblem.isActive());
        this.populateJudging(inProblem);
        this.usingExternalDataFiles = inProblem.isUsingExternalDataFiles();
        this.loadPath = inProblem.getExternalDataFileLocation();
        this.shortNameTextfield.setText(inProblem.getShortName());
    }

    private void populateJudging(Problem inProblem) {
        if (inProblem != null && inProblem.isComputerJudged()) {
            this.computerJudging.setSelected(true);
            this.manualReview.setSelected(inProblem.isManualReview());
            this.manualReview.setEnabled(true);
            this.prelimaryNotification.setSelected(inProblem.isPrelimaryNotification());
            if (this.manualReview.isSelected()) {
                this.prelimaryNotification.setEnabled(true);
            } else {
                this.prelimaryNotification.setEnabled(false);
            }
        } else {
            this.computerJudging.setSelected(false);
            this.manualJudging.setSelected(true);
            if (inProblem == null) {
                this.manualReview.setSelected(false);
                this.prelimaryNotification.setSelected(false);
            } else {
                this.manualReview.setSelected(inProblem.isManualReview());
                this.prelimaryNotification.setSelected(inProblem.isPrelimaryNotification());
            }
            this.manualReview.setEnabled(false);
            this.prelimaryNotification.setEnabled(false);
        }
    }

    protected void enableUpdateButtons(boolean fieldsChanged) {
        if (fieldsChanged) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        if (this.getUpdateButton().isVisible()) {
            this.getUpdateButton().setEnabled(fieldsChanged);
        } else {
            this.getAddButton().setEnabled(fieldsChanged);
        }
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
            this.mainTabbedPane.setPreferredSize(new Dimension(800, 600));
            this.mainTabbedPane.insertTab("Data Files", null, this.getMultipleDataSetPane(), "Specify the set of data files to be used for this problem", 0);
            this.mainTabbedPane.insertTab("Validator", null, this.getValidatorPane(), "Configure the Validator to be used for this problem", 0);
            this.mainTabbedPane.insertTab("Judging Type", null, this.getJudgingTypePanel(), "Specify how judging is to be done for this problem", 0);
            this.mainTabbedPane.insertTab("General", null, this.getGeneralPane(), "General settings and definitions for this problem", 0);
        }
        return this.mainTabbedPane;
    }

    private MultipleDataSetPaneNew getMultipleDataSetPane() {
        if (this.multipleDataSetPane == null) {
            this.multipleDataSetPane = new MultipleDataSetPaneNew();
            this.multipleDataSetPane.setContestAndController(this.getContest(), this.getController());
        }
        return this.multipleDataSetPane;
    }

    private JPanel getJudgingTypePanel() {
        if (this.judgingTypePane == null) {
            this.judgingTypePane = new JPanel();
            this.judgingTypePane.setLayout(new BorderLayout());
            this.judgingTypePane.add((Component)this.getJudgeTypeInnerPane(), "North");
            this.judgingTypePane.add((Component)this.getCcsSettingsPane(), "Center");
            this.getJudgingTypeGroup().setSelected(this.getManualJudging().getModel(), true);
        }
        return this.judgingTypePane;
    }

    private JPanel getGeneralPane() {
        if (this.generalPane == null) {
            this.generalPane = new JPanel();
            this.generalPane.setMaximumSize(new Dimension(500, 500));
            this.generalPane.setMinimumSize(new Dimension(500, 500));
            this.generalPane.setAlignmentX(0.0f);
            this.generalPane.setPreferredSize(new Dimension(500, 500));
            GroupLayout gl_generalPane = new GroupLayout(this.generalPane);
            gl_generalPane.setHorizontalGroup(gl_generalPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gl_generalPane.createSequentialGroup().addGroup(gl_generalPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, gl_generalPane.createSequentialGroup().addContainerGap().addComponent(this.getProblemDataFilesPanel(), -1, 800, Short.MAX_VALUE)).addComponent(this.getProblemDescriptionPanel(), -1, 625, Short.MAX_VALUE).addGroup(gl_generalPane.createSequentialGroup().addContainerGap().addComponent(this.getJudgingDisplayOptionsPanel(), -1, 800, Short.MAX_VALUE))).addContainerGap()));
            gl_generalPane.setVerticalGroup(gl_generalPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_generalPane.createSequentialGroup().addComponent(this.getProblemDescriptionPanel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getProblemDataFilesPanel(), -2, 278, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getJudgingDisplayOptionsPanel(), -2, -1, -2).addGap(483)));
            gl_generalPane.setAutoCreateGaps(true);
            gl_generalPane.setAutoCreateContainerGaps(true);
            this.generalPane.setLayout(gl_generalPane);
        }
        return this.generalPane;
    }

    protected JTextField getProblemNameTextField() {
        if (this.problemNameTextField == null) {
            this.problemNameTextField = new JTextField();
            this.problemNameTextField.setPreferredSize(new Dimension(150, 20));
            this.problemNameTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.problemNameTextField;
    }

    private JTextField getTimeOutSecondTextField() {
        if (this.timeOutSecondTextField == null) {
            this.timeOutSecondTextField = new JTextField();
            this.timeOutSecondTextField.setPreferredSize(new Dimension(150, 20));
            this.timeOutSecondTextField.setDocument(new IntegerDocument());
            this.timeOutSecondTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.timeOutSecondTextField;
    }

    private JCheckBox getProblemRequiresInputDataCheckBox() {
        if (this.problemRequiresInputDataCheckBox == null) {
            this.problemRequiresInputDataCheckBox = new JCheckBox();
            this.problemRequiresInputDataCheckBox.setAlignmentX(1.0f);
            this.problemRequiresInputDataCheckBox.setPreferredSize(new Dimension(200, 30));
            this.problemRequiresInputDataCheckBox.setMaximumSize(new Dimension(200, 30));
            this.problemRequiresInputDataCheckBox.setMinimumSize(new Dimension(200, 30));
            this.problemRequiresInputDataCheckBox.setBorder(new EmptyBorder(0, 10, 0, 0));
            this.problemRequiresInputDataCheckBox.setText("Problem Requires Input Data");
            this.problemRequiresInputDataCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableRequiresInputDataComponents(EditProblemPaneNew.this.problemRequiresInputDataCheckBox.isSelected());
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.problemRequiresInputDataCheckBox;
    }

    protected void enableRequiresInputDataComponents(boolean enableButtons) {
        this.getFileRadioButton().setEnabled(enableButtons);
        this.getStdinRadioButton().setEnabled(enableButtons);
        this.getTeamFileNameTextField().setEnabled(enableButtons);
        this.getTeamReadsFromPanel().setEnabled(enableButtons);
        this.getRdbtnCopyFilesToInternal().setEnabled(enableButtons);
        this.getRdbtnKeepFilesExternal().setEnabled(enableButtons);
        this.getInputDataStoragePanel().setEnabled(enableButtons);
    }

    protected void enableProvideAnswerFileComponents(boolean enableComponents) {
        System.err.println("EditProblemNew.enableProvideAnswerFileComponents(): Warning: not implemented...");
    }

    private JPanel getTeamReadsFromPanel() {
        if (this.teamReadsFromPanel == null) {
            FlowLayout fl_teamReadsFromPanel = new FlowLayout();
            fl_teamReadsFromPanel.setAlignment(0);
            fl_teamReadsFromPanel.setHgap(20);
            fl_teamReadsFromPanel.setVgap(0);
            this.teamReadsFromPanel = new JPanel();
            this.teamReadsFromPanel.setMinimumSize(new Dimension(350, 50));
            this.teamReadsFromPanel.setPreferredSize(new Dimension(350, 50));
            this.teamReadsFromPanel.setMaximumSize(new Dimension(350, 50));
            this.teamReadsFromPanel.setAlignmentX(1.0f);
            this.teamReadsFromPanel.setLayout(fl_teamReadsFromPanel);
            this.teamReadsFromPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Team Reads From", 4, 2, new Font("Dialog", 1, 12), new Color(0, 0, 0)));
            this.teamReadsFromPanel.add((Component)this.getStdinRadioButton(), null);
            Component verticalStrut = Box.createVerticalStrut(20);
            this.teamReadsFromPanel.add(verticalStrut);
            this.teamReadsFromPanel.add((Component)this.getFileRadioButton(), null);
            this.teamReadsFromPanel.add(this.getLblTeamReadsFromFileName());
            this.teamReadsFromPanel.add(this.getTeamFileNameTextField());
            this.getTeamReadsFrombuttonGroup().setSelected(this.getStdinRadioButton().getModel(), true);
            this.getValidatorChoiceButtonGroup().setSelected(this.getUseNOValidatatorRadioButton().getModel(), true);
        }
        return this.teamReadsFromPanel;
    }

    private JLabel getLblTeamReadsFromFileName() {
        if (this.lblTeamReadsFromFileName == null) {
            this.lblTeamReadsFromFileName = new JLabel("Name of file which teams open:");
            this.lblTeamReadsFromFileName.setEnabled(false);
        }
        return this.lblTeamReadsFromFileName;
    }

    private JTextField getTeamFileNameTextField() {
        if (this.teamFileNameTextField == null) {
            this.teamFileNameTextField = new JTextField();
            this.teamFileNameTextField.setToolTipText("Enter the name of the file which the problem statement specifies the team program should open and read");
            this.teamFileNameTextField.setEnabled(false);
            this.teamFileNameTextField.setColumns(15);
        }
        return this.teamFileNameTextField;
    }

    private JRadioButton getStdinRadioButton() {
        if (this.stdinRadioButton == null) {
            this.stdinRadioButton = new JRadioButton();
            this.stdinRadioButton.setSelected(true);
            this.stdinRadioButton.setText("Stdin");
            this.stdinRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.stdinRadioButton;
    }

    private JRadioButton getFileRadioButton() {
        if (this.fileRadioButton == null) {
            this.fileRadioButton = new JRadioButton();
            this.fileRadioButton.setText("File");
            this.fileRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.fileRadioButton;
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, message);
            }
        });
    }

    private boolean selectFile(JLabel label, String dialogTitle) {
        boolean result = false;
        String oldFile = label.getToolTipText();
        String startDir = oldFile.equalsIgnoreCase("") ? this.lastDirectory : oldFile;
        JFileChooser chooser = new JFileChooser(startDir);
        if (dialogTitle != null) {
            chooser.setDialogTitle(dialogTitle);
        }
        try {
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                label.setText(chooser.getSelectedFile().getCanonicalFile().toString());
                result = true;
            }
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Error getting selected file, try again.", e);
            result = false;
        }
        chooser = null;
        return result;
    }

    private ButtonGroup getTeamReadsFrombuttonGroup() {
        if (this.teamReadsFrombuttonGroup == null) {
            this.teamReadsFrombuttonGroup = new ButtonGroup();
            this.teamReadsFrombuttonGroup.add(this.getStdinRadioButton());
            this.teamReadsFrombuttonGroup.add(this.getFileRadioButton());
        }
        return this.teamReadsFrombuttonGroup;
    }

    private ButtonGroup getJudgingTypeGroup() {
        if (this.judgingTypeGroup == null) {
            this.judgingTypeGroup = new ButtonGroup();
            this.judgingTypeGroup.add(this.getComputerJudging());
            this.judgingTypeGroup.add(this.getManualJudging());
        }
        return this.judgingTypeGroup;
    }

    private JPanel getValidatorPane() {
        if (this.validatorPane == null) {
            this.validatorPane = new JPanel();
            this.validatorPane.setLayout(null);
            this.validatorPane.add((Component)this.getUseNOValidatatorRadioButton(), null);
            this.validatorPane.add((Component)this.getUsePC2ValidatorRadioButton(), null);
            this.validatorPane.add((Component)this.getUseExternalValidatorRadioButton(), null);
            this.validatorPane.add((Component)this.getShowValidatorToJudges(), null);
            this.validatorPane.add((Component)this.getPc2ValidatorFrame(), null);
            this.validatorPane.add((Component)this.getExternalValidatorFrame(), null);
        }
        return this.validatorPane;
    }

    private JRadioButton getUseNOValidatatorRadioButton() {
        if (this.useNOValidatatorRadioButton == null) {
            this.useNOValidatatorRadioButton = new JRadioButton();
            this.useNOValidatatorRadioButton.setBounds(new Rectangle(20, 15, 246, 23));
            this.useNOValidatatorRadioButton.setText("Do not use Validator");
            this.useNOValidatatorRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableValidatorComponents();
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.useNOValidatatorRadioButton;
    }

    protected void enableValidatorComponents() {
        if (this.usePC2ValidatorRadioButton.isSelected()) {
            this.enablePC2ValidatorComponents(true);
            this.enableExternalValidatorComponents(false);
            this.getShowValidatorToJudges().setEnabled(true);
        } else if (this.useExternalValidatorRadioButton.isSelected()) {
            this.enablePC2ValidatorComponents(false);
            this.enableExternalValidatorComponents(true);
            this.getShowValidatorToJudges().setEnabled(true);
        } else {
            this.enablePC2ValidatorComponents(false);
            this.enableExternalValidatorComponents(false);
            this.getShowValidatorToJudges().setEnabled(false);
        }
    }

    private JRadioButton getUsePC2ValidatorRadioButton() {
        if (this.usePC2ValidatorRadioButton == null) {
            this.usePC2ValidatorRadioButton = new JRadioButton();
            this.usePC2ValidatorRadioButton.setBounds(new Rectangle(21, 49, 246, 23));
            this.usePC2ValidatorRadioButton.setText("Use PC^2 Validator");
            this.usePC2ValidatorRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableValidatorComponents();
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.usePC2ValidatorRadioButton;
    }

    protected void enableExternalValidatorComponents(boolean enableComponents) {
        this.getExternalValidatorFrame().setEnabled(enableComponents);
        this.getValidatorProgramJButton().setEnabled(enableComponents);
        this.getValidatorCommandLineTextBox().setEnabled(enableComponents);
    }

    protected void enablePC2ValidatorComponents(boolean enableComponents) {
        this.ignoreCaseCheckBox.setEnabled(enableComponents);
        this.pc2ValidatorOptionComboBox.setEnabled(enableComponents);
    }

    private JRadioButton getUseExternalValidatorRadioButton() {
        if (this.useExternalValidatorRadioButton == null) {
            this.useExternalValidatorRadioButton = new JRadioButton();
            this.useExternalValidatorRadioButton.setBounds(new Rectangle(17, 196, 246, 23));
            this.useExternalValidatorRadioButton.setText("Use External Validator");
            this.useExternalValidatorRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableValidatorComponents();
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.useExternalValidatorRadioButton;
    }

    private JCheckBox getShowValidatorToJudges() {
        if (this.showValidatorToJudges == null) {
            this.showValidatorToJudges = new JCheckBox();
            this.showValidatorToJudges.setBounds(new Rectangle(38, 368, 306, 24));
            this.showValidatorToJudges.setText("Show Validator To Judges (SVTJ)");
            this.showValidatorToJudges.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.showValidatorToJudges;
    }

    private JPanel getPc2ValidatorFrame() {
        if (this.pc2ValidatorFrame == null) {
            this.validatorOptionsLabel = new JLabel();
            this.validatorOptionsLabel.setText("Validator Option");
            this.validatorOptionsLabel.setBounds(new Rectangle(22, 26, 123, 23));
            this.pc2ValidatorFrame = new JPanel();
            this.pc2ValidatorFrame.setLayout(null);
            this.pc2ValidatorFrame.setBounds(new Rectangle(40, 80, 471, 108));
            this.pc2ValidatorFrame.setBorder(BorderFactory.createTitledBorder(null, "PC^2 Validator", 0, 0, null, null));
            this.pc2ValidatorFrame.add((Component)this.validatorOptionsLabel, null);
            this.pc2ValidatorFrame.add(this.getPc2ValidatorComboBox(), null);
            this.pc2ValidatorFrame.add((Component)this.getIgnoreCaseCheckBox(), null);
        }
        return this.pc2ValidatorFrame;
    }

    private JPanel getExternalValidatorFrame() {
        if (this.externalValidatorFrame == null) {
            this.lblValidatorCommandLine = new JLabel();
            this.lblValidatorCommandLine.setBounds(new Rectangle(14, 53, 177, 16));
            this.lblValidatorCommandLine.setText("Validator Command Line");
            this.validatorProgramLabel = new JLabel();
            this.validatorProgramLabel.setText("Validator Program");
            this.validatorProgramLabel.setBounds(new Rectangle(13, 26, 121, 16));
            this.externalValidatorFrame = new JPanel();
            this.externalValidatorFrame.setLayout(null);
            this.externalValidatorFrame.setBounds(new Rectangle(39, 231, 470, 127));
            this.externalValidatorFrame.setBorder(BorderFactory.createTitledBorder(null, "External Validator", 0, 0, null, null));
            this.externalValidatorFrame.add((Component)this.validatorProgramLabel, null);
            this.externalValidatorFrame.add((Component)this.getExternalValidatorPane(), null);
            this.externalValidatorFrame.add((Component)this.getValidatorProgramJButton(), null);
            this.externalValidatorFrame.add((Component)this.lblValidatorCommandLine, null);
            this.externalValidatorFrame.add((Component)this.getValidatorCommandLineTextBox(), null);
        }
        return this.externalValidatorFrame;
    }

    private JComboBox<String> getPc2ValidatorComboBox() {
        if (this.pc2ValidatorOptionComboBox == null) {
            this.pc2ValidatorOptionComboBox = new JComboBox();
            this.pc2ValidatorOptionComboBox.setBounds(new Rectangle(158, 24, 255, 26));
            this.pc2ValidatorOptionComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
            this.pc2ValidatorOptionComboBox.addItem("None Selected");
            this.pc2ValidatorOptionComboBox.addItem("1 - diff");
            this.pc2ValidatorOptionComboBox.addItem("2 - ignore whitespace at start of file");
            this.pc2ValidatorOptionComboBox.addItem("3 - ignore leading whitespace on lines");
            this.pc2ValidatorOptionComboBox.addItem("4 - ignore all whitespace on lines");
            this.pc2ValidatorOptionComboBox.addItem("5 - ignore empty lines");
        }
        return this.pc2ValidatorOptionComboBox;
    }

    private JCheckBox getIgnoreCaseCheckBox() {
        if (this.ignoreCaseCheckBox == null) {
            this.ignoreCaseCheckBox = new JCheckBox();
            this.ignoreCaseCheckBox.setBounds(new Rectangle(27, 62, 263, 24));
            this.ignoreCaseCheckBox.setText("Ignore Case In Output");
            this.ignoreCaseCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.ignoreCaseCheckBox;
    }

    protected void showFilesDiff(String fileOne, String fileTwo) {
        String command = "gvim.exe -d " + fileOne + " " + fileTwo;
        System.out.println("cmd = " + command);
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            this.showMessage("Unable to diff " + e.getMessage());
            System.out.println("debug diff cmd: " + command);
            e.printStackTrace();
        }
    }

    private JPanel getExternalValidatorPane() {
        if (this.externalValidatorLabel == null) {
            this.externalValidatorLabel = new JLabel();
            this.externalValidatorLabel.setText("");
            this.externalValidatorLabel.setToolTipText("");
            this.externalValidatorPane = new JPanel();
            this.externalValidatorPane.setLayout(new BorderLayout());
            this.externalValidatorPane.setBounds(new Rectangle(140, 21, 267, 22));
            this.externalValidatorPane.add((Component)this.externalValidatorLabel, "Center");
        }
        return this.externalValidatorPane;
    }

    private JButton getValidatorProgramJButton() {
        if (this.validatorProgramJButton == null) {
            this.validatorProgramJButton = new JButton();
            this.validatorProgramJButton.setBounds(new Rectangle(425, 21, 34, 25));
            this.validatorProgramJButton.setText("...");
            this.validatorProgramJButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditProblemPaneNew.this.selectFile(EditProblemPaneNew.this.externalValidatorLabel, "Open Validator Program")) {
                        EditProblemPaneNew.this.externalValidatorLabel.setToolTipText(EditProblemPaneNew.this.externalValidatorLabel.getText());
                        EditProblemPaneNew.this.enableUpdateButton();
                    }
                }
            });
        }
        return this.validatorProgramJButton;
    }

    private JTextField getValidatorCommandLineTextBox() {
        if (this.validatorCommandLineTextBox == null) {
            this.validatorCommandLineTextBox = new JTextField();
            this.validatorCommandLineTextBox.setBounds(new Rectangle(17, 78, 432, 29));
            this.validatorCommandLineTextBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.validatorCommandLineTextBox;
    }

    private JCheckBox getShowCompareCheckBox() {
        if (this.showCompareCheckBox == null) {
            this.showCompareCheckBox = new JCheckBox();
            this.showCompareCheckBox.setText("Show Compare");
            this.showCompareCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.showCompareCheckBox;
    }

    private JCheckBox getDoShowOutputWindowCheckBox() {
        if (this.doShowOutputWindowCheckBox == null) {
            this.doShowOutputWindowCheckBox = new JCheckBox();
            this.doShowOutputWindowCheckBox.setSelected(true);
            this.doShowOutputWindowCheckBox.setText("Show the output window");
            this.doShowOutputWindowCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                    EditProblemPaneNew.this.getShowCompareCheckBox().setEnabled(EditProblemPaneNew.this.getDoShowOutputWindowCheckBox().isSelected());
                }
            });
        }
        return this.doShowOutputWindowCheckBox;
    }

    private ButtonGroup getValidatorChoiceButtonGroup() {
        if (this.validatorChoiceButtonGroup == null) {
            this.validatorChoiceButtonGroup = new ButtonGroup();
            this.validatorChoiceButtonGroup.add(this.getUseNOValidatatorRadioButton());
            this.validatorChoiceButtonGroup.add(this.getUsePC2ValidatorRadioButton());
            this.validatorChoiceButtonGroup.add(this.getUseExternalValidatorRadioButton());
        }
        return this.validatorChoiceButtonGroup;
    }

    private SerializedFile freshenIfNeeded(SerializedFile serializedFile, String fileName) {
        if (serializedFile == null) {
            return null;
        }
        if (serializedFile.getBuffer() == null) {
            throw new InvalidFieldValue("Unable to read file " + fileName + " choose file again (updating)");
        }
        if (fileName != null && fileName.equals(serializedFile.getAbsolutePath())) {
            if (!this.populatingGUI && this.needsFreshening(serializedFile, fileName)) {
                int result = JOptionPane.showConfirmDialog(this, "File (" + fileName + ") has changed; reload from disk?", "Freshen file " + serializedFile.getAbsolutePath() + "?", 0, 3);
                if (result == 0) {
                    serializedFile = new SerializedFile(serializedFile.getAbsolutePath());
                    this.checkFileFormat(serializedFile);
                    return serializedFile;
                }
                if (result == 2) {
                    throw new InvalidFieldValue("Update cancelled");
                }
            }
        } else if (fileName != null) {
            serializedFile = new SerializedFile(fileName);
        }
        this.checkFileFormat(serializedFile);
        return serializedFile;
    }

    public boolean needsFreshening(SerializedFile serializedFile, String fileName) {
        if (serializedFile == null) {
            return false;
        }
        try {
            File f = new File(serializedFile.getAbsolutePath());
            if (f.exists()) {
                SerializedFile newSerializedFile = new SerializedFile(f.getAbsolutePath());
                return !serializedFile.getSHA1sum().equals(newSerializedFile.getSHA1sum());
            }
        }
        catch (Exception ex99) {
            this.logDebugException("Exception ", ex99);
        }
        return false;
    }

    public boolean checkFileFormat(SerializedFile newFile) {
        if (newFile == null) {
            this.showMessage("Warning new file is null");
            return false;
        }
        int currentOS = 0;
        if (NL.length() == 2) {
            currentOS = 2;
        } else if (NL.charAt(0) == '\n') {
            currentOS = 8;
        } else if (NL.charAt(0) == '\r') {
            currentOS = 4;
        }
        if (currentOS != newFile.getFileType() && newFile.getFileType() != 1 && newFile.getFileType() != 16 && newFile.getFileType() != 32) {
            String fileName = newFile.getName();
            String question = "The file (" + fileName + ") you are loading appears to be of type '";
            if (newFile.getFileType() == 1) {
                question = String.valueOf(question) + "Binary";
            } else if (newFile.getFileType() == 2) {
                question = String.valueOf(question) + "DOS";
            } else if (newFile.getFileType() == 4) {
                question = String.valueOf(question) + "Apple";
            } else if (newFile.getFileType() == 8) {
                question = String.valueOf(question) + "Unix";
            } else if (newFile.getFileType() == 16) {
                question = String.valueOf(question) + "ASCII_Generic";
            } else if (newFile.getFileType() == 32) {
                question = String.valueOf(question) + "ASCII_Other";
            }
            question = String.valueOf(question) + "'." + NL + NL;
            question = String.valueOf(question) + "The Current OS is '" + System.getProperty("os.name", "?");
            question = String.valueOf(question) + "'." + NL + NL;
            question = String.valueOf(question) + "Do you want the file converted to the current OS file format as it is loaded into PC^2?";
            int answer = JOptionPane.showConfirmDialog(this, question, "File Format Mismatch", 1, 2);
            if (answer == 0) {
                newFile.convertFile(currentOS);
                return true;
            }
            if (answer == 2) {
                throw new InvalidFieldValue("Update canceled");
            }
        }
        return false;
    }

    void clearForm() {
        this.getAddButton().setVisible(true);
        this.getUpdateButton().setVisible(false);
        this.addButton.setEnabled(true);
        this.updateButton.setEnabled(false);
        this.problemNameTextField.setText("");
        this.timeOutSecondTextField.setText(Integer.toString(30));
        this.getProblemRequiresInputDataCheckBox().setSelected(false);
        this.getJudgesHaveProvidedAnswerFilesCheckBox().setSelected(false);
        this.fileRadioButton.setSelected(false);
        this.stdinRadioButton.setSelected(false);
        this.useNOValidatatorRadioButton.setSelected(true);
        this.pc2ValidatorOptionComboBox.setSelectedIndex(0);
        this.ignoreCaseCheckBox.setSelected(false);
        this.externalValidatorLabel.setText("");
        this.externalValidatorLabel.setToolTipText("");
        this.getValidatorCommandLineTextBox().setText(DEFAULT_INTERNATIONAL_VALIDATOR_COMMAND);
        this.getShowValidatorToJudges().setSelected(true);
        this.getDoShowOutputWindowCheckBox().setSelected(true);
        this.getShowCompareCheckBox().setSelected(true);
        this.getShowCompareCheckBox().setEnabled(this.getDoShowOutputWindowCheckBox().isSelected());
        this.getDeleteProblemCheckBox().setSelected(false);
        this.shortNameTextfield.setText("");
        this.populateJudging(null);
    }

    private JRadioButton getComputerJudging() {
        if (this.computerJudging == null) {
            this.computerJudging = new JRadioButton();
            this.computerJudging.setText("Computer Judging");
            this.computerJudging.setBounds(new Rectangle(32, 14, 173, 21));
            this.computerJudging.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.manualReview.setEnabled(true);
                    EditProblemPaneNew.this.prelimaryNotification.setEnabled(EditProblemPaneNew.this.manualReview.isSelected());
                    EditProblemPaneNew.this.prelimaryNotification.setEnabled(EditProblemPaneNew.this.manualReview.isSelected());
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.computerJudging;
    }

    private JRadioButton getManualJudging() {
        if (this.manualJudging == null) {
            this.manualJudging = new JRadioButton();
            this.manualJudging.setText("Manual Judging");
            this.manualJudging.setBounds(new Rectangle(32, 132, 257, 21));
            this.manualJudging.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.manualReview.setEnabled(false);
                    EditProblemPaneNew.this.prelimaryNotification.setEnabled(false);
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.manualJudging;
    }

    private JCheckBox getManualReview() {
        if (this.manualReview == null) {
            this.manualReview = new JCheckBox();
            this.manualReview.setText("Manual Review");
            this.manualReview.setBounds(new Rectangle(57, 47, 186, 21));
            this.manualReview.setEnabled(false);
            this.manualReview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.prelimaryNotification.setEnabled(EditProblemPaneNew.this.manualReview.isSelected());
                    EditProblemPaneNew.this.prelimaryNotification.setEnabled(EditProblemPaneNew.this.manualReview.isSelected());
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.manualReview;
    }

    private JCheckBox getPrelimaryNotification() {
        if (this.prelimaryNotification == null) {
            this.prelimaryNotification = new JCheckBox();
            this.prelimaryNotification.setText("Send Preliminary Notification to the team");
            this.prelimaryNotification.setBounds(new Rectangle(100, 80, 328, 21));
            this.prelimaryNotification.setEnabled(false);
            this.prelimaryNotification.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.prelimaryNotification;
    }

    private JCheckBox getDeleteProblemCheckBox() {
        if (this.deleteProblemCheckBox == null) {
            this.deleteProblemCheckBox = new JCheckBox();
            this.deleteProblemCheckBox.setText("Hide Problem");
            this.deleteProblemCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.deleteProblemCheckBox;
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("Load");
            this.loadButton.setToolTipText("Load problem def from problem.yaml");
            this.loadButton.setMnemonic(76);
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.loadProblemInfoFile();
                }
            });
        }
        return this.loadButton;
    }

    protected void loadProblemInfoFile() {
        this.showMessage("Load not implemented, yet.");
    }

    public File selectYAMLFileDialog(Component parent, String title, String startDirectory) {
        JFileChooser chooser = new JFileChooser(startDirectory);
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(0);
        FileNameExtensionFilter filterYAML = new FileNameExtensionFilter("YAML document (*.yaml)", "yaml");
        chooser.addChoosableFileFilter(filterYAML);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filterYAML);
        int action = chooser.showOpenDialog(parent);
        switch (action) {
            case 0: {
                File file = chooser.getSelectedFile();
                this.lastYamlLoadDirectory = chooser.getCurrentDirectory().toString();
                return file;
            }
        }
        return null;
    }

    public ContestYAMLLoader getLoader() {
        if (this.loader == null) {
            this.loader = new ContestYAMLLoader();
        }
        return this.loader;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton();
            this.exportButton.setText("Export");
            this.exportButton.setToolTipText("Export problem and files");
            this.exportButton.setMnemonic(88);
            this.exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (debug22EditProblem) {
                        EditProblemPaneNew.this.saveAndCopmpare();
                    }
                }
            });
        }
        return this.exportButton;
    }

    public static String getReportFilename(String prefix, IReport selectedReport) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String reportName = selectedReport.getReportTitle();
        while (reportName.indexOf(32) > -1) {
            reportName = reportName.replace(" ", "_");
        }
        return String.valueOf(prefix) + "report." + reportName + "." + simpleDateFormat.format(new Date()) + ".txt";
    }

    void saveAndCopmpare() {
        try {
            System.out.println("debug 22   ORIGINAL  load dump");
            Utilities.dump(this.originalProblemDataFiles, "debug 22 in load orig");
            String[] s2 = this.getTestDataList(this.originalProblemDataFiles);
            System.out.println("debug 22 Number of   ORIGINAL  problem data files is " + s2.length);
            String[] s = this.getTestDataList(this.newProblemDataFiles);
            System.out.println("debug 22 B4 Number of new problem data files is " + s.length);
            this.newProblemDataFiles = this.getProblemDataFilesFromFields();
            s = this.getTestDataList(this.newProblemDataFiles);
            System.out.println("debug 22 B5 Number of new problem data files is " + s.length);
            Problem newProblem = this.getProblemFromFields(this.problem, this.newProblemDataFiles, false);
            s = this.getTestDataList(this.newProblemDataFiles);
            System.out.println("debug 22 B6 Number of new problem data files is " + s.length);
            Utilities.dump(this.newProblemDataFiles, "debug 22 in load new");
            System.out.flush();
            String fileNameTwo = this.createProblemReport(newProblem, this.newProblemDataFiles, "stuf2");
            System.out.println("Created problem report " + this.fileNameOne);
            this.showFilesDiff(this.fileNameOne, fileNameTwo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String createProblemReport(Problem prob, ProblemDataFiles datafiles, String fileNamePrefix) {
        ProblemsReport report = new ProblemsReport();
        report.setContestAndController(this.getContest(), this.getController());
        String filename = EditProblemPaneNew.getReportFilename(String.valueOf(fileNamePrefix) + ".prob.txt", report);
        try {
            PrintWriter printWriter = null;
            printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
            if (this.problem == null) {
                printWriter.println("  Problem is null");
            } else {
                report.writeRow(printWriter, prob, datafiles);
            }
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        report = null;
        return filename;
    }

    protected void saveProblemYaml() {
        try {
            if (this.lastSaveDirectory == null) {
                this.lastSaveDirectory = String.valueOf(new File(".").getCanonicalPath()) + File.separator + "export";
            }
            char currentLetter = this.currentDirectoryLetter(this.lastSaveDirectory);
            String nextDirectory = this.findNextDirectory(this.lastSaveDirectory);
            ExportYAML exportYAML = new ExportYAML();
            this.newProblemDataFiles = this.getProblemDataFilesFromFields();
            Problem newProblem = this.getProblemFromFields(this.problem, this.newProblemDataFiles, false);
            String problemYamlFile = String.valueOf(nextDirectory) + File.separator + "problem.yaml";
            String[] filelist = exportYAML.writeProblemYAML(this.getContest(), newProblem, problemYamlFile, this.newProblemDataFiles);
            String results = this.compareDirectories(String.valueOf(this.lastSaveDirectory) + File.separator + currentLetter, nextDirectory);
            System.out.println("Comparison : " + results);
            System.out.println("Last dir: " + this.lastSaveDirectory);
            System.out.println("Wrote " + problemYamlFile);
            String[] stringArray = filelist;
            int n = filelist.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                System.out.println("Wrote " + string);
                ++n2;
            }
        }
        catch (Exception e) {
            this.showMessage("Error attempting to write Yaml, check logs" + e.getMessage());
            this.getLog().log(Log.WARNING, "Error attempting to write Yaml, check logs" + e.getMessage(), e);
            e.printStackTrace(System.err);
        }
    }

    char currentDirectoryLetter(String directory) {
        char letter = 'A';
        String nextDirectory = String.valueOf(directory) + File.separator + letter;
        File file = new File(nextDirectory);
        while (file.isDirectory()) {
            System.out.println("Found directory: " + nextDirectory);
            letter = (char)(letter + '\u0001');
            nextDirectory = String.valueOf(directory) + File.separator + letter;
            file = new File(nextDirectory);
            if (file.isDirectory()) continue;
            letter = (char)(letter - '\u0001');
        }
        return letter;
    }

    private String findNextDirectory(String directory) {
        char letter = this.currentDirectoryLetter(directory);
        String nextDirectory = String.valueOf(directory) + File.separator + letter;
        File file = new File(nextDirectory);
        while (file.isDirectory()) {
            System.out.println("Found directory: " + nextDirectory);
            letter = (char)(letter + '\u0001');
            nextDirectory = String.valueOf(directory) + File.separator + letter;
            file = new File(nextDirectory);
        }
        if (!file.isDirectory()) {
            file.mkdirs();
            System.out.println("Created dir " + nextDirectory);
        }
        return nextDirectory;
    }

    protected void goodsaveProblemYaml() {
        Problem newProblem = null;
        try {
            this.newProblemDataFiles = this.getProblemDataFilesFromFields();
            newProblem = this.getProblemFromFields(this.problem, this.newProblemDataFiles, false);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        try {
            JFileChooser chooser = new JFileChooser(this.lastSaveDirectory);
            FileNameExtensionFilter filterYAML = new FileNameExtensionFilter("YAML File", "yaml");
            chooser.setDialogTitle("Save problem to problem.YAML ");
            File file = new File("problem.yaml");
            chooser.setSelectedFile(file);
            chooser.setFileFilter(filterYAML);
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                File selectedFile = chooser.getSelectedFile().getCanonicalFile();
                if (selectedFile.exists() && (result = FrameUtilities.yesNoCancelDialog(this, "Overwrite " + selectedFile.getName(), "Overwrite existing file?")) != 0) {
                    return;
                }
                ExportYAML exportYAML = new ExportYAML();
                String[] filelist = exportYAML.writeProblemYAML(this.getContest(), newProblem, selectedFile.getAbsolutePath(), this.newProblemDataFiles);
                String fileComment = "";
                if (filelist.length > 0) {
                    fileComment = "(" + filelist.length + " data files written)";
                }
                this.showMessage("Wrote problem YAML to " + selectedFile.getName() + " " + fileComment);
                if (Utilities.isDebugMode()) {
                    FrameUtilities.viewFile(selectedFile.getAbsolutePath(), selectedFile.getName(), this.getLog());
                }
            } else {
                this.showMessage("No file selected/saved");
            }
        }
        catch (IOException e) {
            this.showMessage("Problem saving yaml file " + e.getMessage());
        }
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Report");
            this.reportButton.setMnemonic(82);
            this.reportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.viewProblemReport();
                }
            });
        }
        return this.reportButton;
    }

    protected void viewProblemReport() {
        SingleProblemReport singleProblemReport = new SingleProblemReport();
        try {
            this.newProblemDataFiles = this.getProblemDataFilesFromFields();
            Problem newProblem = this.getProblemFromFields(this.problem, this.newProblemDataFiles, false);
            singleProblemReport.setProblem(newProblem, this.newProblemDataFiles);
            Utilities.viewReport(singleProblemReport, "Problem Report " + this.getProblemNameTextField().getText(), this.getContest(), this.getController());
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
    }

    private JPanel getJudgeTypeInnerPane() {
        if (this.judgeTypeInnerPane == null) {
            this.judgeTypeInnerPane = new JPanel();
            this.judgeTypeInnerPane.setLayout(null);
            this.judgeTypeInnerPane.setPreferredSize(new Dimension(190, 190));
            this.judgeTypeInnerPane.add((Component)this.getComputerJudging(), null);
            this.judgeTypeInnerPane.add((Component)this.getManualReview(), null);
            this.judgeTypeInnerPane.add((Component)this.getPrelimaryNotification(), null);
            this.judgeTypeInnerPane.add((Component)this.getManualJudging(), null);
        }
        return this.judgeTypeInnerPane;
    }

    private JPanel getCcsSettingsPane() {
        if (this.ccsSettingsPane == null) {
            this.ccsSettingsPane = new JPanel();
            this.ccsSettingsPane.setLayout(null);
            this.ccsSettingsPane.setBorder(BorderFactory.createTitledBorder(null, "CCS Standard Problem Settings", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.ccsSettingsPane.add((Component)this.getCcsValidationEnabledCheckBox(), null);
        }
        return this.ccsSettingsPane;
    }

    private JCheckBox getCcsValidationEnabledCheckBox() {
        if (this.ccsValidationEnabledCheckBox == null) {
            this.ccsValidationEnabledCheckBox = new JCheckBox();
            this.ccsValidationEnabledCheckBox.setToolTipText("Use validator that uses exit code to return judgement");
            this.ccsValidationEnabledCheckBox.setBounds(new Rectangle(27, 33, 375, 28));
            this.ccsValidationEnabledCheckBox.setText("Use CCS validator interface");
            this.ccsValidationEnabledCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.ccsValidationEnabledCheckBox;
    }

    public String compareDirectories(String directory, String nextDirectory) {
        ArrayList<String> filelist = this.getFileEntries(directory, "", 0);
        ArrayList<String> filelistTwo = this.getFileEntries(nextDirectory, "", 0);
        int matching = 0;
        if (filelist.size() == filelistTwo.size()) {
            int i = 0;
            while (i < filelist.size()) {
                String name2;
                String name1 = filelist.get(i);
                if (name1.equals(name2 = filelistTwo.get(i))) {
                    ++matching;
                } else {
                    System.err.println("Miss match " + name1 + " vs " + name2);
                }
                ++i;
            }
        }
        if (matching == filelist.size()) {
            return "All " + matching + " matching";
        }
        return String.valueOf(filelist.size()) + " vs " + filelistTwo.size();
    }

    private ArrayList<String> getFileEntries(String directory, String relativeDirectory, int level) {
        File entry;
        ArrayList<String> list = new ArrayList<String>();
        File[] files = new File(directory).listFiles();
        if (relativeDirectory.length() > 0) {
            relativeDirectory = String.valueOf(relativeDirectory) + File.separator;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            entry = fileArray[n2];
            if (entry.isFile()) {
                list.add(String.valueOf(relativeDirectory) + entry.getName());
            }
            ++n2;
        }
        fileArray = files;
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            entry = fileArray[n2];
            if (entry.isDirectory() && !entry.getName().equals(".") && !entry.getName().equals("..")) {
                list.addAll(this.getFileEntries(String.valueOf(directory) + File.separator + entry.getName(), String.valueOf(relativeDirectory) + entry.getName(), level + 1));
            }
            ++n2;
        }
        return list;
    }

    public JTextField getShortNameTextfield() {
        return this.shortNameTextfield;
    }

    private JPanel getProblemDescriptionPanel() {
        if (this.problemDescriptionPanel == null) {
            this.problemDescriptionPanel = new JPanel();
            this.problemDescriptionPanel.setAlignmentX(0.0f);
            this.problemDescriptionPanel.setPreferredSize(new Dimension(100, 100));
            this.problemDescriptionPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Problem Description", 4, 2, new Font("Dialog", 1, 12), new Color(0, 0, 0)));
            this.problemDescriptionPanel.setLayout(new GridLayout(0, 3, 5, 5));
            this.problemNameLabel = new JLabel();
            this.problemNameLabel.setHorizontalAlignment(4);
            this.problemNameLabel.setSize(new Dimension(10, 30));
            this.problemNameLabel.setPreferredSize(new Dimension(100, 50));
            this.problemNameLabel.setMinimumSize(new Dimension(100, 30));
            this.problemNameLabel.setMaximumSize(new Dimension(100, 40));
            this.problemNameLabel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.problemNameLabel.setAlignmentX(1.0f);
            this.problemDescriptionPanel.add(this.problemNameLabel);
            this.problemNameLabel.setText("        Problem Name");
            this.problemDescriptionPanel.add(this.getProblemNameTextField());
            this.problemDescriptionPanel.add(this.getLblSpacer1());
            JLabel lblShortName = new JLabel();
            lblShortName.setHorizontalAlignment(4);
            this.problemDescriptionPanel.add(lblShortName);
            lblShortName.setText("        Short Name");
            this.shortNameTextfield = new JTextField();
            this.problemDescriptionPanel.add(this.shortNameTextfield);
            this.shortNameTextfield.setPreferredSize(new Dimension(150, 20));
            this.shortNameTextfield.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
            this.problemDescriptionPanel.add(this.getLblSpacer2());
            this.timeoutLabel = new JLabel();
            this.timeoutLabel.setHorizontalAlignment(4);
            this.problemDescriptionPanel.add(this.timeoutLabel);
            this.timeoutLabel.setText("        Run Timeout Limit (Secs)");
            this.problemDescriptionPanel.add(this.getTimeOutSecondTextField());
        }
        return this.problemDescriptionPanel;
    }

    private JPanel getProblemDataFilesPanel() {
        if (this.problemDataFilesPanel == null) {
            this.problemDataFilesPanel = new JPanel();
            this.problemDataFilesPanel.setMaximumSize(new Dimension(600, 500));
            this.problemDataFilesPanel.setMinimumSize(new Dimension(600, 500));
            this.problemDataFilesPanel.setPreferredSize(new Dimension(600, 500));
            this.problemDataFilesPanel.setAlignmentX(0.0f);
            this.problemDataFilesPanel.setPreferredSize(new Dimension(600, 500));
            this.problemDataFilesPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Problem Data Files", 4, 2, new Font("Dialog", 1, 12), new Color(0, 0, 0)));
            GroupLayout gl_problemDataFilesPanel = new GroupLayout(this.problemDataFilesPanel);
            gl_problemDataFilesPanel.setHorizontalGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_problemDataFilesPanel.createSequentialGroup().addGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(gl_problemDataFilesPanel.createSequentialGroup().addGap(30).addGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getInputDataStoragePanel(), -1, 583, Short.MAX_VALUE).addComponent(this.getTeamReadsFromPanel(), 0, 0, Short.MAX_VALUE))).addGroup(gl_problemDataFilesPanel.createSequentialGroup().addContainerGap().addGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getJudgesHaveProvidedAnswerFilesCheckBox()).addComponent(this.getProblemRequiresInputDataCheckBox())))).addContainerGap()));
            gl_problemDataFilesPanel.setVerticalGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_problemDataFilesPanel.createSequentialGroup().addContainerGap().addComponent(this.getProblemRequiresInputDataCheckBox()).addGap(9).addComponent(this.getTeamReadsFromPanel(), -2, -1, -2).addGap(18).addComponent(this.getInputDataStoragePanel(), -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.getJudgesHaveProvidedAnswerFilesCheckBox()).addContainerGap()));
            this.problemDataFilesPanel.setLayout(gl_problemDataFilesPanel);
        }
        return this.problemDataFilesPanel;
    }

    private JLabel getLblSpacer1() {
        if (this.lblSpacer1 == null) {
            this.lblSpacer1 = new JLabel("");
        }
        return this.lblSpacer1;
    }

    private JLabel getLblSpacer2() {
        if (this.lblSpacer2 == null) {
            this.lblSpacer2 = new JLabel("");
        }
        return this.lblSpacer2;
    }

    private JPanel getJudgingDisplayOptionsPanel() {
        if (this.judgingDisplayOptionsPanel == null) {
            this.judgingDisplayOptionsPanel = new JPanel();
            this.judgingDisplayOptionsPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Judging Display Options", 4, 2, new Font("Dialog", 1, 12), new Color(0, 0, 0)));
            this.judgingDisplayOptionsPanel.setAlignmentX(0.0f);
            this.judgingDisplayOptionsPanel.add(this.getShowCompareCheckBox());
            this.judgingDisplayOptionsPanel.add(this.getHorizontalStrut_4());
            this.judgingDisplayOptionsPanel.add(this.getDoShowOutputWindowCheckBox());
            this.judgingDisplayOptionsPanel.add(this.getHorizontalStrut_5());
            this.judgingDisplayOptionsPanel.add(this.getDeleteProblemCheckBox());
        }
        return this.judgingDisplayOptionsPanel;
    }

    private JPanel getInputDataStoragePanel() {
        if (this.inputDataStoragePanel == null) {
            this.inputDataStoragePanel = new JPanel();
            this.inputDataStoragePanel.setMaximumSize(new Dimension(500, 200));
            this.inputDataStoragePanel.setPreferredSize(new Dimension(470, 80));
            this.inputDataStoragePanel.setAlignmentX(0.0f);
            this.inputDataStoragePanel.setBorder(new TitledBorder(null, "Input Data Storage", 4, 2, new Font("Dialog", 1, 12), null));
            this.inputDataStoragePanel.setLayout(new BoxLayout(this.inputDataStoragePanel, 1));
            this.inputDataStoragePanel.add(this.getRdbtnCopyFilesToInternal());
            this.inputDataStoragePanel.add(this.getRdbtnKeepFilesExternal());
        }
        return this.inputDataStoragePanel;
    }

    private JRadioButton getRdbtnCopyFilesToInternal() {
        if (this.rdbtnCopyFilesToInternal == null) {
            this.rdbtnCopyFilesToInternal = new JRadioButton("Copy Data Files into PC2 (more efficient, but to 5MB total per problem)");
            this.rdbtnCopyFilesToInternal.setSelected(true);
            this.rdbtnCopyFilesToInternal.setMaximumSize(new Dimension(550, 30));
            this.rdbtnCopyFilesToInternal.setMinimumSize(new Dimension(550, 30));
            this.rdbtnCopyFilesToInternal.setPreferredSize(new Dimension(550, 30));
            this.rdbtnCopyFilesToInternal.setBorder(new EmptyBorder(0, 15, 0, 0));
        }
        return this.rdbtnCopyFilesToInternal;
    }

    private JRadioButton getRdbtnKeepFilesExternal() {
        if (this.rdbtnKeepFilesExternal == null) {
            this.rdbtnKeepFilesExternal = new JRadioButton("Keep Data Files external to PC2 (requires you to copy files to Judge's machines)");
            this.rdbtnKeepFilesExternal.setMaximumSize(new Dimension(550, 30));
            this.rdbtnKeepFilesExternal.setMinimumSize(new Dimension(550, 30));
            this.rdbtnKeepFilesExternal.setPreferredSize(new Dimension(550, 30));
            this.rdbtnKeepFilesExternal.setBorder(new EmptyBorder(0, 15, 0, 0));
        }
        return this.rdbtnKeepFilesExternal;
    }

    private Component getHorizontalStrut_4() {
        if (this.horizontalStrut_4 == null) {
            this.horizontalStrut_4 = Box.createHorizontalStrut(20);
        }
        return this.horizontalStrut_4;
    }

    private Component getHorizontalStrut_5() {
        if (this.horizontalStrut_5 == null) {
            this.horizontalStrut_5 = Box.createHorizontalStrut(20);
        }
        return this.horizontalStrut_5;
    }

    private JCheckBox getJudgesHaveProvidedAnswerFilesCheckBox() {
        if (this.judgesHaveProvidedAnswerFilesCheckBox == null) {
            this.judgesHaveProvidedAnswerFilesCheckBox = new JCheckBox("Judges Have Provided Answer Files");
            this.judgesHaveProvidedAnswerFilesCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditProblemPaneNew.this.enableProvideAnswerFileComponents(EditProblemPaneNew.this.getJudgesHaveProvidedAnswerFilesCheckBox().isSelected());
                    EditProblemPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.judgesHaveProvidedAnswerFilesCheckBox;
    }
}

