/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.ui.EditProblemPaneNew;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditProblemFrameNew
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -5684386608226303728L;
    private IInternalContest contest;
    private IInternalController controller;
    private EditProblemPaneNew problemPane = null;

    public EditProblemFrameNew() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(700, 650));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getProblemPane());
        this.setTitle("New Problem");
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getProblemPane().setContestAndController(this.contest, this.controller);
        this.problemPane.setParentFrame(this);
    }

    public void setProblem(Problem problem) {
        if (problem == null) {
            this.setTitle("Add New Problem");
        } else {
            this.setTitle("Edit Problem " + problem.getDisplayName());
            if (problem.isUsingExternalDataFiles()) {
                this.setTitle("Edit Problem " + problem.getDisplayName() + " [External/CCS]");
            }
        }
        this.getProblemPane().setProblem(problem);
    }

    public void setProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        this.setTitle("Add New Problem");
        if (problem == null) {
            this.setTitle("Add New Problem");
            this.getProblemPane().setProblem(problem);
        } else {
            this.setTitle("Edit Problem " + problem.getDisplayName());
            if (problem.isUsingExternalDataFiles()) {
                this.setTitle("Edit Problem " + problem.getDisplayName() + " (" + problem.getExternalDataFileLocation() + ")");
            }
            this.getProblemPane().setProblem(problem, problemDataFiles);
        }
    }

    @Override
    public String getPluginTitle() {
        return "Edit Problem Frame";
    }

    private EditProblemPaneNew getProblemPane() {
        if (this.problemPane == null) {
            this.problemPane = new EditProblemPaneNew();
        }
        return this.problemPane;
    }

    public void setProblemCopy(Problem problem, ProblemDataFiles problemDataFiles) {
        this.setTitle("Add New Problem");
        this.getProblemPane().setProblem(problem, problemDataFiles);
    }
}

