/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.ui.EditLanguagePane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditLanguageFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -6248957592340866836L;
    private IInternalContest contest;
    private IInternalController controller;
    private EditLanguagePane languagePane = null;

    public EditLanguageFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(549, 345));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getLanguagePane());
        this.setTitle("New Language");
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getLanguagePane().setContestAndController(this.contest, this.controller);
        this.getLanguagePane().setParentFrame(this);
    }

    public void setLanguage(Language language) {
        if (language == null) {
            this.setTitle("Add New Language");
        } else {
            this.setTitle("Edit Language " + language.getDisplayName());
        }
        this.getLanguagePane().setLanguage(language);
    }

    @Override
    public String getPluginTitle() {
        return "Edit Language Frame";
    }

    private EditLanguagePane getLanguagePane() {
        if (this.languagePane == null) {
            this.languagePane = new EditLanguagePane();
        }
        return this.languagePane;
    }
}

