/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.JudgementNotification;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.ui.EditJudgementNotificationPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IEditChangeCallback;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditJudgementNotificationFrame
extends JFrame
implements UIPlugin,
IEditChangeCallback {
    private static final long serialVersionUID = -2280462320664391007L;
    private JPanel mainPanel = null;
    private JPanel buttonPane = null;
    private JButton updateButton = null;
    private JTabbedPane problemTabbedPane = null;
    private JButton closeButton = null;
    private IInternalController controller;
    private IInternalContest contest;
    private Log log = null;
    private JLabel remainingTimeLabel = null;

    public EditJudgementNotificationFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(750, 349));
        this.setTitle("End of Contest Notification Control");
        this.setContentPane(this.getMainPanel());
        FrameUtilities.centerFrame(this);
    }

    @Override
    public String getPluginTitle() {
        return "Edit Judgement Notifications Frame";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
        this.contest.addProblemListener(new ProblemListenerImplementation());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditJudgementNotificationFrame.this.populateUI();
            }
        });
    }

    protected void populateUI() {
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            this.addProblemTab(problem);
            ++n2;
        }
        this.updateRemainingTime();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getButtonPane(), "South");
            this.mainPanel.add((Component)this.getProblemTabbedPane(), "Center");
        }
        return this.mainPanel;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.remainingTimeLabel = new JLabel();
            this.remainingTimeLabel.setText("XXX min remaining in contest");
            this.remainingTimeLabel.setHorizontalAlignment(4);
            this.remainingTimeLabel.setPreferredSize(new Dimension(200, 20));
            this.remainingTimeLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        EditJudgementNotificationFrame.this.updateRemainingTime();
                    }
                }
            });
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(55);
            flowLayout.setAlignment(0);
            this.buttonPane = new JPanel();
            this.buttonPane.setPreferredSize(new Dimension(540, 36));
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.remainingTimeLabel, null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditJudgementNotificationFrame.this.updateEOCSettings();
                }
            });
        }
        return this.updateButton;
    }

    protected void dumpNotification(String title, NotificationSetting notificationSetting2) {
        System.out.println();
        System.out.println("Dump for: " + title);
        if (notificationSetting2 == null) {
            System.out.println("          No delivery notification settings defined.");
        } else {
            JudgementNotification judgementNotification = null;
            judgementNotification = notificationSetting2.getPreliminaryNotificationYes();
            System.out.println("          Prelim Yes suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getPreliminaryNotificationNo();
            System.out.println("          Prelim No  suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getFinalNotificationYes();
            System.out.println("          Final  Yes suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getFinalNotificationNo();
            System.out.println("          Final  No  suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
        }
    }

    protected JudgementNotificationsList getJudgementNotificationFromFields() {
        JudgementNotificationsList newJudgementNotificationsList = new JudgementNotificationsList();
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            EditJudgementNotificationPane pane = this.getPaneForProblem(problem);
            if (pane != null) {
                NotificationSetting notificationSetting = pane.getNotificationSettingFromFields();
                newJudgementNotificationsList.update(notificationSetting);
            }
            ++n2;
        }
        return newJudgementNotificationsList;
    }

    protected void updateEOCSettings() {
        try {
            ContestInformation contestInformation = this.contest.getContestInformation();
            JudgementNotificationsList judgementNotificationsList = this.getJudgementNotificationFromFields();
            contestInformation.setJudgementNotificationsList(judgementNotificationsList);
            this.controller.updateContestInformation(contestInformation);
            this.updateButtonState(false);
            this.setVisible(false);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception updating/saving notifications", e);
            JOptionPane.showMessageDialog(this, "Internal Exception, check log. " + e.getMessage());
            e.printStackTrace();
        }
    }

    private JTabbedPane getProblemTabbedPane() {
        if (this.problemTabbedPane == null) {
            this.problemTabbedPane = new JTabbedPane();
            this.problemTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EditJudgementNotificationFrame.this.updateRemainingTime();
                }
            });
        }
        return this.problemTabbedPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditJudgementNotificationFrame.this.handleCancelButton();
                }
            });
        }
        return this.closeButton;
    }

    protected void handleCancelButton() {
        this.updateRemainingTime();
        if (this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this, "Notifications modified, save changes?", "Confirm Choice");
            if (result == 0) {
                this.updateEOCSettings();
                this.setVisible(false);
            } else if (result == 1) {
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private EditJudgementNotificationPane getPaneForProblem(Problem problem) {
        String tabName = this.getTabName(problem);
        Component[] componentArray = this.getProblemTabbedPane().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (tabName.equals(component.getName())) {
                return (EditJudgementNotificationPane)component;
            }
            ++n2;
        }
        return null;
    }

    private String getTabName(Problem problem) {
        return "Problem " + this.getProblemLetter(problem);
    }

    public void addProblemTab(final Problem problem) {
        final NotificationSetting notificationSetting = new NotificationSetting(problem.getElementId());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditJudgementNotificationPane editJudgementNotificationPane = new EditJudgementNotificationPane(notificationSetting, EditJudgementNotificationFrame.this.getThis());
                editJudgementNotificationPane.setContestAndController(EditJudgementNotificationFrame.this.contest, null);
                String tabName = EditJudgementNotificationFrame.this.getTabName(problem);
                editJudgementNotificationPane.setName(tabName);
                EditJudgementNotificationFrame.this.getProblemTabbedPane().add(tabName, editJudgementNotificationPane);
                EditJudgementNotificationFrame.this.itemChanged(null);
            }
        });
    }

    public void resetAllNotificationSettings() {
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            EditJudgementNotificationPane pane = this.getPaneForProblem(problem);
            if (pane == null) {
                this.addProblemTab(problem);
            } else {
                NotificationSetting notificationSetting = this.getNotificationSetting(problem);
                if (notificationSetting == null) {
                    notificationSetting = new NotificationSetting(problem.getElementId());
                }
                pane.setNotificationSetting(notificationSetting);
            }
            ++n2;
        }
        this.updateButtonState(false);
        this.updateRemainingTime();
    }

    private NotificationSetting getNotificationSetting(Problem problem) {
        ContestInformation contestInformation = this.contest.getContestInformation();
        JudgementNotificationsList judgementNotificationsList = contestInformation.getJudgementNotificationsList();
        if (judgementNotificationsList == null) {
            return null;
        }
        return judgementNotificationsList.get(problem);
    }

    protected void updateProblemTab(Problem problem) {
        EditJudgementNotificationPane pane = this.getPaneForProblem(problem);
        if (pane != null) {
            pane.setTitle(problem.getDisplayName());
        }
    }

    protected String getProblemLetter(Problem problem) {
        char let = 'A';
        int count = 0;
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem2 = problemArray[n2];
            if (problem2.equals(problem)) {
                let = (char)(let + count);
            }
            ++count;
            ++n2;
        }
        return "" + let;
    }

    protected void updateRemainingTime() {
        ContestTime contestTime = this.contest.getContestTime();
        long minLeft = contestTime.getRemainingSecs() / 60L;
        this.remainingTimeLabel.setText(String.valueOf(minLeft) + " mins from end of contest");
        this.remainingTimeLabel.setToolTipText(String.valueOf(contestTime.getElapsedTimeStr()) + " elapsed minutes");
    }

    @Override
    public void itemChanged(JComponent component) {
        ContestInformation contestInformation = this.contest.getContestInformation();
        JudgementNotificationsList originalJudgementNotificationsList = contestInformation.getJudgementNotificationsList();
        boolean changed = false;
        if (originalJudgementNotificationsList != null) {
            JudgementNotificationsList judgementNotificationsList = this.getJudgementNotificationFromFields();
            if (judgementNotificationsList.getList().length != originalJudgementNotificationsList.getList().length) {
                changed = true;
            } else {
                NotificationSetting[] notificationSettingArray = judgementNotificationsList.getList();
                int n = notificationSettingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NotificationSetting setting = notificationSettingArray[n2];
                    ElementId elementId = setting.getElementId();
                    NotificationSetting setting2 = (NotificationSetting)originalJudgementNotificationsList.get(elementId);
                    if (setting2 == null) {
                        changed = true;
                        break;
                    }
                    if (!setting.isSameAs(setting2)) {
                        changed = true;
                    }
                    ++n2;
                }
            }
        }
        this.updateButtonState(changed);
    }

    protected void updateButtonState(boolean changed) {
        this.getUpdateButton().setEnabled(changed);
        if (changed) {
            this.getCloseButton().setText("Cancel");
        } else {
            this.getCloseButton().setText("Close");
        }
    }

    protected IEditChangeCallback getThis() {
        return this;
    }

    private class ProblemListenerImplementation
    implements IProblemListener {
        private ProblemListenerImplementation() {
        }

        @Override
        public void problemAdded(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditJudgementNotificationFrame.this.addProblemTab(event.getProblem());
                }
            });
        }

        @Override
        public void problemChanged(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditJudgementNotificationFrame.this.updateProblemTab(event.getProblem());
                }
            });
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
            this.problemChanged(event);
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditJudgementNotificationFrame.this.populateUI();
                }
            });
        }
    }
}

