/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.EventFeedDefinition;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EditEventFeedDefinitionPane
extends JPanePlugin {
    private static final long serialVersionUID = 5201693671680464978L;
    private JPanel centerPane = null;
    private JPanel buttonPanel = null;
    private JButton cancelButton = null;
    private JButton addButton = null;
    private JTextField nameTextField;
    private JTextField portTextField;
    private JCheckBox activeCheckBox = null;
    private JCheckBox frozenCheckBox = null;
    private boolean populatingGUI;
    private EventFeedDefinition existingEventDefinition = null;

    public EditEventFeedDefinitionPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(399, 232));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    @Override
    public String getPluginTitle() {
        return "Edit Event Feed Definition Plugin";
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            JLabel lblNewLabel = new JLabel("Title");
            lblNewLabel.setHorizontalAlignment(4);
            lblNewLabel.setBounds(76, 26, 74, 14);
            this.centerPane.add(lblNewLabel);
            JLabel lblactuve = new JLabel("Port");
            lblactuve.setHorizontalAlignment(4);
            lblactuve.setBounds(76, 102, 74, 14);
            this.centerPane.add(lblactuve);
            this.nameTextField = new JTextField();
            this.nameTextField.setBounds(167, 24, 196, 20);
            this.centerPane.add(this.nameTextField);
            this.nameTextField.setColumns(10);
            this.activeCheckBox = new JCheckBox("Active");
            this.activeCheckBox.setToolTipText("Is the event feed active?");
            this.activeCheckBox.setBounds(167, 60, 97, 23);
            this.centerPane.add(this.activeCheckBox);
            this.frozenCheckBox = new JCheckBox("Frozen");
            this.frozenCheckBox.setToolTipText("Stop sending judgements near end of contest");
            this.frozenCheckBox.setBounds(167, 137, 97, 23);
            this.centerPane.add(this.frozenCheckBox);
            this.portTextField = new JTextField();
            this.portTextField.setBounds(167, 100, 51, 20);
            this.centerPane.add(this.portTextField);
            this.portTextField.setColumns(10);
            this.portTextField.setDocument(new IntegerDocument());
        }
        return this.centerPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.setPreferredSize(new Dimension(35, 35));
            this.buttonPanel.add((Component)this.getAddButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditEventFeedDefinitionPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditEventFeedDefinitionPane.this.populateGUI(null);
            }
        });
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Event Feed Definition modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addEventFeedDefinition();
                } else {
                    this.updateEventFeedDefinition();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private void updateEventFeedDefinition() {
    }

    private void addEventFeedDefinition() {
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditEventFeedDefinitionPane.this.addDef();
                }
            });
        }
        return this.addButton;
    }

    protected void addDef() {
    }

    public JCheckBox getActiveCheckBox() {
        return this.activeCheckBox;
    }

    public JCheckBox getFrozenCheckBox() {
        return this.frozenCheckBox;
    }

    void populateGUI(EventFeedDefinition eventDefinition) {
        this.populatingGUI = true;
        try {
            if (eventDefinition == null) {
                this.getActiveCheckBox().setSelected(true);
                this.getFrozenCheckBox().setSelected(false);
                this.nameTextField.setText("");
                this.portTextField.setText("3700");
            } else {
                this.getActiveCheckBox().setSelected(eventDefinition.isActive());
                this.getFrozenCheckBox().setSelected(eventDefinition.isFrozen());
                this.nameTextField.setText(eventDefinition.getDisplayName());
                this.portTextField.setText(new Integer(eventDefinition.getPort()).toString());
            }
            this.setAddButtonState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.populatingGUI = false;
    }

    public void setEventDefinition(EventFeedDefinition eventDefinition) {
        this.existingEventDefinition = eventDefinition;
        this.populateGUI(eventDefinition);
    }

    public void setAddButtonState() {
        if (this.existingEventDefinition == null) {
            this.getAddButton().setText("Add");
            this.getAddButton().setToolTipText("Add this definition");
            this.getAddButton().setMnemonic(65);
        } else {
            this.getAddButton().setText("Update");
            this.getAddButton().setToolTipText("Update this definition");
            this.getAddButton().setMnemonic(85);
        }
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean changed = false;
        EventFeedDefinition definition = this.getEventFeedDefinitionFromFields();
        if (this.existingEventDefinition != null) {
            changed = this.existingEventDefinition.isSameAs(definition);
        }
        this.getAddButton().setEnabled(changed);
        if (changed) {
            this.getCancelButton().setText("Cancel");
            this.getAddButton().setMnemonic(67);
        } else {
            this.getCancelButton().setText("Close");
            this.getAddButton().setMnemonic(67);
        }
    }

    private EventFeedDefinition getEventFeedDefinitionFromFields() {
        String name = this.nameTextField.getText();
        EventFeedDefinition def = new EventFeedDefinition(name);
        def.setActive(this.getActiveCheckBox().isSelected());
        def.setFrozen(this.getFrozenCheckBox().isSelected());
        def.setPort(Integer.parseInt(this.portTextField.getText()));
        return def;
    }
}

