/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.ICountDownMessage;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.RomanNumeral;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CountDownMessage
extends JDialog
implements ActionListener,
ICountDownMessage {
    private static final long serialVersionUID = -1066929023214360936L;
    private JPanel contentsPanel = null;
    private JPanel southPane = null;
    private JPanel centerPane = null;
    private JButton closeButton = null;
    private JLabel countdownTimerLabel = null;
    private boolean exitOnClose = false;
    private String prefixToTime = "";
    private int inputRemainingSeconds = 10;
    private Timer timer = new Timer(500, this);
    private long endMilliSeconds;

    public CountDownMessage() {
        this.initialize();
    }

    @Override
    public void start(String prefixForCount, int seconds) {
        this.setRemainingSeconds(seconds);
        this.endMilliSeconds = new Date().getTime() + (long)(this.inputRemainingSeconds * 1000);
        this.setPrefixToTime(prefixForCount);
        String remainSring = String.valueOf(this.prefixToTime) + new RomanNumeral(seconds).toString() + " seconds";
        this.countdownTimerLabel.setText(remainSring);
        this.setEnabled(true);
        this.setVisible(true);
        this.timer.start();
    }

    private void initialize() {
        this.setSize(new Dimension(503, 135));
        this.setContentPane(this.getContentsPanel());
        this.setTitle("Countdown Message");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CountDownMessage.this.actionOnClose();
            }
        });
        FrameUtilities.centerFrameTop(this);
    }

    private JPanel getContentsPanel() {
        if (this.contentsPanel == null) {
            this.contentsPanel = new JPanel();
            this.contentsPanel.setLayout(new BorderLayout());
            this.contentsPanel.add((Component)this.getSouthPane(), "South");
            this.contentsPanel.add((Component)this.getCenterPane(), "Center");
        }
        return this.contentsPanel;
    }

    private JPanel getSouthPane() {
        if (this.southPane == null) {
            this.southPane = new JPanel();
            this.southPane.add((Component)this.getCloseButton(), null);
        }
        return this.southPane;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.countdownTimerLabel = new JLabel();
            this.countdownTimerLabel.setText("");
            this.countdownTimerLabel.setFont(new Font("Dialog", 0, 18));
            this.countdownTimerLabel.setHorizontalAlignment(0);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)this.countdownTimerLabel, "Center");
        }
        return this.centerPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setMnemonic(67);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CountDownMessage.this.actionOnClose();
                }
            });
        }
        return this.closeButton;
    }

    public void actionOnClose() {
        if (this.exitOnClose) {
            System.exit(4);
        } else {
            this.timer.stop();
            this.dispose();
        }
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    @Override
    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public int getRemainingSeconds() {
        return this.inputRemainingSeconds;
    }

    public void setRemainingSeconds(int remainingSeconds) {
        this.inputRemainingSeconds = remainingSeconds;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        long remainingSeconds = (this.endMilliSeconds - new Date().getTime()) / 1000L;
        String message = new String();
        message = remainingSeconds >= 1L ? String.valueOf(this.prefixToTime) + new RomanNumeral(remainingSeconds).toString() + " seconds" : String.valueOf(this.prefixToTime) + "0 seconds";
        this.countdownTimerLabel.setText(message);
        System.out.println("Remaining " + message);
        if (remainingSeconds < 1L) {
            this.actionOnClose();
        }
    }

    public String getPrefixToTime() {
        return this.prefixToTime;
    }

    public void setPrefixToTime(String prefixToTime) {
        if (prefixToTime != null) {
            this.prefixToTime = prefixToTime;
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
    }

    @Override
    public String getPluginTitle() {
        return "Countdown timer";
    }
}

