/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BalloonColorListPane
extends JPanePlugin {
    private static final long serialVersionUID = -7483784815760107250L;
    private JPanel balloonColorListButtonPane = null;
    private MCLB balloonColorListBox = null;
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;

    public BalloonColorListPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)this.getMessagePanel(), "North");
        this.add((Component)((Object)this.getBalloonColorListBox()), "Center");
        this.add((Component)this.getBalloonColorListButtonPane(), "South");
    }

    @Override
    public String getPluginTitle() {
        return "BalloonColorList Pane";
    }

    private JPanel getBalloonColorListButtonPane() {
        if (this.balloonColorListButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.balloonColorListButtonPane = new JPanel();
            this.balloonColorListButtonPane.setLayout(flowLayout);
            this.balloonColorListButtonPane.setPreferredSize(new Dimension(35, 35));
        }
        return this.balloonColorListButtonPane;
    }

    private MCLB getBalloonColorListBox() {
        if (this.balloonColorListBox == null) {
            this.balloonColorListBox = new MCLB();
        }
        return this.balloonColorListBox;
    }

    private String yesNoString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    protected Object[] buildBalloonSettingsRow(BalloonSettings balloonSettings) {
        int numberColumns = this.getBalloonColorListBox().getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = "Site " + balloonSettings.getSiteNumber();
        c[1] = this.yesNoString(balloonSettings.isPrintBalloons());
        c[2] = this.yesNoString(balloonSettings.isEmailBalloons());
        c[3] = balloonSettings.getPrintDevice();
        c[4] = balloonSettings.getEmailContact();
        c[5] = balloonSettings.getMailServer();
        c[6] = balloonSettings.getBalloonClient().toString();
        return c;
    }

    private void reloadListBox() {
        this.getBalloonColorListBox().removeAllColumns();
        Object[] cols = new Object[this.getContest().getSites().length + 1];
        cols[0] = "Problem";
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        int i = 1;
        Site[] siteArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            cols[i] = site.getDisplayName();
            ++i;
            ++n2;
        }
        this.balloonColorListBox.addColumns(cols);
        Problem[] problems = this.getContest().getProblems();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        Problem[] problemArray = problems;
        int n3 = problems.length;
        n = 0;
        while (n < n3) {
            Problem problem = problemArray[n];
            this.addBalloonColorRow(problem, sites);
            ++n;
        }
        this.balloonColorListBox.autoSizeAllColumns();
    }

    private void addBalloonColorRow(Problem problem, Site[] sites) {
        Object[] row = this.buildBalloonColorRow(problem, sites);
        this.getBalloonColorListBox().addRow(row, problem);
    }

    private Object[] buildBalloonColorRow(Problem problem, Site[] sites) {
        int numberColumns = this.getBalloonColorListBox().getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = problem.getDisplayName();
        int i = 1;
        Site[] siteArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            String color = "undefined";
            BalloonSettings settings = this.getContest().getBalloonSettings(site.getSiteNumber());
            if (settings == null) {
                color = "n/a";
            } else {
                color = settings.getColor(problem);
                if (color == null || color.trim().length() == 0) {
                    color = "undefined";
                }
            }
            c[i] = color;
            ++i;
            ++n2;
        }
        return c;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addBalloonSettingsListener(new BalloonSettingsListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addSiteListener(new SiteListenerImplementation());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BalloonColorListPane.this.reloadListBox();
            }
        });
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(25, 25));
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    private class BalloonSettingsListenerImplementation
    implements IBalloonSettingsListener {
        private BalloonSettingsListenerImplementation() {
        }

        @Override
        public void balloonSettingsAdded(BalloonSettingsEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void balloonSettingsChanged(BalloonSettingsEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void balloonSettingsRemoved(BalloonSettingsEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void balloonSettingsRefreshAll(BalloonSettingsEvent balloonSettingsEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }
    }

    private class ProblemListenerImplementation
    implements IProblemListener {
        private ProblemListenerImplementation() {
        }

        @Override
        public void problemAdded(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void problemChanged(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }
    }

    private class SiteListenerImplementation
    implements ISiteListener {
        private SiteListenerImplementation() {
        }

        @Override
        public void siteAdded(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void siteRemoved(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void siteChanged(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void siteLoggedOn(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void siteLoggedOff(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void sitesRefreshAll(SiteEvent siteEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonColorListPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void siteProfileStatusChanged(SiteEvent event) {
        }
    }
}

