/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.execute.Executable;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientSettingsEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IClientSettingsListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.ui.AutoJudgeNotifyMessages;
import edu.csus.ecs.pc2.ui.AutoJudgeNotifyMesssageImpl;
import edu.csus.ecs.pc2.ui.AutoJudgeStatusFrame;
import edu.csus.ecs.pc2.ui.UIPlugin;
import edu.csus.ecs.pc2.ui.judge.JudgeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.ListIterator;
import java.util.TimeZone;
import javax.swing.SwingUtilities;

public class AutoJudgingMonitor
implements UIPlugin {
    private IInternalContest contest;
    private IInternalController controller;
    private AutoJudgeStatusFrame autoJudgeStatusFrame = null;
    private AutoJudgeNotifyMessages notifyMessager = null;
    private boolean currentlyAutoJudging = false;
    private Log log;
    private Run runBeingAutoJudged = null;
    private RunFiles fetchedRunFiles = null;
    private Run fetchedRun = null;
    private Boolean listening = new Boolean(true);
    private Executable executable;
    private boolean autoJudgeDisabledLocally = false;
    private boolean answerReceived = false;
    private GregorianCalendar startTimeCalendar;
    private boolean usingGui = true;
    private boolean judgingRun;
    private Runnable controlLoop = null;
    private static final long serialVersionUID = 2774495762012789107L;

    public AutoJudgingMonitor() {
        this(false);
    }

    public AutoJudgingMonitor(boolean useGUI) {
        this.usingGui = useGUI;
        if (this.usingGui) {
            this.autoJudgeStatusFrame = new AutoJudgeStatusFrame();
            this.notifyMessager = this.autoJudgeStatusFrame;
        } else {
            this.notifyMessager = new AutoJudgeNotifyMesssageImpl();
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.notifyMessager.setContestAndController(inContest, inController);
        this.log = this.controller.getLog();
        if (this.usingGui) {
            this.autoJudgeStatusFrame.setAutoJudgeMonitor(this);
        }
        this.contest.addRunListener(new RunListenerImplementation());
        this.contest.addClientSettingsListener(new ClientSettingsListenerImplementation());
        if (this.usingGui) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoJudgingMonitor.this.autoJudgeStatusFrame.setTitle("Auto Judge Status " + AutoJudgingMonitor.this.contest.getClientId().getName());
                }
            });
        }
    }

    @Override
    public String getPluginTitle() {
        return "Auto Judging Monitor";
    }

    public Run findNextAutoJudgeRun() {
        Filter filter = this.getAutoJudgeFilter();
        if (filter == null) {
            this.info(this.contest.getClientId() + " has no problems selected to auto judge (filter is null)");
            return null;
        }
        if (!this.isAutoJudgingEnabled()) {
            this.info(this.contest.getClientId() + " does not have auto judging turned on");
            return null;
        }
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.getStatus() == Run.RunStates.QUEUED_FOR_COMPUTER_JUDGEMENT && filter.matches(run)) {
                return run;
            }
            ++n2;
        }
        return null;
    }

    private Filter getAutoJudgeFilter() {
        Filter filter = null;
        ClientSettings clientSettings = this.contest.getClientSettings();
        if (clientSettings != null && clientSettings.isAutoJudging()) {
            filter = clientSettings.getAutoJudgeFilter();
        }
        return filter;
    }

    private boolean isAutoJudgingEnabled() {
        if (this.autoJudgeDisabledLocally) {
            return false;
        }
        ClientSettings clientSettings = this.contest.getClientSettings();
        return clientSettings != null && clientSettings.isAutoJudging();
    }

    private boolean isRunToBeAutoJudged(Run run) {
        if (run == null) {
            return false;
        }
        Problem problem = this.contest.getProblem(run.getProblemId());
        if (problem == null) {
            this.log.log(Log.WARNING, "Problem null on for " + run);
            return false;
        }
        if (!problem.isValidatedProblem()) {
            this.log.log(Log.WARNING, "Problem has no validator defined, can't be auto judged, run: " + run);
            return false;
        }
        ClientSettings clientSettings = this.contest.getClientSettings();
        if (clientSettings != null && clientSettings.isAutoJudging() && clientSettings.getAutoJudgeFilter() != null) {
            return clientSettings.getAutoJudgeFilter().matches(run);
        }
        return false;
    }

    private String getRunDescription(Run runToCheckOut) {
        return " Run " + runToCheckOut.getNumber() + " Site " + runToCheckOut.getSiteNumber() + " - " + this.contest.getProblem(runToCheckOut.getProblemId()).getDisplayName();
    }

    protected boolean isCurrentlyAutoJudging() {
        return this.currentlyAutoJudging;
    }

    protected void setCurrentlyAutoJudging(boolean alreadyJudgingRun) {
        this.currentlyAutoJudging = alreadyJudgingRun;
    }

    private void cleanupLastAutoJudge() {
        this.runBeingAutoJudged = null;
        this.fetchedRun = null;
        this.fetchedRunFiles = null;
        this.notifyMessager.updateStatusLabel("Waiting for runs");
        this.notifyMessager.updateMessage("(Still waiting)");
        this.setAlreadyJudgingRun(false);
        this.setCurrentlyAutoJudging(false);
    }

    private void setAlreadyJudgingRun(boolean b) {
        if (this.usingGui) {
            JudgeView.setAlreadyJudgingRun(b);
        } else {
            this.judgingRun = b;
        }
    }

    private void executeAndAutoJudgeRun() {
        long executeTimeMS = 0L;
        this.setCurrentlyAutoJudging(true);
        if (this.usingGui) {
            this.autoJudgeStatusFrame.setVisible(true);
        }
        this.notifyMessager.updateStatusLabel("Received run");
        this.notifyMessager.updateMessage(this.getRunDescription(this.fetchedRun));
        try {
            this.notifyMessager.updateStatusLabel("Judging run");
        }
        catch (Exception e) {
            this.info("Exception logged ", e);
        }
        System.gc();
        this.executable = new Executable(this.contest, this.controller, this.fetchedRun, this.fetchedRunFiles);
        this.executable.setShowMessageToUser(false);
        this.executable.setUsingGUI(this.usingGui);
        this.notifyMessager.updateMessage(this.getRunDescription(this.fetchedRun));
        this.executable.execute();
        ExecutionData executionData = this.executable.getExecutionData();
        executeTimeMS = executionData.getExecuteTimeMS();
        RunResultFiles runResultFiles = null;
        JudgementRecord judgementRecord = null;
        try {
            ElementId elementId;
            if (executionData.getExecutionException() != null) {
                this.notifyMessager.updateStatusLabel("ERROR - " + executionData.getExecutionException().getMessage());
                this.log.log(Log.WARNING, "ERROR - " + executionData.getExecutionException().getMessage(), "ERROR - " + executionData.getExecutionException());
            } else if (!executionData.isCompileSuccess()) {
                this.notifyMessager.updateStatusLabel("Run failed to compile");
                elementId = this.contest.getJudgements()[1].getElementId();
                judgementRecord = new JudgementRecord(elementId, this.contest.getClientId(), false, true, true);
                judgementRecord.setValidatorResultString("No - Compilation Error");
            } else if (executionData.isValidationSuccess()) {
                String results = this.executable.getValidationResults();
                if (results == null) {
                    results = "Undetermined";
                }
                if (results.trim().length() == 0) {
                    results = "Undetermined";
                }
                boolean solved = false;
                ElementId elementId2 = this.contest.getJudgements()[1].getElementId();
                Judgement[] judgementArray = this.contest.getJudgements();
                int n = judgementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Judgement judgement = judgementArray[n2];
                    if (judgement.getDisplayName().equals(results)) {
                        elementId2 = judgement.getElementId();
                    }
                    ++n2;
                }
                Judgement yesJudgement = this.contest.getJudgements()[0];
                if (results.trim().equalsIgnoreCase("accepted")) {
                    results = yesJudgement.getDisplayName();
                }
                if (yesJudgement.getDisplayName().equalsIgnoreCase(results)) {
                    elementId2 = yesJudgement.getElementId();
                    solved = true;
                }
                judgementRecord = new JudgementRecord(elementId2, this.contest.getClientId(), solved, true, true);
                judgementRecord.setValidatorResultString(results);
            } else {
                this.info("Run compiled but failed to validate " + this.fetchedRun);
                elementId = this.contest.getJudgements()[1].getElementId();
                judgementRecord = new JudgementRecord(elementId, this.contest.getClientId(), false, true, true);
                judgementRecord.setValidatorResultString("Undetermined");
            }
        }
        catch (Exception e) {
            this.info("Exception during execute/validating run " + this.fetchedRun, e);
        }
        if (judgementRecord == null) {
            this.info("Problem judging run " + this.fetchedRun + " unable to create judgement record");
            this.notifyMessager.updateStatusLabel("Problem judging run");
            this.notifyMessager.updateStatusLabel("Returning run to server");
            this.controller.cancelRun(this.runBeingAutoJudged);
            this.cleanupLastAutoJudge();
        } else {
            this.info("Sending judgement to server " + this.fetchedRun);
            this.notifyMessager.updateStatusLabel("Sending judgement to server");
            TimeZone tz = TimeZone.getTimeZone("GMT");
            GregorianCalendar cal = new GregorianCalendar(tz);
            long milliDiff = cal.getTime().getTime() - this.startTimeCalendar.getTime().getTime();
            long totalSeconds = milliDiff / 1000L;
            judgementRecord.setHowLongToJudgeInSeconds(totalSeconds);
            judgementRecord.setExecuteMS(executeTimeMS);
            runResultFiles = new RunResultFiles(this.fetchedRun, this.fetchedRun.getProblemId(), judgementRecord, this.executable.getExecutionData());
            this.controller.submitRunJudgement(this.fetchedRun, judgementRecord, runResultFiles);
            this.cleanupLastAutoJudge();
        }
    }

    private void attemptToFetchNextRun() {
        this.attemptToFetchNextRun(this.findNextAutoJudgeRun());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToFetchNextRun(Run nextRun) {
        Boolean judgingRunStatus;
        if (nextRun == null) {
            try {
                Thread.sleep(1300L);
            }
            catch (InterruptedException interruptedException) {
                this.log.finest("attemptToFetchNextRun InterruptedException");
            }
            return;
        }
        if (!this.isAutoJudgingEnabled()) {
            return;
        }
        if (this.isCurrentlyAutoJudging()) {
            return;
        }
        Boolean bl = judgingRunStatus = Boolean.valueOf(this.isAlreadyJudgingRun());
        synchronized (bl) {
            this.notifyMessager.updateMessage("(Waiting 2)");
            while (this.isAlreadyJudgingRun()) {
                try {
                    judgingRunStatus.wait();
                }
                catch (InterruptedException e) {
                    this.log.throwing("AutoJudgingMonitor", "attempttoFetchNextRun()", e);
                }
            }
            this.setAlreadyJudgingRun(true);
            this.notifyMessager.updateMessage("(Waiting)");
        }
        if (this.isRunToBeAutoJudged(nextRun)) {
            this.runBeingAutoJudged = nextRun;
            this.fetchRun(nextRun);
            if (this.fetchedRun != null) {
                this.info("Fetched run " + this.fetchedRun);
                this.executeAndAutoJudgeRun();
            } else {
                this.info("Unable to fetch run " + nextRun);
                this.setAlreadyJudgingRun(false);
            }
        } else {
            this.notifyMessager.updateStatusLabel("Waiting for runs");
            this.notifyMessager.updateMessage("(Still waiting)");
            this.setAlreadyJudgingRun(false);
        }
    }

    private boolean isAlreadyJudgingRun() {
        if (this.usingGui) {
            return JudgeView.isAlreadyJudgingRun();
        }
        return this.judgingRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchRun(Run run) {
        this.setCurrentlyAutoJudging(true);
        this.runBeingAutoJudged = run;
        this.notifyMessager.updateStatusLabel("Fetching Run " + run.getNumber() + " (Site " + run.getSiteNumber() + ")");
        this.notifyMessager.updateMessage(this.getRunDescription(run));
        this.startTimeCalendar = null;
        this.controller.checkOutRun(run, false, true);
        this.answerReceived = false;
        Boolean bl = this.listening;
        synchronized (bl) {
            while (true) {
                if (this.answerReceived) {
                    return;
                }
                try {
                    this.listening.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.listening.booleanValue();
                }
            }
        }
    }

    public void updateClientSettings(ClientSettings clientSettings) {
        if (clientSettings.getClientId().equals(this.contest.getClientId())) {
            if (clientSettings.isAutoJudging()) {
                this.startAutoJudging();
            } else {
                this.stopAutoJudging();
            }
        }
    }

    public void startAutoJudging() {
        if (this.isAutoJudgingEnabled()) {
            if (this.usingGui) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoJudgingMonitor.this.notifyMessager.updateStatusLabel("Waiting for runs");
                        AutoJudgingMonitor.this.notifyMessager.updateMessage("(Still waiting)");
                    }
                });
            } else {
                this.notifyMessager.updateStatusLabel("Auto-judging is ON");
                this.printSelectedProblems();
                this.notifyMessager.updateMessage("Waiting for runs");
            }
            if (this.controlLoop == null) {
                this.controlLoop = new ControlLoop();
            }
            if (this.usingGui) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoJudgingMonitor.this.autoJudgeStatusFrame.setVisible(true);
                    }
                });
            }
            if (!((ControlLoop)this.controlLoop).isRunning()) {
                this.controlLoop.run();
            }
        } else if (this.usingGui) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoJudgingMonitor.this.notifyMessager.updateStatusLabel("Auto-judging is OFF");
                    AutoJudgingMonitor.this.notifyMessager.updateMessage("");
                }
            });
        } else {
            this.notifyMessager.updateStatusLabel("Auto-judging is OFF");
        }
    }

    private void printSelectedProblems() {
        Filter filter = this.getAutoJudgeFilter();
        ArrayList<String> list = new ArrayList<String>();
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (filter.matches(problem)) {
                list.add(problem.getDisplayName());
            }
            ++n2;
        }
        if (list.size() < 1) {
            System.out.println("No problems selected, will not auto judge any runs");
        } else {
            System.out.println("Will auto judge " + list.size() + " problems ");
            ListIterator i = list.listIterator();
            while (i.hasNext()) {
                System.out.println("  " + (String)i.next());
            }
        }
    }

    public void stopAutoJudging() {
        if (this.isCurrentlyAutoJudging()) {
            if (this.runBeingAutoJudged != null) {
                this.controller.cancelRun(this.runBeingAutoJudged);
            }
            this.cleanupLastAutoJudge();
        }
        this.notifyMessager.updateStatusLabel("Auto-judging is OFF");
        this.notifyMessager.updateMessage("");
    }

    public void info(String s) {
        this.controller.getLog().warning(s);
        if (!this.usingGui) {
            System.out.println(s);
        }
    }

    public void info(String s, Exception exception) {
        this.controller.getLog().log(Log.WARNING, s, exception);
        System.err.println(String.valueOf(Thread.currentThread().getName()) + " " + s);
        System.err.flush();
        exception.printStackTrace(System.err);
    }

    public boolean isAutoJudgeDisabledLocally() {
        return this.autoJudgeDisabledLocally;
    }

    public void setAutoJudgeDisabledLocally(boolean autoJudgeDisabledLocally) {
        this.autoJudgeDisabledLocally = autoJudgeDisabledLocally;
    }

    protected class ClientSettingsListenerImplementation
    implements IClientSettingsListener {
        protected ClientSettingsListenerImplementation() {
        }

        @Override
        public void clientSettingsAdded(ClientSettingsEvent event) {
            this.clientSettingsChanged(event);
        }

        @Override
        public void clientSettingsChanged(ClientSettingsEvent event) {
            AutoJudgingMonitor.this.updateClientSettings(event.getClientSettings());
        }

        @Override
        public void clientSettingsRemoved(ClientSettingsEvent event) {
        }

        @Override
        public void clientSettingsRefreshAll(ClientSettingsEvent clientSettingsEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AutoJudgingMonitor.this.usingGui) {
                        AutoJudgingMonitor.this.autoJudgeStatusFrame.setTitle("Auto Judge Status " + AutoJudgingMonitor.this.contest.getClientId().getName());
                    }
                    AutoJudgingMonitor.this.updateClientSettings(AutoJudgingMonitor.this.contest.getClientSettings());
                }
            });
        }
    }

    private class ControlLoop
    implements Runnable {
        private boolean running = false;

        private ControlLoop() {
        }

        @Override
        public void run() {
            this.running = true;
            while (AutoJudgingMonitor.this.isAutoJudgingEnabled() && !AutoJudgingMonitor.this.isAutoJudgeDisabledLocally()) {
                AutoJudgingMonitor.this.attemptToFetchNextRun();
            }
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    class RunListenerImplementation
    implements IRunListener {
        RunListenerImplementation() {
        }

        @Override
        public void runAdded(RunEvent event) {
        }

        @Override
        public void refreshRuns(RunEvent event) {
            AutoJudgingMonitor.this.stopAutoJudging();
            AutoJudgingMonitor.this.startAutoJudging();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runChanged(RunEvent event) {
            if (AutoJudgingMonitor.this.runBeingAutoJudged != null && event.getRun().getElementId().equals(AutoJudgingMonitor.this.runBeingAutoJudged.getElementId()) && event.getSentToClientId() != null && event.getSentToClientId().equals(AutoJudgingMonitor.this.contest.getClientId())) {
                if (AutoJudgingMonitor.this.fetchedRun == null) {
                    TimeZone tz = TimeZone.getTimeZone("GMT");
                    AutoJudgingMonitor.this.startTimeCalendar = new GregorianCalendar(tz);
                    AutoJudgingMonitor.this.fetchedRunFiles = event.getRunFiles();
                    AutoJudgingMonitor.this.fetchedRun = event.getRun();
                    Boolean bl = AutoJudgingMonitor.this.listening;
                    synchronized (bl) {
                        try {
                            AutoJudgingMonitor.this.answerReceived = true;
                            AutoJudgingMonitor.this.listening.notify();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                AutoJudgingMonitor.this.log.info("Currently judging run " + AutoJudgingMonitor.this.fetchedRun);
            } else if (event.getAction().equals((Object)RunEvent.Action.RUN_NOT_AVAILABLE) && AutoJudgingMonitor.this.runBeingAutoJudged != null && AutoJudgingMonitor.this.fetchedRun == null && event.getRun().getNumber() == AutoJudgingMonitor.this.runBeingAutoJudged.getNumber() && event.getRun().getSiteNumber() == AutoJudgingMonitor.this.runBeingAutoJudged.getSiteNumber()) {
                Boolean bl = AutoJudgingMonitor.this.listening;
                synchronized (bl) {
                    try {
                        AutoJudgingMonitor.this.answerReceived = true;
                        AutoJudgingMonitor.this.listening.notify();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AutoJudgingMonitor.this.cleanupLastAutoJudge();
            }
        }

        @Override
        public void runRemoved(RunEvent event) {
        }
    }
}

