/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.AutoJudgeNotifyMessages;
import edu.csus.ecs.pc2.ui.AutoJudgingMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AutoJudgeStatusFrame
extends JFrame
implements AutoJudgeNotifyMessages {
    private static final long serialVersionUID = -4357639159960022863L;
    private JPanel mainAJStausPane = null;
    private JPanel buttonPane = null;
    private JPanel centerPane = null;
    private JPanel messagePanel = null;
    private JButton stopAutoJudgingButton = null;
    private JLabel messageLabel = null;
    private JLabel bigAutoJudgeStatusLabel = null;
    private AutoJudgingMonitor autoJudgingMonitor = null;

    public AutoJudgeStatusFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(519, 251));
        this.setDefaultCloseOperation(1);
        this.setContentPane(this.getMainAJStausPane());
        this.setTitle("Auto Judge Status");
    }

    private JPanel getMainAJStausPane() {
        if (this.mainAJStausPane == null) {
            this.mainAJStausPane = new JPanel();
            this.mainAJStausPane.setLayout(new BorderLayout());
            this.mainAJStausPane.add((Component)this.getButtonPane(), "South");
            this.mainAJStausPane.add((Component)this.getCenterPane(), "Center");
            this.mainAJStausPane.add((Component)this.getMessagePanel(), "North");
        }
        return this.mainAJStausPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setPreferredSize(new Dimension(45, 45));
            this.buttonPane.add((Component)this.getStopAutoJudgingButton(), null);
        }
        return this.buttonPane;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.bigAutoJudgeStatusLabel = new JLabel();
            this.bigAutoJudgeStatusLabel.setText("Waiting for runs");
            this.bigAutoJudgeStatusLabel.setHorizontalAlignment(0);
            this.bigAutoJudgeStatusLabel.setFont(new Font("Dialog", 1, 36));
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)this.bigAutoJudgeStatusLabel, "Center");
        }
        return this.centerPane;
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("## - Problem Title  (Run NN, Site YY)");
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setFont(new Font("Dialog", 1, 18));
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(45, 45));
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    private JButton getStopAutoJudgingButton() {
        if (this.stopAutoJudgingButton == null) {
            this.stopAutoJudgingButton = new JButton();
            this.stopAutoJudgingButton.setText("Stop AutoJudging");
            this.stopAutoJudgingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoJudgeStatusFrame.this.startStopAutoJudging();
                }
            });
        }
        return this.stopAutoJudgingButton;
    }

    protected void startStopAutoJudging() {
        if (this.autoJudgingMonitor.isAutoJudgeDisabledLocally()) {
            this.getStopAutoJudgingButton().setText("Stop Auto Judging");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AutoJudgeStatusFrame.this.autoJudgingMonitor.setAutoJudgeDisabledLocally(false);
                    AutoJudgeStatusFrame.this.autoJudgingMonitor.startAutoJudging();
                }
            }).start();
        } else {
            this.getStopAutoJudgingButton().setText("Start Auto Judging");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AutoJudgeStatusFrame.this.autoJudgingMonitor.setAutoJudgeDisabledLocally(true);
                    AutoJudgeStatusFrame.this.autoJudgingMonitor.stopAutoJudging();
                }
            }).start();
        }
    }

    @Override
    public void updateMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoJudgeStatusFrame.this.messageLabel.setText(message);
                AutoJudgeStatusFrame.this.messageLabel.setToolTipText(message);
            }
        });
    }

    @Override
    public void updateStatusLabel(final String bigMessage) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoJudgeStatusFrame.this.bigAutoJudgeStatusLabel.setText(bigMessage);
                AutoJudgeStatusFrame.this.bigAutoJudgeStatusLabel.setToolTipText(bigMessage);
            }
        });
    }

    public void setAutoJudgeMonitor(AutoJudgingMonitor monitor) {
        this.autoJudgingMonitor = monitor;
    }

    protected AutoJudgingMonitor getAutoJudgingMonitor() {
        return this.autoJudgingMonitor;
    }

    public void setAutoJudgingMonitor(AutoJudgingMonitor autoJudgingMonitor) {
        this.autoJudgingMonitor = autoJudgingMonitor;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
    }

    @Override
    public String getPluginTitle() {
        return "Auto Judge Status Frame";
    }
}

