/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.services.web;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.exports.ccs.StandingsJSON2016;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Path(value="/scoreboard")
@Produces(value={"application/json"})
public class ScoreboardService {
    private IInternalContest contest;
    private IInternalController controller;

    public ScoreboardService(IInternalContest contest, IInternalController controller) {
        this.contest = contest;
        this.controller = controller;
    }

    @GET
    @Produces(value={"application/json"})
    public String getScoreboard(@Context SecurityContext sc) {
        StandingsJSON2016 standings = new StandingsJSON2016();
        String jsonScoreboard = "[]";
        try {
            ContestTime contestTime = this.contest.getContestTime();
            if (contestTime.getElapsedMS() > 0L || sc.isUserInRole("admin")) {
                jsonScoreboard = standings.createJSON(this.contest, this.controller);
            }
        }
        catch (IllegalContestState e) {
            this.controller.getLog().warning("ScoreboardService: IllegalState exception creating JSON scoreboard: " + e);
            e.printStackTrace();
        }
        return jsonScoreboard;
    }
}

