/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.services.web;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.exports.ccs.ProblemsJSON;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Path(value="/problems")
@Produces(value={"application/json"})
public class ProblemService {
    private IInternalContest contest;

    public ProblemService(IInternalContest contest, IInternalController controller) {
        this.contest = contest;
    }

    @GET
    @Produces(value={"application/json"})
    public String getProblems(@Context SecurityContext sc) {
        ProblemsJSON problems = new ProblemsJSON();
        String jsonProblems = "[]";
        try {
            ContestTime contestTime = this.contest.getContestTime();
            if (contestTime.getElapsedMS() > 0L || sc.isUserInRole("admin")) {
                jsonProblems = problems.createJSON(this.contest);
            }
        }
        catch (IllegalContestState e) {
            e.printStackTrace();
        }
        return jsonProblems;
    }
}

