/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.services.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/languages")
@Produces(value={"application/json"})
public class LanguageService {
    private IInternalContest contest;

    public LanguageService(IInternalContest contest, IInternalController controller) {
        this.contest = contest;
    }

    @GET
    @Produces(value={"application/json"})
    public String getLanguages() {
        Language[] languages = this.contest.getLanguages();
        ObjectMapper mapper = new ObjectMapper();
        String jsonOutput = "[";
        try {
            boolean addedOne = false;
            int index = 1;
            Language[] languageArray = languages;
            int n = languages.length;
            int n2 = 0;
            while (n2 < n) {
                Language lang = languageArray[n2];
                if (addedOne) {
                    jsonOutput = String.valueOf(jsonOutput) + ",";
                }
                jsonOutput = String.valueOf(jsonOutput) + "{";
                jsonOutput = String.valueOf(jsonOutput) + "\"id\":" + mapper.writeValueAsString((Object)index) + ",";
                String name = lang.getDisplayName();
                jsonOutput = String.valueOf(jsonOutput) + "\"name\":\"" + name + "\"";
                jsonOutput = String.valueOf(jsonOutput) + "}";
                addedOne = true;
                ++index;
                ++n2;
            }
        }
        catch (JsonProcessingException e) {
            System.err.println("LanguageService: error: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("LanguageService: error: " + e.getMessage());
            e.printStackTrace();
        }
        jsonOutput = String.valueOf(jsonOutput) + "]";
        return jsonOutput;
    }
}

