/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.services.eventFeed;

import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.services.eventFeed.EventFeeder;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

class FeederThread
implements Runnable {
    private boolean debugFlag = true;
    private ServerSocket server;
    private EventFeeder eventFeeder = null;
    private boolean running = true;
    private IInternalContest contest;
    private boolean filteredFeed = false;

    FeederThread(ServerSocket server, IInternalContest contest, boolean filteredFeed) {
        this.server = server;
        this.contest = contest;
        this.filteredFeed = filteredFeed;
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Socket connection = this.server.accept();
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                if (this.filteredFeed) {
                    System.out.println("Starting a filtered feed");
                    long freezeTimeMins = this.getContest().getContestTime().getContestLengthSecs() / 60L - 60L;
                    this.eventFeeder = new EventFeeder(this.contest, out, freezeTimeMins);
                } else {
                    System.out.println("starting a event feed");
                    this.eventFeeder = new EventFeeder(this.contest, out, 0L);
                }
                new Thread(this.eventFeeder).start();
                if (!this.debugFlag) continue;
                System.out.println("Opened and sent event feed. filtered=" + this.filteredFeed);
            }
            catch (SocketException socketException) {
                this.running = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugFlag) {
            System.out.println("FeederThread done");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void halt() {
        this.running = false;
        if (this.eventFeeder != null) {
            this.eventFeeder.halt();
        }
    }
}

