/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.services.eventFeed;

import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.GroupEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IEventFeedRunnable;
import edu.csus.ecs.pc2.core.model.IGroupListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IJudgementListener;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementEvent;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageEvent;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import edu.csus.ecs.pc2.exports.ccs.ResolverEventFeedXML;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;

public class EventFeeder
implements Runnable {
    private IInternalContest contest;
    private Filter filter = null;
    private IEventFeedRunnable eventFeedRunnable = null;
    private OutputStreamWriter out;
    private ResolverEventFeedXML eventFeedXML = new ResolverEventFeedXML();
    private AccountListener accountListener = null;
    private RunListener runListener = null;
    private ClarificationListener clarificationListener = null;
    private ProblemListener problemListener = null;
    private LanguageListener languageListener = null;
    private GroupListener groupListener = null;
    private JudgementListener judgementListener = null;
    private ContestInformationListener contestInformationListener = null;

    EventFeeder() {
        this.initListeners();
    }

    private void initListeners() {
        this.accountListener = new AccountListener();
        this.runListener = new RunListener();
        this.clarificationListener = new ClarificationListener();
        this.problemListener = new ProblemListener();
        this.languageListener = new LanguageListener();
        this.groupListener = new GroupListener();
        this.judgementListener = new JudgementListener();
        this.contestInformationListener = new ContestInformationListener();
    }

    public EventFeeder(IInternalContest contest, OutputStreamWriter out, long contestTimeWhenJudgementsNoLongerSentMinutes) {
        this();
        this.contest = contest;
        this.out = out;
        this.eventFeedRunnable = new EventFeedRunner();
        this.setFreezeTimeMinutes(contestTimeWhenJudgementsNoLongerSentMinutes);
    }

    public EventFeeder(IInternalContest contest, IEventFeedRunnable runnable) {
        this();
        this.contest = contest;
        this.eventFeedRunnable = runnable;
    }

    @Override
    public void run() {
        String xml = this.eventFeedXML.createStartupXML(this.contest);
        this.eventFeedRunnable.send(xml);
        FinalizeData finalizeData = this.contest.getFinalizeData();
        if (finalizeData != null && this.contest.getFinalizeData().isCertified()) {
            xml = this.eventFeedXML.createFinalizeXML(this.contest, finalizeData);
            this.eventFeedRunnable.send(xml);
            this.halt();
        } else {
            this.registerListeners(this.contest);
        }
    }

    private void registerListeners(IInternalContest inContest) {
        inContest.addAccountListener(this.accountListener);
        inContest.addRunListener(this.runListener);
        inContest.addClarificationListener(this.clarificationListener);
        inContest.addProblemListener(this.problemListener);
        inContest.addLanguageListener(this.languageListener);
        inContest.addGroupListener(this.groupListener);
        inContest.addJudgementListener(this.judgementListener);
        inContest.addContestInformationListener(this.contestInformationListener);
    }

    public void dispose() {
        this.contest.removeAccountListener(this.accountListener);
        this.contest.removeRunListener(this.runListener);
        this.contest.removeClarificationListener(this.clarificationListener);
        this.contest.removeProblemListener(this.problemListener);
        this.contest.removeLanguageListener(this.languageListener);
        this.contest.removeGroupListener(this.groupListener);
        this.contest.removeJudgementListener(this.judgementListener);
        this.contest.removeContestInformationListener(this.contestInformationListener);
    }

    public void setFreezeTimeMinutes(long contestTimeWhenJudgementsNoLongerSentMinutes) {
        this.filter = new Filter();
        if (contestTimeWhenJudgementsNoLongerSentMinutes != 0L) {
            this.filter.setStartElapsedTime(contestTimeWhenJudgementsNoLongerSentMinutes);
        }
    }

    public void halt() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dispose();
    }

    public void sendToSocket(String xmlString) {
        try {
            this.out.write(xmlString);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendXML(XMLMemento memento) {
        try {
            this.eventFeedRunnable.send(memento.saveToString(true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getJudgementNumber(IInternalContest contest2, Judgement inJudgement) {
        int count = 0;
        Judgement[] judgementArray = contest2.getJudgements();
        int n = judgementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Judgement judgement = judgementArray[n2];
            ++count;
            if (judgement.getElementId().equals(inJudgement.getElementId())) {
                return count;
            }
            ++n2;
        }
        return count;
    }

    protected class AccountListener
    implements IAccountListener {
        protected AccountListener() {
        }

        @Override
        public void accountAdded(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (this.isTeam(account) && EventFeeder.this.contest.isAllowed(account.getClientId(), Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, account));
            }
        }

        private boolean isTeam(Account account) {
            return account.getClientId().getClientType().equals((Object)ClientType.Type.TEAM);
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (this.isTeam(account) && EventFeeder.this.contest.isAllowed(account.getClientId(), Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, account));
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
            Account[] accounts;
            Account[] accountArray = accounts = accountEvent.getAccounts();
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (this.isTeam(account) && EventFeeder.this.contest.isAllowed(account.getClientId(), Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                    EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, account));
                }
                ++n2;
            }
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts = accountEvent.getAccounts();
            Arrays.sort(accounts, new AccountComparator());
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (this.isTeam(account) && EventFeeder.this.contest.isAllowed(account.getClientId(), Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                    EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, account));
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
        }
    }

    protected class ClarificationListener
    implements IClarificationListener {
        protected ClarificationListener() {
        }

        @Override
        public void clarificationAdded(ClarificationEvent event) {
            Clarification clarification = event.getClarification();
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, clarification));
        }

        @Override
        public void clarificationChanged(ClarificationEvent event) {
            Clarification clarification = event.getClarification();
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, clarification));
        }

        @Override
        public void clarificationRemoved(ClarificationEvent event) {
        }

        @Override
        public void refreshClarfications(ClarificationEvent event) {
        }
    }

    protected class ContestInformationListener
    implements IContestInformationListener {
        protected ContestInformationListener() {
        }

        @Override
        public void contestInformationAdded(ContestInformationEvent event) {
            ContestInformation info = event.getContestInformation();
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createInfoElement(EventFeeder.this.contest, info));
        }

        @Override
        public void contestInformationChanged(ContestInformationEvent event) {
            ContestInformation info = event.getContestInformation();
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createInfoElement(EventFeeder.this.contest, info));
        }

        @Override
        public void contestInformationRemoved(ContestInformationEvent event) {
        }

        @Override
        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
        }

        @Override
        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
            FinalizeData data = contestInformationEvent.getFinalizeData();
            EventFeeder.this.eventFeedRunnable.send(EventFeeder.this.eventFeedXML.createFinalizeXML(EventFeeder.this.contest, data));
        }
    }

    private class EventFeedRunner
    implements IEventFeedRunnable {
        private EventFeedRunner() {
        }

        @Override
        public void send(String xmlString) {
            EventFeeder.this.sendToSocket(xmlString);
        }
    }

    protected class GroupListener
    implements IGroupListener {
        protected GroupListener() {
        }

        @Override
        public void groupAdded(GroupEvent event) {
            Group group = event.getGroup();
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, group));
        }

        @Override
        public void groupChanged(GroupEvent event) {
            Group group = event.getGroup();
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, group));
        }

        @Override
        public void groupRemoved(GroupEvent event) {
        }

        @Override
        public void groupsAdded(GroupEvent groupEvent) {
            Group[] groups;
            Group[] groupArray = groups = groupEvent.getGroups();
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Group group = groupArray[n2];
                EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, group));
                ++n2;
            }
        }

        @Override
        public void groupsChanged(GroupEvent groupEvent) {
            Group[] groups;
            Group[] groupArray = groups = groupEvent.getGroups();
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Group group = groupArray[n2];
                EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, group));
                ++n2;
            }
        }

        @Override
        public void groupRefreshAll(GroupEvent groupEvent) {
        }
    }

    protected class JudgementListener
    implements IJudgementListener {
        protected JudgementListener() {
        }

        @Override
        public void judgementAdded(JudgementEvent event) {
            Judgement judgement = event.getJudgement();
            int judgementSequence = EventFeeder.this.getJudgementNumber(EventFeeder.this.contest, judgement);
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, judgement, judgementSequence));
        }

        @Override
        public void judgementChanged(JudgementEvent event) {
            Judgement judgement = event.getJudgement();
            int judgementSequence = EventFeeder.this.getJudgementNumber(EventFeeder.this.contest, judgement);
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, judgement, judgementSequence));
        }

        @Override
        public void judgementRemoved(JudgementEvent event) {
        }

        @Override
        public void judgementRefreshAll(JudgementEvent judgementEvent) {
        }
    }

    protected class LanguageListener
    implements ILanguageListener {
        protected LanguageListener() {
        }

        @Override
        public void languageAdded(LanguageEvent event) {
            Language language = event.getLanguage();
            int languageNumber = this.getLanguageNumber(language);
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, language, languageNumber));
        }

        private int getLanguageNumber(Language inLanguage) {
            int idx = 1;
            Language[] languageArray = EventFeeder.this.contest.getLanguages();
            int n = languageArray.length;
            int n2 = 0;
            while (n2 < n) {
                Language language = languageArray[n2];
                if (language.equals(inLanguage)) {
                    return idx;
                }
                ++idx;
                ++n2;
            }
            return 0;
        }

        @Override
        public void languageChanged(LanguageEvent event) {
            Language language = event.getLanguage();
            int languageNumber = this.getLanguageNumber(language);
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, language, languageNumber));
        }

        @Override
        public void languageRemoved(LanguageEvent event) {
        }

        @Override
        public void languageRefreshAll(LanguageEvent event) {
        }

        @Override
        public void languagesAdded(LanguageEvent event) {
            Language[] languages;
            Language[] languageArray = languages = event.getLanguages();
            int n = languages.length;
            int n2 = 0;
            while (n2 < n) {
                Language language = languageArray[n2];
                int languageNumber = this.getLanguageNumber(language);
                EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, language, languageNumber));
                ++n2;
            }
        }

        @Override
        public void languagesChanged(LanguageEvent event) {
            Language[] languages;
            Language[] languageArray = languages = event.getLanguages();
            int n = languages.length;
            int n2 = 0;
            while (n2 < n) {
                Language language = languageArray[n2];
                int languageNumber = this.getLanguageNumber(language);
                EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, language, languageNumber));
                ++n2;
            }
        }
    }

    protected class ProblemListener
    implements IProblemListener {
        protected ProblemListener() {
        }

        @Override
        public void problemAdded(ProblemEvent event) {
            Problem problem = event.getProblem();
            int problemNumber = this.getProblemNumber(problem);
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, problem, problemNumber));
        }

        private int getProblemNumber(Problem inProblem) {
            int idx = 1;
            Problem[] problemArray = EventFeeder.this.contest.getProblems();
            int n = problemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Problem problem = problemArray[n2];
                if (problem.equals(inProblem)) {
                    return idx;
                }
                ++idx;
                ++n2;
            }
            return 0;
        }

        @Override
        public void problemChanged(ProblemEvent event) {
            Problem problem = event.getProblem();
            int problemNumber = this.getProblemNumber(problem);
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, problem, problemNumber));
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
        }
    }

    protected class RunListener
    implements IRunListener {
        protected RunListener() {
        }

        @Override
        public void runAdded(RunEvent event) {
            Run run = event.getRun();
            if (!run.isDeleted()) {
                this.runChanged(event);
            }
        }

        @Override
        public void runChanged(RunEvent event) {
            Run run = event.getRun();
            EventFeeder.this.sendXML(EventFeeder.this.eventFeedXML.createElement(EventFeeder.this.contest, run));
        }

        @Override
        public void runRemoved(RunEvent event) {
            this.runChanged(event);
        }

        @Override
        public void refreshRuns(RunEvent event) {
        }
    }
}

