/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.imports.ccs;

import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.core.util.TabSeparatedValueParser;
import edu.csus.ecs.pc2.imports.ccs.CCSListUtilities;
import edu.csus.ecs.pc2.imports.ccs.InvaildNumberFields;
import edu.csus.ecs.pc2.imports.ccs.InvalidFileFormat;
import edu.csus.ecs.pc2.imports.ccs.InvalidValueException;
import java.io.FileNotFoundException;

public final class ICPCTSVLoader {
    private static final int TEAM_TSV_FIELDS = 7;
    private static final int GROUP_TSV_FIELDS = 2;
    private static final String NULL_STRING = "null";
    private static int siteNumber = 1;
    private static Group[] groups = new Group[0];

    private ICPCTSVLoader() {
    }

    public static Account[] loadAccounts(String filename) throws Exception {
        String[] lines = CCSListUtilities.filterOutCommentLines(Utilities.loadFile(filename));
        if (lines.length == 0) {
            throw new FileNotFoundException(filename);
        }
        int i = 0;
        String firstLine = lines[i];
        String[] fields = TabSeparatedValueParser.parseLine(firstLine);
        ++i;
        Account[] accounts = new Account[lines.length - 1];
        int accountCount = 0;
        ClientType.Type team = ClientType.Type.TEAM;
        PermissionList teamPermissionList = new PermissionGroup().getPermissionList(team);
        while (i < lines.length) {
            fields = TabSeparatedValueParser.parseLine(lines[i]);
            if (fields.length != 7 && i == 1) {
                throw new InvalidFileFormat("Expected 7 fields, found " + fields.length + " is this a valid team.tsv file? (" + filename + ")");
            }
            accounts[accountCount] = ICPCTSVLoader.accountFromFields(fields, accountCount, lines[i]);
            accounts[accountCount].clearListAndLoadPermissions(teamPermissionList);
            ++accountCount;
            ++i;
        }
        return accounts;
    }

    private static Account accountFromFields(String[] fields, int accountCount, String originalLine) throws InvaildNumberFields, InvalidValueException {
        if (fields.length != 7) {
            throw new InvaildNumberFields("Expected 7 fields, found " + fields.length + " invalid team.tsv line: " + originalLine);
        }
        int fieldnum = 0;
        String numberStr = fields[fieldnum++];
        String reservationIdStr = fields[fieldnum++];
        String groupIDStr = fields[fieldnum++];
        String teamName = fields[fieldnum++];
        String schoolName = fields[fieldnum++];
        String schoolShortName = fields[fieldnum++];
        String countryCode = fields[fieldnum++];
        int number = 0;
        if (numberStr != null && NULL_STRING.equalsIgnoreCase(numberStr.trim())) {
            number = accountCount + 1;
        } else {
            try {
                number = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException e) {
                throw new InvalidValueException("Expecting team number got '" + numberStr + "' on line " + originalLine, e);
            }
        }
        int groupNumber = 0;
        try {
            groupNumber = Integer.parseInt(groupIDStr);
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException("Expecting group number got '" + numberStr + "' on line " + originalLine, e);
        }
        ClientId clientId = new ClientId(siteNumber, ClientType.Type.TEAM, number);
        Account account = new Account(clientId, ICPCTSVLoader.getJoePassword(clientId), siteNumber);
        account.setDisplayName(schoolName);
        account.setShortSchoolName(schoolShortName);
        account.setLongSchoolName(schoolName);
        account.setExternalName(schoolName);
        account.setTeamName(teamName);
        account.setExternalId(reservationIdStr);
        account.setCountryCode(countryCode);
        if (groupNumber != 0) {
            ElementId groupId = ICPCTSVLoader.getGroupForNumber(groupNumber);
            if (groupId != null) {
                account.setGroupId(groupId);
            } else {
                throw new InvalidValueException("Unknown group number '" + groupNumber + "' on line " + originalLine);
            }
        }
        return account;
    }

    private static ElementId getGroupForNumber(int groupId) {
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            if (group.getGroupId() == groupId) {
                return group.getElementId();
            }
            ++n2;
        }
        return null;
    }

    private static String getJoePassword(ClientId clientId) {
        return String.valueOf(clientId.getClientType().toString().toLowerCase()) + clientId.getClientNumber();
    }

    public static void setGroups(Group[] groups) {
        ICPCTSVLoader.groups = groups;
    }

    public static Group[] loadGroups(String filename) throws Exception {
        String[] lines = CCSListUtilities.filterOutCommentLines(Utilities.loadFile(filename));
        if (lines.length == 0) {
            throw new FileNotFoundException(filename);
        }
        int i = 0;
        String firstLine = lines[i];
        String[] fields = TabSeparatedValueParser.parseLine(firstLine);
        ++i;
        groups = new Group[lines.length - 1];
        int groupAccount = 0;
        while (i < lines.length) {
            fields = TabSeparatedValueParser.parseLine(lines[i]);
            if (fields.length != 2 && i == 1) {
                throw new InvalidFileFormat("Expected 2 fields, found " + fields.length + " is this a valid groups.tsv file? (" + filename + ")");
            }
            if (fields.length != 2) {
                throw new InvaildNumberFields("Expected 2 fields, found " + fields.length + " invalid groups.tsv line " + lines[i]);
            }
            int fieldnum = 0;
            String numberStr = fields[fieldnum++];
            String groupName = fields[fieldnum++];
            int number = 0;
            try {
                number = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException e) {
                throw new InvalidValueException("Expecting group number got '" + numberStr + "' on line " + lines[i], e);
            }
            Group group = new Group(groupName);
            group.setGroupId(number);
            ICPCTSVLoader.groups[groupAccount] = group;
            ++groupAccount;
            ++i;
        }
        return groups;
    }
}

