/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class TeamsJSON {
    public String createJSON(IInternalContest contest) throws IllegalContestState {
        if (contest == null) {
            return "[]";
        }
        Vector<Account> accountlist = contest.getAccounts(ClientType.Type.TEAM);
        if (accountlist.size() == 0) {
            return "[]";
        }
        Account[] accounts = accountlist.toArray(new Account[accountlist.size()]);
        Group[] groups = contest.getGroups();
        HashMap<ElementId, String> groupMap = new HashMap<ElementId, String>();
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            groupMap.put(group.getElementId(), group.getDisplayName());
            ++n2;
        }
        StringBuffer buffer = new StringBuffer();
        int rowCount = 1;
        Account[] accountArray = accounts;
        int n3 = accounts.length;
        int n4 = 0;
        while (n4 < n3) {
            String schoolName;
            String countryCode;
            Account account = accountArray[n4];
            if (rowCount != 1) {
                buffer.append(',');
            }
            buffer.append('{');
            int teamNum = account.getClientId().getClientNumber();
            String teamName = account.getTeamName();
            if (teamName == null || teamName.trim().equals("")) {
                teamName = "null";
            }
            if ((countryCode = account.getCountryCode()) == null || countryCode.trim().equals("")) {
                countryCode = "null";
            }
            if ((schoolName = account.getLongSchoolName()) == null || schoolName.trim().equals("")) {
                schoolName = "null";
            }
            String groupName = "null";
            if (account.getGroupId() != null && groupMap.containsKey(account.getGroupId())) {
                groupName = (String)groupMap.get(account.getGroupId());
            }
            buffer.append(String.valueOf(this.pair("id", teamNum)) + "," + this.pair("name", teamName) + "," + this.pair("nationality", countryCode) + "," + this.pair("affliliation", schoolName) + "," + this.pair("group", groupName));
            buffer.append('}');
            ++rowCount;
            ++n4;
        }
        return "[" + buffer.toString() + "]";
    }

    public static String join(String delimit, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            buffer.append(list.get(i));
            if (i < list.size() - 1) {
                buffer.append(delimit);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String pair(String name, long value) {
        return "\"" + name + "\":" + value;
    }

    private String pair(String name, String value) {
        return "\"" + name + "\":\"" + value + "\"";
    }
}

