/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.scoring.NewScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.ProblemSummaryInfo;
import edu.csus.ecs.pc2.core.scoring.StandingsRecord;
import edu.csus.ecs.pc2.core.scoring.SummaryRow;
import edu.csus.ecs.pc2.core.util.RunStatistics;
import java.util.List;
import java.util.Properties;

public class StandingsJSON2016 {
    public String createJSON(IInternalContest contest, IInternalController controller) throws IllegalContestState {
        if (contest == null) {
            return "[]";
        }
        NewScoringAlgorithm scoringAlgorithm = new NewScoringAlgorithm();
        scoringAlgorithm.setContest(contest);
        ContestInformation info = contest.getContestInformation();
        Properties properties = new Properties();
        if (info != null && info.getScoringProperties() != null) {
            properties = info.getScoringProperties();
        }
        StandingsRecord[] standingsRecords = scoringAlgorithm.getStandingsRecords(contest, properties);
        RunStatistics runStatistics = new RunStatistics(contest);
        StringBuffer buffer = new StringBuffer();
        int rank = 1;
        StandingsRecord[] standingsRecordArray = standingsRecords;
        int n = standingsRecords.length;
        int n2 = 0;
        while (n2 < n) {
            StandingsRecord sr = standingsRecordArray[n2];
            if (rank != 1) {
                buffer.append(",");
            }
            ++rank;
            buffer.append('{');
            ClientId clientId = sr.getClientId();
            Account account = contest.getAccount(clientId);
            int teamNum = account.getClientId().getClientNumber();
            buffer.append(String.valueOf(this.pair("rank", sr.getRankNumber())) + "," + this.pair("team", teamNum) + ",");
            long numSolved = sr.getNumberSolved();
            long totalTime = sr.getPenaltyPoints();
            buffer.append("\"score\":{" + this.pair("num_solved", numSolved) + "," + this.pair("total_time", totalTime) + "},");
            buffer.append("\"problems\":[");
            SummaryRow row = sr.getSummaryRow();
            int i = 0;
            while (i < contest.getProblems().length) {
                int problemIndex = i + 1;
                ProblemSummaryInfo summaryInfo = row.get(problemIndex);
                if (summaryInfo != null) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append("{");
                    String letter = contest.getProblem(summaryInfo.getProblemId()).getLetter();
                    buffer.append(String.valueOf(this.pair("label", letter)) + ",");
                    int numSubmitted = summaryInfo.getNumberSubmitted();
                    int numPending = summaryInfo.getPendingRunCount();
                    int numJudged = summaryInfo.getJudgedRunCount();
                    if (numPending + numJudged != numSubmitted) {
                        System.err.println("StandingsJSON2016: mismatch: numPendingRuns+numJudgedRuns!=numSubmittedRuns ((" + numPending + "+" + numJudged + ")!=" + numSubmitted + ")");
                        controller.getLog().warning("StandingsJSON2016: mismatch: numPendingRuns+numJudgedRuns!=numSubmittedRuns ((" + numPending + "+" + numJudged + ")!=" + numSubmitted + ")");
                    }
                    buffer.append(String.valueOf(this.pair("num_judged", numJudged)) + ",");
                    buffer.append(String.valueOf(this.pair("num_pending", numPending)) + ",");
                    String isSolved = "false";
                    if (summaryInfo.isSolved()) {
                        isSolved = "true";
                    }
                    buffer.append("\"solved\":" + isSolved);
                    if (summaryInfo.isSolved()) {
                        long solutionTime = summaryInfo.getSolutionTime();
                        buffer.append("," + this.pair("time", solutionTime));
                        Problem prob = contest.getProblem(summaryInfo.getProblemId());
                        String fts = "false";
                        if (runStatistics.isFirstToSolve(clientId, prob)) {
                            fts = "true";
                        }
                        buffer.append(",\"first_to_solve\":" + fts);
                    }
                    buffer.append("}");
                } else {
                    controller.getLog().info("StandingsJSON2016: missing problem summary info for problem " + problemIndex);
                }
                ++i;
            }
            buffer.append("]");
            buffer.append('}');
            ++n2;
        }
        return "[" + buffer.toString() + "]";
    }

    public static String join(String delimit, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            buffer.append(list.get(i));
            if (i < list.size() - 1) {
                buffer.append(delimit);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String pair(String name, long value) {
        return "\"" + name + "\":" + value;
    }

    public static String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    private String pair(String name, String value) {
        return "\"" + name + "\":\"" + value + "\"";
    }
}

