/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.scoring.NewScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.ProblemSummaryInfo;
import edu.csus.ecs.pc2.core.scoring.StandingsRecord;
import edu.csus.ecs.pc2.core.scoring.SummaryRow;
import edu.csus.ecs.pc2.core.util.RunStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class StandingsJSON {
    public String createJSON(IInternalContest contest) throws IllegalContestState {
        if (contest == null || contest.getRuns().length == 0) {
            return "[]";
        }
        NewScoringAlgorithm scoringAlgorithm = new NewScoringAlgorithm();
        scoringAlgorithm.setContest(contest);
        ContestInformation info = contest.getContestInformation();
        Properties properties = new Properties();
        if (info != null && info.getScoringProperties() != null) {
            properties = info.getScoringProperties();
        }
        StandingsRecord[] standingsRecords = scoringAlgorithm.getStandingsRecords(contest, properties);
        RunStatistics runStatistics = new RunStatistics(contest);
        StringBuffer buffer = new StringBuffer();
        StandingsRecord[] standingsRecordArray = standingsRecords;
        int n = standingsRecords.length;
        int n2 = 0;
        while (n2 < n) {
            StandingsRecord sr = standingsRecordArray[n2];
            buffer.append('{');
            ClientId clientId = sr.getClientId();
            Account account = contest.getAccount(clientId);
            String universityName = account.getDisplayName();
            String groupName = "";
            if (account.getGroupId() != null) {
                groupName = contest.getGroup(account.getGroupId()).toString();
            }
            buffer.append(String.valueOf(this.pair("id", "" + sr.getRankNumber())) + "," + this.pair("name", universityName) + "," + this.pair("group", groupName));
            SummaryRow row = sr.getSummaryRow();
            int i = 0;
            while (i < contest.getProblems().length) {
                int problemIndex = i + 1;
                ProblemSummaryInfo summaryInfo = row.get(problemIndex);
                if (summaryInfo != null) {
                    int numberSubmitted = summaryInfo.getNumberSubmitted();
                    long solveTime = summaryInfo.getSolutionTime();
                    String results = null;
                    if (numberSubmitted > 0) {
                        results = "tried";
                        if (solveTime > 0L) {
                            results = "solved";
                            Problem problem = contest.getProblems()[i];
                            if (runStatistics.isFirstToSolve(clientId, problem)) {
                                results = "first";
                            }
                        }
                    }
                    if (results != null) {
                        ArrayList<String> list = new ArrayList<String>();
                        if (numberSubmitted > 0) {
                            list.add(this.pair("a", numberSubmitted));
                        }
                        if (solveTime > 0L) {
                            list.add(this.pair("t", solveTime));
                        }
                        list.add(this.pair("s", results));
                        String probInfo = StandingsJSON.join(",", list);
                        buffer.append(",\"" + StandingsJSON.getProblemLetter(problemIndex) + "\":{" + probInfo + "}");
                    }
                }
                ++i;
            }
            buffer.append('}');
            ++n2;
        }
        return "[" + buffer.toString() + "]";
    }

    public static String join(String delimit, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            buffer.append(list.get(i));
            if (i < list.size() - 1) {
                buffer.append(delimit);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String pair(String name, long value) {
        return "\"" + name + "\":" + value;
    }

    public static String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    private String pair(String name, String value) {
        return "\"" + name + "\":\"" + value + "\"";
    }
}

