/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.NewScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.ProblemSummaryInfo;
import edu.csus.ecs.pc2.core.scoring.StandingsRecord;
import edu.csus.ecs.pc2.core.scoring.SummaryRow;
import java.util.Properties;
import java.util.Vector;

public class ScoreboardFile {
    private static final String TAB = "\t";

    public String[] createTSVFileLines(IInternalContest contest) throws IllegalContestState {
        StandingsRecord[] standingsRecords;
        Vector<String> lines = new Vector<String>();
        NewScoringAlgorithm scoringAlgorithm = new NewScoringAlgorithm();
        scoringAlgorithm.setContest(contest);
        Properties properties = this.getScoringProperties(contest);
        lines.addElement("scoreboard\t1");
        StandingsRecord[] standingsRecordArray = standingsRecords = scoringAlgorithm.getStandingsRecords(contest, properties);
        int n = standingsRecords.length;
        int n2 = 0;
        while (n2 < n) {
            StandingsRecord record = standingsRecordArray[n2];
            Account account = contest.getAccount(record.getClientId());
            String reservationId = account.getExternalId();
            String line = String.valueOf(account.getShortSchoolName()) + TAB + reservationId + TAB + record.getRankNumber() + TAB + record.getNumberSolved() + TAB + record.getPenaltyPoints() + TAB + record.getLastSolved();
            SummaryRow summaryRow = record.getSummaryRow();
            int problemNumber = 1;
            Problem[] problemArray = contest.getProblems();
            int n3 = problemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Problem problem = problemArray[n4];
                if (problem.isActive()) {
                    ProblemSummaryInfo problemSummaryInfo = summaryRow.get(problemNumber);
                    line = problemSummaryInfo != null ? String.valueOf(line) + TAB + problemSummaryInfo.getNumberSubmitted() + TAB + problemSummaryInfo.getSolutionTime() : String.valueOf(line) + "\t0\t-1";
                }
                ++problemNumber;
                ++n4;
            }
            lines.addElement(line);
            ++n2;
        }
        return lines.toArray(new String[lines.size()]);
    }

    protected Properties getScoringProperties(IInternalContest contest) {
        String[] keys;
        Properties properties = contest.getContestInformation().getScoringProperties();
        if (properties == null) {
            properties = new Properties();
        }
        Properties defProperties = DefaultScoringAlgorithm.getDefaultProperties();
        String[] stringArray = keys = defProperties.keySet().toArray(new String[defProperties.keySet().size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (!properties.containsKey(key)) {
                properties.put(key, defProperties.get(key));
            }
            ++n2;
        }
        return properties;
    }
}

