/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.XMLUtilities;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.NewScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.StandingsRecord;
import java.util.Properties;
import java.util.Vector;

public class ResultsFile {
    private static final String BRONZE = "bronze";
    private static final String GOLD = "gold";
    private static final String SILVER = "silver";
    private static final String HONORABLE = "honorable";
    private static final String TAB = "\t";
    private FinalizeData finalizeData = null;

    public void setFinalizeData(FinalizeData finalizeData) {
        this.finalizeData = finalizeData;
    }

    public String[] createTSVFileLines(IInternalContest contest) throws IllegalContestState {
        StandingsRecord[] standingsRecords;
        Vector<String> lines = new Vector<String>();
        this.finalizeData = contest.getFinalizeData();
        if (this.finalizeData == null) {
            throw new IllegalContestState("Contest not Finalized, can not create results file");
        }
        NewScoringAlgorithm scoringAlgorithm = new NewScoringAlgorithm();
        scoringAlgorithm.setContest(contest);
        Properties properties = this.getScoringProperties(contest);
        lines.addElement("results\t1");
        StandingsRecord[] standingsRecordArray = standingsRecords = scoringAlgorithm.getStandingsRecords(contest, properties);
        int n = standingsRecords.length;
        int n2 = 0;
        while (n2 < n) {
            StandingsRecord record = standingsRecordArray[n2];
            Account account = contest.getAccount(record.getClientId());
            String reservationId = account.getExternalId();
            String award = this.getAwardMedal(record.getRankNumber(), this.finalizeData);
            lines.addElement(String.valueOf(reservationId) + TAB + record.getRankNumber() + TAB + award + TAB + record.getNumberSolved() + TAB + record.getPenaltyPoints() + TAB + record.getLastSolved());
            ++n2;
        }
        return lines.toArray(new String[lines.size()]);
    }

    private String getAwardMedal(int rankNumber, FinalizeData data) {
        if (rankNumber <= data.getGoldRank()) {
            return GOLD;
        }
        if (rankNumber <= data.getSilverRank()) {
            return SILVER;
        }
        if (rankNumber <= data.getBronzeRank()) {
            return BRONZE;
        }
        return HONORABLE;
    }

    protected Properties getScoringProperties(IInternalContest contest) {
        String[] keys;
        Properties properties = contest.getContestInformation().getScoringProperties();
        if (properties == null) {
            properties = new Properties();
        }
        Properties defProperties = DefaultScoringAlgorithm.getDefaultProperties();
        String[] stringArray = keys = defProperties.keySet().toArray(new String[defProperties.keySet().size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (!properties.containsKey(key)) {
                properties.put(key, defProperties.get(key));
            }
            ++n2;
        }
        return properties;
    }

    public String[] createTSVFileLinesTwo(IInternalContest contest) throws Exception {
        this.finalizeData = contest.getFinalizeData();
        DefaultScoringAlgorithm scoringAlgorithm = new DefaultScoringAlgorithm();
        String xmlString = scoringAlgorithm.getStandings(contest, new Properties(), null);
        String xsltFileName = "results.tsv.xsl";
        return XMLUtilities.transformToArray(xmlString, xsltFileName);
    }
}

