/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import java.util.List;

public class ProblemsJSON {
    public String createJSON(IInternalContest contest) throws IllegalContestState {
        if (contest == null) {
            return "[]";
        }
        Problem[] problems = contest.getProblems();
        if (problems.length == 0) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer();
        int rowCount = 1;
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            String problemColorName;
            String problemRGB;
            String problemName;
            String problemShortName;
            Problem problem = problemArray[n2];
            if (rowCount != 1) {
                buffer.append(',');
            }
            buffer.append('{');
            String problemLetter = problem.getLetter();
            if (problemLetter == null || problemLetter.trim().equals("")) {
                problemLetter = "null";
            }
            if ((problemShortName = problem.getShortName()) == null || problemShortName.trim().equals("")) {
                problemShortName = "null";
            }
            if ((problemName = problem.getDisplayName()) == null || problemName.trim().equals("")) {
                problemName = "null";
            }
            if ((problemRGB = problem.getColorRGB()) == null || problemRGB.trim().equals("")) {
                problemRGB = "null";
            }
            if ((problemColorName = problem.getColorName()) == null || problemColorName.trim().equals("")) {
                problemColorName = "null";
            }
            buffer.append(String.valueOf(this.pair("id", rowCount)) + "," + this.pair("label", problemLetter) + "," + this.pair("short_name", problemShortName) + "," + this.pair("name", problemName) + "," + this.pair("rgb", problemRGB) + "," + this.pair("color", problemColorName));
            buffer.append('}');
            ++rowCount;
            ++n2;
        }
        return "[" + buffer.toString() + "]";
    }

    public static String join(String delimit, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            buffer.append(list.get(i));
            if (i < list.size() - 1) {
                buffer.append(delimit);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String pair(String name, long value) {
        return "\"" + name + "\":" + value;
    }

    private String pair(String name, String value) {
        return "\"" + name + "\":\"" + value + "\"";
    }
}

