/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.XMLUtilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.list.GroupComparator;
import edu.csus.ecs.pc2.core.list.ProblemComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.list.RunTestCaseComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunTestCase;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class EventFeedXML2013 {
    public static final String CONTEST_TAG = "contest";
    public static final String INFO_TAG = "info";
    public static final String REGION_TAG = "region";
    public static final String PROBLEM_TAG = "problem";
    public static final String LANGUAGE_TAG = "language";
    public static final String TEAM_TAG = "team";
    public static final String CLARIFICATION_TAG = "clar";
    public static final String TESTCASE_TAG = "testcase";
    public static final String RUN_TAG = "run";
    public static final String JUDGEMENT_TAG = "judgement";
    public static final String FINALIZE_TAG = "finalized";
    public static final String JUDGEMENT_RECORD_TAG = "judgement_record";
    private RunComparator runComparator = new RunComparator();
    private VersionInfo versionInfo = new VersionInfo();
    private Log log = null;

    public String toXML(IInternalContest contest) {
        return this.toXML(contest, new Filter());
    }

    public String toXMLFreeze(IInternalContest contest, long minutesFromEnd) {
        long mins = contest.getContestTime().getConestLengthMins() - minutesFromEnd;
        Filter filter = new Filter();
        filter.setFilteringDeleted(true);
        filter.setEndElapsedTime(mins);
        return this.toXML(contest, filter);
    }

    public String toXML(IInternalContest contest, Filter filter) {
        Problem[] problems;
        filter.setFilteringDeleted(true);
        XMLMemento mementoRoot = XMLMemento.createWriteRoot(CONTEST_TAG);
        IMemento memento = mementoRoot.createChild(INFO_TAG);
        this.addInfoMemento(memento, contest, contest.getContestInformation());
        Group[] groups = contest.getGroups();
        Arrays.sort(groups, new GroupComparator());
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            memento = mementoRoot.createChild(REGION_TAG);
            this.addMemento(memento, contest, group);
            ++n2;
        }
        Judgement[] judgements = contest.getJudgements();
        int sequenceNumber = 1;
        Judgement[] judgementArray = judgements;
        int n3 = judgements.length;
        int n4 = 0;
        while (n4 < n3) {
            Judgement judgement = judgementArray[n4];
            memento = mementoRoot.createChild(JUDGEMENT_TAG);
            this.addMemento(memento, contest, judgement, sequenceNumber);
            ++sequenceNumber;
            ++n4;
        }
        Language[] languages = contest.getLanguages();
        int num = 1;
        Language[] languageArray = languages;
        int n5 = languages.length;
        int n6 = 0;
        while (n6 < n5) {
            Language language = languageArray[n6];
            if (filter.matches(language)) {
                memento = mementoRoot.createChild(LANGUAGE_TAG);
                this.addMemento(memento, contest, language, num);
            }
            ++num;
            ++n6;
        }
        num = 1;
        Problem[] problemArray = problems = contest.getProblems();
        int n7 = problems.length;
        n5 = 0;
        while (n5 < n7) {
            Problem problem = problemArray[n5];
            if (filter.matches(problem)) {
                memento = mementoRoot.createChild(PROBLEM_TAG);
                this.addMemento(memento, contest, problem, num);
            }
            ++num;
            ++n5;
        }
        Vector<Account> teams = contest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = teams.toArray(new Account[teams.size()]);
        Arrays.sort(accounts, new AccountComparator());
        Account[] accountArray = accounts;
        int n8 = accounts.length;
        int n9 = 0;
        while (n9 < n8) {
            Account account = accountArray[n9];
            if (filter.matches(account) && contest.isAllowed(account.getClientId(), Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                memento = mementoRoot.createChild(TEAM_TAG);
                this.addMemento(memento, contest, account);
            }
            ++n9;
        }
        Run[] runs = contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Run[] runArray = runs;
        int n10 = runs.length;
        n8 = 0;
        while (n8 < n10) {
            Run run = runArray[n8];
            if (filter.matches(run)) {
                memento = mementoRoot.createChild(RUN_TAG);
                this.addMemento(memento, contest, run);
                RunTestCase[] runTestCases = this.getLastJudgementTestCases(run);
                Arrays.sort(runTestCases, new RunTestCaseComparator());
                RunTestCase[] runTestCaseArray = runTestCases;
                int n11 = runTestCases.length;
                int n12 = 0;
                while (n12 < n11) {
                    RunTestCase runTestCase = runTestCaseArray[n12];
                    if (filter.matchesElapsedTime(runTestCase)) {
                        memento = mementoRoot.createChild(TESTCASE_TAG);
                        this.addMemento(memento, contest, runTestCase, run);
                    }
                    ++n12;
                }
            } else if (!run.isDeleted() && !filter.matchesElapsedTime(run)) {
                memento = mementoRoot.createChild(RUN_TAG);
                this.addMemento(memento, contest, run);
            }
            ++n8;
        }
        Clarification[] clarifications = contest.getClarifications();
        Arrays.sort(clarifications, new ClarificationComparator());
        Clarification[] clarificationArray = clarifications;
        int n13 = clarifications.length;
        n10 = 0;
        while (n10 < n13) {
            Clarification clarification = clarificationArray[n10];
            if (filter.matches(clarification)) {
                memento = mementoRoot.createChild(CLARIFICATION_TAG);
                this.addMemento(memento, contest, clarification);
            }
            ++n10;
        }
        FinalizeData finalizeData = contest.getFinalizeData();
        if (finalizeData != null && finalizeData.isCertified()) {
            memento = mementoRoot.createChild(FINALIZE_TAG);
            this.addMemento(memento, contest, finalizeData);
        }
        return this.toXML(mementoRoot);
    }

    private String getXMLFooterComment() {
        return "<!-- Created by " + this.versionInfo.getSystemName() + " build " + this.versionInfo.getBuildNumber() + " -->";
    }

    public Run getFirstSolvedRun(IInternalContest contest, ClientId clientId, ElementId problemId) {
        Filter filter = new Filter();
        filter.setFilteringDeleted(true);
        filter.addAccount(clientId);
        filter.addProblem(contest.getProblem(problemId));
        Run[] runs = filter.getRuns(contest.getRuns());
        Arrays.sort(runs, this.runComparator);
        if (runs.length > 0) {
            return runs[0];
        }
        return null;
    }

    public XMLMemento createInfoElement(IInternalContest contest, Filter filter) {
        XMLMemento memento = XMLMemento.createWriteRoot(INFO_TAG);
        this.addInfoMemento(memento, contest, contest.getContestInformation());
        return memento;
    }

    public IMemento addInfoMemento(IMemento memento, IInternalContest contest, ContestInformation info) {
        ContestTime time = contest.getContestTime();
        String contestLengthString = "0:0:0";
        boolean running = false;
        String formattedSeconds = "0.0";
        if (time != null) {
            contestLengthString = time.getContestLengthStr();
            running = time.isContestRunning();
            if (time.getContestStartTime() != null) {
                formattedSeconds = XMLUtilities.formatSeconds(time.getContestStartTime().getTimeInMillis());
            }
        }
        XMLUtilities.addChild(memento, "length", contestLengthString);
        XMLUtilities.addChild(memento, "penalty", DefaultScoringAlgorithm.getDefaultProperties().getProperty("Points per No"));
        XMLUtilities.addChild(memento, "started", this.titleCaseBoolean(running));
        XMLUtilities.addChild(memento, "starttime", formattedSeconds);
        XMLUtilities.addChild(memento, "title", info.getContestTitle());
        return memento;
    }

    public XMLMemento createInfoElement(IInternalContest contest, ContestInformation info) {
        XMLMemento memento = XMLMemento.createWriteRoot(INFO_TAG);
        this.addInfoMemento(memento, contest, info);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Language language, int id) {
        XMLMemento memento = XMLMemento.createWriteRoot(LANGUAGE_TAG);
        this.addMemento((IMemento)memento, contest, language, id);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Language language, int id) {
        XMLUtilities.addChild(memento, "id", id);
        XMLUtilities.addChild(memento, "name", language.toString());
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Problem problem, int id) {
        XMLMemento memento = XMLMemento.createWriteRoot(PROBLEM_TAG);
        this.addMemento((IMemento)memento, contest, problem, id);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Problem problem, int id) {
        memento.createChildNode("id", Integer.toString(id));
        memento.createChildNode("name", problem.toString());
        String letter = problem.getLetter();
        if (letter != null && !letter.trim().equals("")) {
            memento.createChildNode("letter", letter.trim());
        }
        return memento;
    }

    protected String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    public boolean isValidJudgement(Run run, boolean sendNotificationsForPreliminary) {
        boolean result = false;
        if (run.getStatus().equals((Object)Run.RunStates.JUDGED)) {
            result = true;
        } else if (run.isJudged()) {
            if (run.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW)) {
                if (sendNotificationsForPreliminary) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public boolean isValidRun(IInternalContest contest, Run run) {
        ContestInformation contestInformation = contest.getContestInformation();
        boolean sendNotification = contestInformation.isPreliminaryJudgementsTriggerNotifications();
        if (run.isJudged() && run.isSolved() && !run.isDeleted() && this.isValidJudgement(run, sendNotification)) {
            return run.isSendToTeams() || !contest.isAllowed(Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
        }
        return false;
    }

    protected Problem[] getSolvedRuns(IInternalContest contest, ClientId id) {
        Filter filter = new Filter();
        filter.setFilteringDeleted(true);
        filter.addAccount(id);
        Run[] runs = filter.getRuns(contest.getRuns());
        Vector<Problem> probVector = new Vector<Problem>();
        int i = 0;
        while (i < runs.length) {
            Run run = runs[i];
            if (!run.isDeleted()) {
                Problem problem = contest.getProblem(run.getProblemId());
                if (this.isValidRun(contest, run) && !probVector.contains(problem)) {
                    probVector.add(problem);
                }
            }
            ++i;
        }
        Problem[] problems = probVector.toArray(new Problem[probVector.size()]);
        Arrays.sort(problems, new ProblemComparator(contest));
        return problems;
    }

    public XMLMemento createElement(IInternalContest contest, Account account) {
        XMLMemento memento = XMLMemento.createWriteRoot(TEAM_TAG);
        this.addMemento((IMemento)memento, contest, account);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Account account) {
        int teamId = account.getClientId().getClientNumber();
        XMLUtilities.addChild(memento, "external-id", this.useDefaultIfEmpty(account.getExternalId(), "836577" + teamId));
        XMLUtilities.addChild(memento, "id", teamId);
        XMLUtilities.addChild(memento, "name", account.getDisplayName());
        XMLUtilities.addChild(memento, "nationality", account.getCountryCode());
        String regionName = this.getRegionName(contest, account);
        XMLUtilities.addChild(memento, REGION_TAG, regionName);
        XMLUtilities.addChild(memento, "university", account.getDisplayName());
        return memento;
    }

    private String useDefaultIfEmpty(String value, String defaultString) {
        if (value == null || "".equals(value.trim())) {
            return defaultString;
        }
        return value;
    }

    private String getRegionName(IInternalContest contest, Account account) {
        String regionName = "";
        try {
            if (account.getGroupId() != null) {
                Group group = contest.getGroup(account.getGroupId());
                regionName = group.getDisplayName();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup group for " + account + " group id = " + account.getGroupId());
            e.printStackTrace();
        }
        return regionName;
    }

    public XMLMemento createElement(IInternalContest contest, RunTestCase testCase, Run run) {
        XMLMemento memento = XMLMemento.createWriteRoot(TESTCASE_TAG);
        this.addMemento((IMemento)memento, contest, testCase, run);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, RunTestCase testCase, Run run) {
        Problem problem = contest.getProblem(run.getProblemId());
        XMLUtilities.addChild(memento, "i", testCase.getTestNumber());
        XMLUtilities.addChild(memento, "judged", this.titleCaseBoolean(run.isJudged()));
        XMLUtilities.addChild(memento, "judgement_id", run.getNumber());
        XMLUtilities.addChild(memento, "n", problem.getNumberTestCases());
        String result = "JE";
        if (testCase.isPassed()) {
            result = "AC";
        }
        XMLUtilities.addChild(memento, "result", result);
        XMLUtilities.addChild(memento, "run-id", run.getNumber());
        XMLUtilities.addChild(memento, "solved", this.titleCaseBoolean(testCase.isPassed()));
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(run.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Clarification clarification) {
        XMLMemento memento = XMLMemento.createWriteRoot(CLARIFICATION_TAG);
        this.addMemento((IMemento)memento, contest, clarification);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Clarification clarification) {
        String answer = clarification.getAnswer();
        if (answer == null) {
            answer = "";
        }
        XMLUtilities.addChild(memento, "answer", answer);
        XMLUtilities.addChild(memento, "id", clarification.getNumber());
        XMLUtilities.addChild(memento, "answered", this.titleCaseBoolean(clarification.isAnswered()));
        XMLUtilities.addChild(memento, "question", clarification.getQuestion());
        String status = this.getStatus(clarification.isAnswered());
        XMLUtilities.addChild(memento, "status", status);
        XMLUtilities.addChild(memento, TEAM_TAG, clarification.getSubmitter().getClientNumber());
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(clarification.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        XMLUtilities.addChild(memento, "to-all", this.titleCaseBoolean(clarification.isSendToAll()));
        return memento;
    }

    private String getStatus(boolean value) {
        if (value) {
            return "done";
        }
        return "fresh";
    }

    private int getProblemIndex(IInternalContest contest, Problem inProblem) {
        int idx = 0;
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.getElementId().equals(inProblem.getElementId())) {
                return idx + 1;
            }
            ++idx;
            ++n2;
        }
        return -1;
    }

    public XMLMemento createElement(IInternalContest contest, Run run) {
        XMLMemento memento = XMLMemento.createWriteRoot(RUN_TAG);
        this.addMemento((IMemento)memento, contest, run);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Run run) {
        XMLUtilities.addChild(memento, "id", run.getNumber());
        XMLUtilities.addChild(memento, "judged", this.titleCaseBoolean(run.isJudged()));
        Language language = contest.getLanguage(run.getLanguageId());
        XMLUtilities.addChild(memento, LANGUAGE_TAG, language.getDisplayName());
        if (!run.isSolved() && this.isYoungerThanFirstYes(contest, run)) {
            XMLUtilities.addChild(memento, "penalty", "True");
        } else {
            XMLUtilities.addChild(memento, "penalty", "False");
        }
        Problem problem = contest.getProblem(run.getProblemId());
        int problemIndex = this.getProblemIndex(contest, problem);
        XMLUtilities.addChild(memento, PROBLEM_TAG, problemIndex);
        if (run.isJudged()) {
            Judgement judgement = contest.getJudgement(run.getJudgementRecord().getJudgementId());
            String acronym = this.getAcronym(judgement);
            XMLUtilities.addChild(memento, "result", acronym);
        }
        XMLUtilities.addChild(memento, "solved", run.isSolved());
        XMLUtilities.addChild(memento, "status", this.getStatus(run.isJudged()));
        XMLUtilities.addChild(memento, TEAM_TAG, run.getSubmitter().getClientNumber());
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(run.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        return memento;
    }

    protected boolean isYoungerThanFirstYes(IInternalContest contest, Run run) {
        Run firstYes = this.findFistYes(contest, run.getSubmitter(), run.getProblemId());
        if (firstYes == null) {
            return false;
        }
        return run.getElapsedMS() < firstYes.getElapsedMS();
    }

    protected Run findFistYes(IInternalContest contest, ClientId submitter, ElementId problemId) {
        Run[] runs = contest.getRuns();
        Run lastYesRun = null;
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.isSolved() && run.getProblemId().equals(problemId) && run.getSubmitter().equals(submitter)) {
                if (lastYesRun == null) {
                    lastYesRun = run;
                } else if (lastYesRun.getElapsedMS() > run.getElapsedMS()) {
                    lastYesRun = run;
                }
            }
            ++n2;
        }
        return lastYesRun;
    }

    protected String toXML(XMLMemento mementoRoot) {
        try {
            return String.valueOf(mementoRoot.saveToString(true)) + this.getXMLFooterComment();
        }
        catch (IOException e) {
            this.logWarning("Error in creating XML", e);
            return "";
        }
    }

    public String createStartupXML(IInternalContest contest) {
        Filter filter = new Filter();
        filter.setFilteringDeleted(true);
        return this.createStartupXML(contest, filter);
    }

    public String createStartupXML(IInternalContest contest, Filter filter) {
        Clarification[] clarifications;
        Account[] teamAccounts;
        StringBuffer sb = new StringBuffer("<contest>");
        sb.append(this.toXML(this.createInfoElement(contest, contest.getContestInformation())));
        int idx = 1;
        IElementObject[] iElementObjectArray = contest.getLanguages();
        int n = iElementObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = iElementObjectArray[n2];
            sb.append(this.toXML(this.createElement(contest, language, idx)));
            ++idx;
            ++n2;
        }
        idx = 1;
        iElementObjectArray = contest.getProblems();
        n = iElementObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IElementObject problem = iElementObjectArray[n2];
            if (filter.matches((Problem)problem)) {
                sb.append(this.toXML(this.createElement(contest, (Problem)problem, idx)));
            }
            ++idx;
            ++n2;
        }
        Group[] groups = contest.getGroups();
        Arrays.sort(groups, new GroupComparator());
        Group[] groupArray = groups;
        int n3 = groups.length;
        n = 0;
        while (n < n3) {
            Group group = groupArray[n];
            sb.append(this.toXML(this.createElement(contest, group, idx)));
            ++n;
        }
        int sequenceNumber = 1;
        Judgement[] judgementArray = contest.getJudgements();
        int n4 = judgementArray.length;
        n3 = 0;
        while (n3 < n4) {
            Judgement judgement = judgementArray[n3];
            sb.append(this.toXML(this.createElement(contest, judgement, sequenceNumber)));
            ++sequenceNumber;
            ++n3;
        }
        Account[] accountArray = teamAccounts = this.getTeamAccounts(contest);
        int n5 = teamAccounts.length;
        n4 = 0;
        while (n4 < n5) {
            Account account = accountArray[n4];
            if (filter.matches(account) && contest.isAllowed(account.getClientId(), Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                sb.append(this.toXML(this.createElement(contest, account)));
            }
            ++n4;
        }
        Clarification[] clarificationArray = clarifications = contest.getClarifications();
        int n6 = clarifications.length;
        n5 = 0;
        while (n5 < n6) {
            Clarification clarification = clarificationArray[n5];
            sb.append(this.toXML(this.createElement(contest, clarification)));
            ++n5;
        }
        Run[] runs = contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Run[] runArray = runs;
        int n7 = runs.length;
        n6 = 0;
        while (n6 < n7) {
            Run run = runArray[n6];
            if (filter.matches(run)) {
                sb.append(this.toXML(this.createElement(contest, run)));
                RunTestCase[] runTestCases = this.getLastJudgementTestCases(run);
                Arrays.sort(runTestCases, new RunTestCaseComparator());
                RunTestCase[] runTestCaseArray = runTestCases;
                int n8 = runTestCases.length;
                int n9 = 0;
                while (n9 < n8) {
                    RunTestCase runTestCase = runTestCaseArray[n9];
                    if (filter.matchesElapsedTime(runTestCase)) {
                        sb.append(this.toXML(this.createElement(contest, runTestCase, run)));
                    }
                    ++n9;
                }
            } else if (!filter.matchesElapsedTime(run)) {
                sb.append(this.toXML(this.createElement(contest, run)));
            }
            ++n6;
        }
        return sb.toString();
    }

    public XMLMemento createElement(IInternalContest contest, Group group, int idx) {
        XMLMemento memento = XMLMemento.createWriteRoot(REGION_TAG);
        this.addMemento((IMemento)memento, contest, group);
        return memento;
    }

    protected RunTestCase[] getLastJudgementTestCases(Run run) {
        ArrayList<RunTestCase> cases = new ArrayList<RunTestCase>();
        if (run.isJudged()) {
            RunTestCase[] runTestCases = run.getRunTestCases();
            JudgementRecord judgementRecord = run.getJudgementRecord();
            RunTestCase[] runTestCaseArray = runTestCases;
            int n = runTestCases.length;
            int n2 = 0;
            while (n2 < n) {
                RunTestCase runTestCase = runTestCaseArray[n2];
                if (runTestCase.matchesJudgement(judgementRecord)) {
                    cases.add(runTestCase);
                }
                ++n2;
            }
        }
        return cases.toArray(new RunTestCase[cases.size()]);
    }

    public Account[] getTeamAccounts(IInternalContest inContest) {
        Vector<Account> accountVector = inContest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
        Arrays.sort(accounts, new AccountComparator());
        return accounts;
    }

    public String createFinalizeXML(IInternalContest contest, FinalizeData data) {
        StringBuffer sb = new StringBuffer();
        XMLMemento memento = XMLMemento.createWriteRoot(FINALIZE_TAG);
        this.addMemento((IMemento)memento, contest, data);
        sb.append(this.toXML(memento));
        sb.append("</");
        sb.append(CONTEST_TAG);
        sb.append(">");
        return sb.toString();
    }

    private void addMemento(IMemento memento, IInternalContest contest, FinalizeData data) {
        XMLUtilities.addChild(memento, "comment", data.getComment());
        XMLUtilities.addChild(memento, "last-bronze", data.getBronzeRank());
        XMLUtilities.addChild(memento, "last-gold", data.getGoldRank());
        XMLUtilities.addChild(memento, "last-silver", data.getSilverRank());
        XMLUtilities.addChild(memento, "time", "0");
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
    }

    public XMLMemento createElement(IInternalContest contest, Group group) {
        XMLMemento memento = XMLMemento.createWriteRoot(REGION_TAG);
        this.addMemento((IMemento)memento, contest, group);
        return memento;
    }

    public void addMemento(IMemento memento, IInternalContest contest, Group group) {
        XMLUtilities.addChild(memento, "external-id", group.getGroupId());
        XMLUtilities.addChild(memento, "name", group.getDisplayName());
    }

    public XMLMemento createElement(IInternalContest contest, Judgement judgement, int sequenceNumber) {
        XMLMemento memento = XMLMemento.createWriteRoot(JUDGEMENT_TAG);
        this.addMemento((IMemento)memento, contest, judgement, sequenceNumber);
        return memento;
    }

    private String getAcronym(Judgement judgement) {
        if ("OCS".equals(judgement.getAcronym())) {
            return "JE";
        }
        if (judgement.getAcronym() == null || judgement.getAcronym().length() == 0) {
            return "JE";
        }
        return judgement.getAcronym();
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Judgement judgement, int judgementSequence) {
        String name = judgement.getDisplayName();
        String acronym = this.getAcronym(judgement);
        XMLUtilities.addChild(memento, "acronym", acronym);
        XMLUtilities.addChild(memento, "id", judgementSequence);
        XMLUtilities.addChild(memento, "name", name);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, JudgementRecord judgementRecord) {
        XMLMemento memento = XMLMemento.createWriteRoot(JUDGEMENT_RECORD_TAG);
        Judgement judgement = contest.getJudgement(judgementRecord.getJudgementId());
        XMLUtilities.addChild((IMemento)memento, "acronym", this.getAcronym(judgement));
        XMLUtilities.addChild((IMemento)memento, "name", judgement.getDisplayName());
        return memento;
    }

    private String titleCaseBoolean(boolean value) {
        if (value) {
            return "True";
        }
        return "False";
    }

    private void logWarning(String message, Exception e) {
        this.log.log(Log.WARNING, message, e);
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

