/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import edu.csus.ecs.pc2.core.list.RunCompartorByElapsed;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RunStatistics {
    private IInternalContest contest;
    private Map<ElementId, Run> solvedMap = new HashMap<ElementId, Run>();

    public RunStatistics(IInternalContest contest) {
        this.setContest(contest);
    }

    public void setContest(IInternalContest contest) {
        this.contest = contest;
        this.recomputeStatitics();
    }

    private void recomputeStatitics() {
        Run[] runs = this.contest.getRuns();
        if (runs.length == 0 || this.contest.getProblems().length == 0) {
            return;
        }
        Arrays.sort(runs, new RunCompartorByElapsed());
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            ElementId problemId;
            Run run = runArray[n2];
            if (run.isSolved() && !run.isDeleted() && this.solvedMap.get(problemId = run.getProblemId()) == null) {
                this.solvedMap.put(problemId, run);
            }
            ++n2;
        }
    }

    public Run[] firstSolvedRuns() {
        Set<ElementId> keys = this.solvedMap.keySet();
        if (keys.size() == 0) {
            return new Run[0];
        }
        ArrayList<Run> list = new ArrayList<Run>();
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            Run run = this.getFirstSolved(problem);
            if (run != null) {
                list.add(run);
            }
            ++n2;
        }
        return list.toArray(new Run[list.size()]);
    }

    public Run getFirstSolved(Problem problem) {
        return this.solvedMap.get(problem.getElementId());
    }

    public boolean isFirstToSolve(ClientId id, Problem problem) {
        Run run = this.getFirstSolved(problem);
        if (run != null) {
            return run.getSubmitter().equals(id);
        }
        return false;
    }
}

