/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Run;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public class NotificationUtilities {
    public String getBalloonKey(ClientId who, ElementId problemId) {
        return String.valueOf(who.getTripletKey()) + " " + problemId.toString();
    }

    private Account insureAndGetClient(IInternalContest contest, ClientType.Type type) {
        Vector<Account> accounts = contest.getAccounts(type, contest.getSiteNumber());
        Account account = null;
        if (accounts.size() == 0) {
            contest.generateNewAccounts(type.toString(), 1, true);
            account = contest.getAccounts(type, contest.getSiteNumber()).firstElement();
        } else {
            account = accounts.firstElement();
        }
        return account;
    }

    public ClientSettings getScoreboardClientSettings(IInternalContest contest) {
        ClientId id;
        ClientSettings clientSettings;
        BalloonSettings balloonSettings = contest.getBalloonSettings(contest.getSiteNumber());
        if (balloonSettings == null) {
            balloonSettings = new BalloonSettings("ballonSet1", contest.getSiteNumber());
            Account account = this.insureAndGetClient(contest, ClientType.Type.SCOREBOARD);
            balloonSettings.setBalloonClient(account.getClientId());
            contest.addBalloonSettings(balloonSettings);
        }
        if ((clientSettings = contest.getClientSettings(id = balloonSettings.getBalloonClient())) == null) {
            clientSettings = new ClientSettings(id);
            contest.updateClientSettings(clientSettings);
        }
        return clientSettings;
    }

    public BalloonDeliveryInfo addNotification(IInternalContest contest2, Run run) {
        ClientSettings settings = this.getScoreboardClientSettings(contest2);
        Hashtable<String, BalloonDeliveryInfo> balloonList = settings.getBalloonList();
        String key = this.getBalloonKey(run.getSubmitter(), run.getProblemId());
        BalloonDeliveryInfo info = new BalloonDeliveryInfo(run.getSubmitter(), run.getProblemId(), Calendar.getInstance().getTime().getTime());
        balloonList.put(key, info);
        settings.setBalloonList(balloonList);
        contest2.updateClientSettings(settings);
        return info;
    }

    public BalloonDeliveryInfo[] getBalloonDeliveries(IInternalContest contest2) {
        ClientSettings settings = this.getScoreboardClientSettings(contest2);
        Hashtable<String, BalloonDeliveryInfo> balloonList = settings.getBalloonList();
        ArrayList<BalloonDeliveryInfo> balloonDeliveryArray = Collections.list(balloonList.elements());
        BalloonDeliveryInfo[] balloonDeliveryInfos = balloonDeliveryArray.toArray(new BalloonDeliveryInfo[balloonDeliveryArray.size()]);
        return balloonDeliveryInfos;
    }

    public BalloonDeliveryInfo getNotification(IInternalContest contest2, Run run) {
        ClientSettings settings = this.getScoreboardClientSettings(contest2);
        Hashtable<String, BalloonDeliveryInfo> balloonList = settings.getBalloonList();
        String key = this.getBalloonKey(run.getSubmitter(), run.getProblemId());
        return balloonList.get(key);
    }

    public boolean alreadyHasNotification(IInternalContest contest2, Run run) {
        return this.getNotification(contest2, run) != null;
    }
}

