/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Balloon;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class BalloonHandler
implements UIPlugin {
    private IInternalContest contest;
    private Hashtable<String, BalloonDeliveryInfo> sentBalloons = new Hashtable();
    private Hashtable<Integer, BalloonSettings> balloonSettingsHash = new Hashtable();
    private boolean sendNotificationsForPreliminary = false;
    private static final long serialVersionUID = -4763667166259158323L;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.sendNotificationsForPreliminary = inContest.getContestInformation().isPreliminaryJudgementsTriggerNotifications();
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
    }

    @Override
    public String getPluginTitle() {
        return "Balloon Handler methods";
    }

    public Balloon buildBalloon(String answer, ClientId submitter, ElementId problemId, Run aRun) {
        Problem problem;
        BalloonSettings bSettings = this.balloonSettingsHash.get(submitter.getSiteNumber());
        Balloon balloon = new Balloon(bSettings, submitter, this.getContest().getAccount(submitter).getDisplayName(), problemId, this.getContest().getProblem(problemId).getDisplayName(), answer, aRun);
        balloon.setContestTitle(this.getContest().getContestInformation().getContestTitle());
        balloon.setSiteTitle(this.getContest().getSite(submitter.getSiteNumber()).getDisplayName());
        Run[] runs = this.getContest().getRuns(submitter);
        Vector<Problem> v = new Vector<Problem>();
        int i = 0;
        while (i < runs.length) {
            Run run = runs[i];
            problem = this.getContest().getProblem(run.getProblemId());
            if (this.isValidRun(run) && !v.contains(problem)) {
                v.add(problem);
            }
            ++i;
        }
        Problem[] result = new Problem[v.size()];
        int j = 0;
        Problem[] problemArray = this.getContest().getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            problem = problemArray[n2];
            if (v.contains(problem)) {
                result[j] = problem;
                ++j;
            }
            ++n2;
        }
        balloon.setProblems(result);
        return balloon;
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public Hashtable<Integer, BalloonSettings> getBalloonSettingsHash() {
        return this.balloonSettingsHash;
    }

    public void setBalloonSettingsHash(Hashtable<Integer, BalloonSettings> balloonSettingsHash) {
        this.balloonSettingsHash = balloonSettingsHash;
    }

    public boolean hasBalloonBeenSent(String balloonKey) {
        boolean result = false;
        if (this.sentBalloons.containsKey(balloonKey)) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadBalloonSettings() {
        BalloonSettings[] balloonSettings = this.getContest().getBalloonSettings();
        Hashtable<Integer, BalloonSettings> hashtable = this.balloonSettingsHash;
        synchronized (hashtable) {
            this.balloonSettingsHash.clear();
            int i = 0;
            while (i < balloonSettings.length) {
                BalloonSettings settings = balloonSettings[i];
                if (settings.isMatchesBalloonClient(this.getContest().getClientId())) {
                    Integer siteNum = settings.getSiteNumber();
                    this.balloonSettingsHash.put(siteNum, settings);
                }
                ++i;
            }
        }
    }

    public void updateDeliveryInfo(String balloonKey, BalloonDeliveryInfo info) {
        this.sentBalloons.put(balloonKey, info);
    }

    public void setBalloonDeliveryList(Hashtable<String, BalloonDeliveryInfo> balloonList) {
        this.sentBalloons = balloonList;
    }

    public void removeBalloonDelivery(String balloonKey) {
        this.sentBalloons.remove(balloonKey);
    }

    public Hashtable<String, BalloonDeliveryInfo> getBalloonDeliveryList() {
        return this.sentBalloons;
    }

    public BalloonDeliveryInfo getBalloonDeliveryInfo(String balloonKey) {
        return this.sentBalloons.get(balloonKey);
    }

    public Enumeration<String> getBalloonDeliveryInfoKeys() {
        return this.sentBalloons.keys();
    }

    public boolean isRunSolved(ClientId who, ElementId problemId) {
        boolean isSolved = false;
        Run[] runs = this.getContest().getRuns(who);
        int i = 0;
        while (i < runs.length) {
            Run run = runs[i];
            if (run.getProblemId().equals(problemId) && !run.isDeleted() && run.isJudged() && run.isSolved() && this.isValidJudgement(run)) {
                isSolved = true;
                break;
            }
            ++i;
        }
        return isSolved;
    }

    public boolean isValidRun(Run run) {
        if (run.isJudged() && run.isSolved() && !run.isDeleted() && this.isValidJudgement(run)) {
            return run.isSendToTeams() || !this.getContest().isAllowed(Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
        }
        return false;
    }

    public boolean isValidJudgement(Run run) {
        boolean result = false;
        if (run.getStatus().equals((Object)Run.RunStates.JUDGED)) {
            result = true;
        } else if (run.isJudged()) {
            if (run.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW)) {
                if (this.sendNotificationsForPreliminary) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public boolean shouldSendBalloon(Run run) {
        String balloonKey = this.getBalloonKey(run.getSubmitter(), run.getProblemId());
        if (!this.hasBalloonBeenSent(balloonKey)) {
            return this.isValidRun(run);
        }
        return false;
    }

    public boolean shouldRemoveBalloon(Run run) {
        String balloonKey = this.getBalloonKey(run.getSubmitter(), run.getProblemId());
        BalloonDeliveryInfo balloonDeliveryInfo = this.getBalloonDeliveryInfo(balloonKey);
        return balloonDeliveryInfo != null && (run.isDeleted() || !run.isSolved());
    }

    public String getBalloonKey(ClientId who, ElementId problemId) {
        return String.valueOf(who.getTripletKey()) + " " + problemId.toString();
    }

    class ContestInformationListenerImplementation
    implements IContestInformationListener {
        ContestInformationListenerImplementation() {
        }

        @Override
        public void contestInformationAdded(ContestInformationEvent event) {
            ContestInformation ci = event.getContestInformation();
            if (ci != null) {
                boolean oldValue = BalloonHandler.this.sendNotificationsForPreliminary;
                BalloonHandler.this.sendNotificationsForPreliminary = ci.isPreliminaryJudgementsTriggerNotifications();
                if (oldValue != BalloonHandler.this.sendNotificationsForPreliminary && BalloonHandler.this.sendNotificationsForPreliminary) {
                    BalloonHandler.this.reloadBalloonSettings();
                }
            }
        }

        @Override
        public void contestInformationChanged(ContestInformationEvent event) {
            ContestInformation ci = event.getContestInformation();
            if (ci != null) {
                boolean oldValue = BalloonHandler.this.sendNotificationsForPreliminary;
                BalloonHandler.this.sendNotificationsForPreliminary = ci.isPreliminaryJudgementsTriggerNotifications();
                if (oldValue != BalloonHandler.this.sendNotificationsForPreliminary && BalloonHandler.this.sendNotificationsForPreliminary) {
                    BalloonHandler.this.reloadBalloonSettings();
                }
            }
        }

        @Override
        public void contestInformationRemoved(ContestInformationEvent event) {
        }

        @Override
        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BalloonHandler.this.reloadBalloonSettings();
                }
            });
        }

        @Override
        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
        }
    }
}

