/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.transport;

import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.security.Crypto;
import edu.csus.ecs.pc2.core.security.CryptoException;
import edu.csus.ecs.pc2.core.transport.ConnectionHandler;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerClientThread;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerList;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerThread;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerThreadList;
import edu.csus.ecs.pc2.core.transport.IBtoA;
import edu.csus.ecs.pc2.core.transport.ITransportManager;
import edu.csus.ecs.pc2.core.transport.ITwoToOne;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.TransportWrapper;
import java.io.Serializable;
import java.security.PublicKey;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;

public class TransportManager
implements ITransportManager {
    public static final String SVN_ID = "$Id$";
    public static final String DEFAULT_PC2_PORT = "50002";
    private static final String PUBLIC_KEY = "PUBLIC_KEY";
    private String myServerIP = "";
    private int myServerPort = 0;
    private Log log = null;
    private ConnectionHandler myConnection = null;
    private Crypto encryptionKeys = null;
    private ConnectionHandlerThreadList connectionHandlerThreadList = null;
    private ConnectionHandlerList serversConnectionHandlerList = null;
    private TMTypes tmType;
    private ITwoToOne appServerCallBack = null;
    private IBtoA appClientCallBack = null;

    public TransportManager(Log log) {
        this.setLog(log);
        this.setEncrytionKeys(new Crypto());
    }

    @Override
    public void startServerTransport(ITwoToOne appCallBack) {
        this.setConnectionHandlerThreadList(new ConnectionHandlerThreadList());
        this.setTmType(TMTypes.SERVER);
        this.setAppServerCallBack(appCallBack);
        this.setServersConnectionHandlerList(new ConnectionHandlerList());
    }

    @Override
    public void startClientTransport(String serverIP, int port, IBtoA appCallBack) {
        this.setMyServerPort(port);
        this.setMyServerIP(serverIP);
        this.setTmType(TMTypes.CLIENT);
        this.setAppClientCallBack(appCallBack);
    }

    @Override
    public void shutdownTransport() {
        this.info("******************* SHUTTING down transport on command ************************");
        if (this.getTmType() == TMTypes.CLIENT) {
            this.info("******************* SHUTTING down client ************************");
            this.getMyConnection().getConnectionHandlerClientThread().setStillListening(false);
        } else {
            ConnectionHandlerID connectionHandlerID;
            int n;
            int n2;
            ConnectionHandlerID[] connectionHandlerIDArray;
            this.info("******************* SHUTTING server connection down ************************");
            try {
                connectionHandlerIDArray = this.getServersConnectionHandlerList().getKeys();
                n2 = connectionHandlerIDArray.length;
                n = 0;
                while (n < n2) {
                    connectionHandlerID = connectionHandlerIDArray[n];
                    this.info("***** SHUTTING connections on server !! **** handle id = " + connectionHandlerID);
                    try {
                        this.unregisterConnection(connectionHandlerID);
                    }
                    catch (Exception e) {
                        this.info("Exception shutting down a server connection (" + connectionHandlerID + ") ", e);
                    }
                    ++n;
                }
            }
            catch (Exception e) {
                this.info("Exception shutting down a server connection ", e);
            }
            try {
                connectionHandlerIDArray = this.getConnectionHandlerThreadList().getKeys();
                n2 = connectionHandlerIDArray.length;
                n = 0;
                while (n < n2) {
                    connectionHandlerID = connectionHandlerIDArray[n];
                    this.info("***** SHUTTING client connections on server !! **** handle id = " + connectionHandlerID);
                    try {
                        this.unregisterConnection(connectionHandlerID);
                    }
                    catch (Exception e) {
                        this.info("Exception shutting down a client connection (" + connectionHandlerID + ") ", e);
                    }
                    ++n;
                }
            }
            catch (Exception ex) {
                this.info("Exception shutting down a client connection ", ex);
            }
        }
    }

    @Override
    public void connectToMyServer() throws TransportException {
        this.getLog().info("Connecting to " + this.getMyServerIP() + ":" + this.getMyServerPort());
        try {
            ConnectionHandler connectionHandler = new ConnectionHandler(this.getLog(), this.getMyServerIP(), this.getMyServerPort(), this, this.getTmType());
            this.setMyConnection(connectionHandler);
        }
        catch (TransportException e) {
            this.getLog().info("Could not ConnectToMyServer()");
            throw new TransportException(e.getMessage());
        }
    }

    @Override
    public ConnectionHandlerID connectToServer(String serverIP, int port) throws TransportException {
        this.getLog().info("Connecting to " + serverIP + ":" + port);
        try {
            ConnectionHandler connectionHandler = new ConnectionHandler(this.getLog(), serverIP, port, this, this.getTmType());
            return connectionHandler.getConnectionHandlerClientThread().getMyConnectionID();
        }
        catch (TransportException e) {
            this.getLog().info("Could not connect to server @ " + serverIP + ":" + port);
            throw new TransportException(e.getMessage());
        }
    }

    @Override
    public void accecptConnections(int listeningPort) throws TransportException {
        this.getLog().info("accecptConnections on port:" + listeningPort);
        try {
            ConnectionHandler connectionHandler = new ConnectionHandler(this.getLog(), listeningPort, this);
            this.getServersConnectionHandlerList().add(connectionHandler.getConnectionHandlerID(), connectionHandler);
            new Thread(connectionHandler).start();
        }
        catch (Exception e) {
            this.getLog().info("Could not Accept connections on Port:" + listeningPort);
            throw new TransportException(e.getMessage());
        }
    }

    private String getMyServerIP() {
        return this.myServerIP;
    }

    private void setMyServerIP(String myServerIP) {
        this.myServerIP = myServerIP;
    }

    private int getMyServerPort() {
        return this.myServerPort;
    }

    private void setMyServerPort(int myServerPort) {
        this.myServerPort = myServerPort;
    }

    private Log getLog() {
        return this.log;
    }

    private Crypto getEncrytionKeys() {
        return this.encryptionKeys;
    }

    private void setEncrytionKeys(Crypto encrytionKeys) {
        this.encryptionKeys = encrytionKeys;
    }

    public TransportWrapper getPublicKeyPacket() {
        this.getLog().info("Generating Unencrypted Public Key Packet");
        this.getLog().info("checking key:= " + this.getEncrytionKeys().getPublicKey());
        TransportWrapper packet = new TransportWrapper(PUBLIC_KEY, this.getEncrytionKeys().getPublicKey());
        this.getLog().info("packet:= " + packet);
        return packet;
    }

    public void receive(SealedObject transportPacket, ConnectionHandlerID connectionHandlerID) {
        this.getLog().info("public void receive(SealedObject TransportPacket, ConnectionHandlerID connectionHandlerID)");
        Serializable incomingMsg = null;
        try {
            incomingMsg = this.getEncrytionKeys().decrypt(transportPacket, connectionHandlerID.getSecretKey());
        }
        catch (CryptoException e) {
            this.getLog().log(Log.INFO, "Could not decrypt Packet!", e);
        }
        if (incomingMsg != null) {
            if (this.getTmType() == TMTypes.SERVER) {
                final Serializable fIncomingMsg = incomingMsg;
                final ConnectionHandlerID fConnectionHandlerID = connectionHandlerID;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        TransportManager.this.getAppServerCallBack().receiveObject(fIncomingMsg, fConnectionHandlerID);
                    }
                }).start();
            } else {
                final Serializable fIncomingMsg = incomingMsg;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        TransportManager.this.getAppClientCallBack().receiveObject(fIncomingMsg);
                    }
                }).start();
            }
        } else {
            this.getLog().info("Failed to Decrypt incoming message from: " + connectionHandlerID);
        }
    }

    public void connectionDropped(ConnectionHandlerID myConnectionID) {
        this.getLog().info("connectionDropped(ConnectionHandlerID myConnectionID) ");
        if (this.getTmType() == TMTypes.SERVER) {
            ConnectionHandlerThread connectionHandlerThread = this.getConnectionHandlerThreadList().get(myConnectionID);
            if (connectionHandlerThread != null) {
                connectionHandlerThread.shutdownConnection();
                connectionHandlerThread = null;
            }
            this.getConnectionHandlerThreadList().remove(myConnectionID);
            this.getAppServerCallBack().connectionDropped(myConnectionID);
        } else {
            ConnectionHandlerClientThread connectionHandlerClientThread = this.getMyConnection().getConnectionHandlerClientThread();
            if (connectionHandlerClientThread != null) {
                connectionHandlerClientThread.shutdownConnection();
                connectionHandlerClientThread = null;
            }
            this.getAppClientCallBack().connectionDropped();
        }
    }

    @Override
    public void unregisterConnection(ConnectionHandlerID myConnectionID) {
        this.getLog().info("unregisterConnection(ConnectionHandlerID myConnectionID) ");
        if (this.getTmType() == TMTypes.SERVER) {
            ConnectionHandlerThread connectionHandlerThread = this.getConnectionHandlerThreadList().get(myConnectionID);
            connectionHandlerThread.setStillListening(false);
            connectionHandlerThread.shutdownConnection();
            connectionHandlerThread = null;
            this.getConnectionHandlerThreadList().remove(myConnectionID);
            this.getAppServerCallBack().connectionDropped(myConnectionID);
        } else {
            this.getMyConnection().getConnectionHandlerClientThread().setStillListening(false);
            this.getMyConnection().getConnectionHandlerClientThread().shutdownConnection();
            this.getMyConnection().setConnectionHandlerClientThread(null);
            this.getAppClientCallBack().connectionDropped();
        }
    }

    public void registerIncomingConnectionRequest(ConnectionHandlerID myConnectionID, ConnectionHandlerThread thread) {
        this.getLog().info("registerIncomingConnectionRequest(myConnectionID, thread) ");
        this.getConnectionHandlerThreadList().add(myConnectionID, thread);
        this.getAppServerCallBack().connectionEstablished(myConnectionID);
    }

    private ConnectionHandlerThreadList getConnectionHandlerThreadList() {
        return this.connectionHandlerThreadList;
    }

    private void setConnectionHandlerThreadList(ConnectionHandlerThreadList connectionHandlerList) {
        this.connectionHandlerThreadList = connectionHandlerList;
    }

    private ConnectionHandler getMyConnection() {
        return this.myConnection;
    }

    private void setMyConnection(ConnectionHandler myConnection) {
        this.myConnection = myConnection;
    }

    @Override
    public void send(Serializable msgObj) throws TransportException {
        final Serializable fMsgObj = msgObj;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                ConnectionHandlerID fConnectionHandlerID;
                TransportManager.this.getLog().info("send(Serializable)");
                ConnectionHandlerID connectionHandlerID = fConnectionHandlerID = TransportManager.this.getMyConnection().getConnectionHandlerClientThread().getMyConnectionID();
                synchronized (connectionHandlerID) {
                    while (!fConnectionHandlerID.isReadyToCommunicate()) {
                        try {
                            fConnectionHandlerID.wait();
                        }
                        catch (InterruptedException e) {
                            TransportManager.this.getLog().throwing("TransportManager", "Busy wait", e);
                        }
                    }
                }
                SecretKey secretKey = TransportManager.this.getMyConnection().getConnectionHandlerClientThread().getMyConnectionID().getSecretKey();
                SealedObject sealedObject = null;
                try {
                    sealedObject = TransportManager.this.getEncrytionKeys().encrypt(fMsgObj, secretKey);
                }
                catch (CryptoException e) {
                    TransportManager.this.getAppClientCallBack().connectionError(fMsgObj, null, e.getMessage());
                }
                try {
                    TransportManager.this.getMyConnection().send(sealedObject);
                    return;
                }
                catch (Exception e) {
                    TransportManager.this.getAppClientCallBack().connectionError(fMsgObj, null, e.getMessage());
                }
            }
        }).start();
    }

    @Override
    public void send(Serializable msgObj, ConnectionHandlerID connectionHandlerID) throws TransportException {
        final Serializable fMsgObj = msgObj;
        final ConnectionHandlerID fConnectionHandlerID = connectionHandlerID;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                TransportManager.this.getLog().info("send(Serializable, ConnectionHandlerID) to " + fConnectionHandlerID);
                ConnectionHandlerID connectionHandlerID = fConnectionHandlerID;
                synchronized (connectionHandlerID) {
                    while (!fConnectionHandlerID.isReadyToCommunicate()) {
                        try {
                            fConnectionHandlerID.wait();
                        }
                        catch (InterruptedException e) {
                            TransportManager.this.getLog().throwing("TransportManager", "Busy wait", e);
                        }
                    }
                }
                SecretKey secretKey = fConnectionHandlerID.getSecretKey();
                SealedObject sealedObject = null;
                try {
                    sealedObject = TransportManager.this.getEncrytionKeys().encrypt(fMsgObj, secretKey);
                }
                catch (CryptoException e) {
                    if (TransportManager.this.getAppClientCallBack() != null) {
                        TransportManager.this.getAppClientCallBack().connectionError(fMsgObj, fConnectionHandlerID, e.getMessage());
                    }
                    TransportManager.this.log.log(Log.INFO, "Exception in send " + fConnectionHandlerID, e);
                }
                try {
                    TransportManager.this.getConnectionHandlerThreadList().get(fConnectionHandlerID).send(sealedObject);
                    return;
                }
                catch (Exception e) {
                    if (TransportManager.this.getAppClientCallBack() != null) {
                        TransportManager.this.getAppClientCallBack().connectionError(fMsgObj, fConnectionHandlerID, e.getMessage());
                        return;
                    }
                    TransportManager.this.log.log(Log.INFO, "Exception in send " + fConnectionHandlerID, e);
                }
            }
        }).start();
    }

    protected void receiveUnencrypted(TransportWrapper wrapper, ConnectionHandlerID myConnectionID) {
        this.getLog().info("receiveUnencrypted(TransportWrapper, ConnectionHandlerID=" + myConnectionID + ")");
        PublicKey pk = (PublicKey)wrapper.get(PUBLIC_KEY);
        SecretKey tmpKey = this.getEncrytionKeys().generateSecretKey(pk, this.getEncrytionKeys().getPrivateKey());
        this.getEncrytionKeys().setSecretKey(tmpKey);
        myConnectionID.setSecretKey(tmpKey);
        this.getLog().info("receiveUnencrypted Made a secret key for " + myConnectionID + " key is " + tmpKey.toString());
    }

    protected TMTypes getTmType() {
        return this.tmType;
    }

    protected void setTmType(TMTypes tmType) {
        this.tmType = tmType;
    }

    private ITwoToOne getAppServerCallBack() {
        return this.appServerCallBack;
    }

    private void setAppServerCallBack(ITwoToOne appCallBack) {
        this.appServerCallBack = appCallBack;
    }

    private IBtoA getAppClientCallBack() {
        return this.appClientCallBack;
    }

    private void setAppClientCallBack(IBtoA appClientCallBack) {
        this.appClientCallBack = appClientCallBack;
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }

    private ConnectionHandlerList getServersConnectionHandlerList() {
        return this.serversConnectionHandlerList;
    }

    private void setServersConnectionHandlerList(ConnectionHandlerList serversConnectionHandlerList) {
        this.serversConnectionHandlerList = serversConnectionHandlerList;
    }

    private void info(String s) {
        this.getLog().info(s);
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + s);
        System.out.flush();
    }

    public void info(String s, Exception exception) {
        this.getLog().log(Log.INFO, s, exception);
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + s);
        exception.printStackTrace(System.out);
        System.out.flush();
    }

    public static enum TMTypes {
        CLIENT,
        SERVER;

    }
}

