/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.transport;

import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.transport.ConnectionHandler;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.TransportManager;
import edu.csus.ecs.pc2.core.transport.TransportWrapper;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.crypto.SealedObject;

public abstract class ConnectionHandlerThread
extends Thread {
    public static final String SVN_ID = "$Id$";
    private Socket mySocket = null;
    private TransportManager tmCallBack = null;
    private ObjectOutputStream toOtherModule = null;
    private ObjectInputStream fromOtherModule = null;
    private boolean stillListening = false;
    private ConnectionHandlerID myConnectionID = null;
    private Log log = null;

    public ConnectionHandlerThread(Socket socket, TransportManager tmCallBack, ConnectionHandler chCallBack) {
        this.setMySocket(socket);
        this.setTmCallBack(tmCallBack);
        this.setMyConnectionID(new ConnectionHandlerID(socket.toString()));
    }

    protected TransportManager getTmCallBack() {
        return this.tmCallBack;
    }

    private void setTmCallBack(TransportManager tmCallBack) {
        this.tmCallBack = tmCallBack;
    }

    protected Socket getMySocket() {
        return this.mySocket;
    }

    private void setMySocket(Socket mySocket) {
        this.mySocket = mySocket;
    }

    protected ConnectionHandlerID getMyConnectionID() {
        return this.myConnectionID;
    }

    private void setMyConnectionID(ConnectionHandlerID myConnectionID) {
        this.myConnectionID = myConnectionID;
    }

    @Override
    public abstract void run();

    protected boolean isStillListening() {
        return this.stillListening;
    }

    public void setStillListening(boolean stillListening) {
        this.stillListening = stillListening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(SealedObject msgObj) throws TransportException {
        ConnectionHandlerID connectionHandlerID = this.getMyConnectionID();
        synchronized (connectionHandlerID) {
            while (!this.getMyConnectionID().isReadyToCommunicate()) {
                try {
                    this.getMyConnectionID().wait();
                }
                catch (InterruptedException e) {
                    this.getLog().throwing("ConnectionHandlerThread", "Busy wait send", e);
                }
            }
        }
        try {
            connectionHandlerID = this.getMyConnectionID();
            synchronized (connectionHandlerID) {
                this.getToOtherModule().writeObject(msgObj);
                return;
            }
        }
        catch (Exception e) {
            this.getLog().log(Log.INFO, "Exception near writeObject", e);
            throw new TransportException(e.getMessage());
        }
    }

    public void send(TransportWrapper msgToSend) throws TransportException {
        try {
            this.getToOtherModule().writeObject(msgToSend);
        }
        catch (Exception e) {
            this.getLog().throwing(this.getClass().getName(), "send", e);
            throw new TransportException(e.getMessage());
        }
    }

    protected void sendUnencrypted(TransportWrapper msgObj) throws TransportException {
        try {
            this.getToOtherModule().writeObject(msgObj);
        }
        catch (Exception e) {
            this.getLog().throwing(this.getClass().getName(), "sendUnencrypted", e);
            throw new TransportException(e.getMessage());
        }
    }

    protected TransportWrapper receiveUnencrypted() throws TransportException {
        TransportWrapper msgObj = null;
        try {
            msgObj = (TransportWrapper)this.getFromOtherModule().readObject();
        }
        catch (Exception e) {
            this.getLog().throwing(this.getClass().getName(), "receiveUnencrypted", e);
            throw new TransportException(e.getMessage());
        }
        return msgObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SealedObject receive() throws TransportException {
        SealedObject msgObj = null;
        ConnectionHandlerID connectionHandlerID = this.getMyConnectionID();
        synchronized (connectionHandlerID) {
            while (!this.getMyConnectionID().isReadyToCommunicate()) {
                try {
                    this.getMyConnectionID().wait();
                }
                catch (InterruptedException e) {
                    this.getLog().throwing("ConnectionHandlerThread", "Busy wait receive", e);
                }
            }
        }
        try {
            return (SealedObject)this.getFromOtherModule().readObject();
        }
        catch (SocketException e) {
            this.getLog().log(Log.INFO, "SocketException in receive for " + this.getMyConnectionID(), e);
            throw new TransportException(e.getMessage(), TransportException.Type.CONNECTION_RESET);
        }
        catch (EOFException e) {
            this.log.log(Log.INFO, "EOFException in receive for " + this.getMyConnectionID(), e);
            throw new TransportException(e.getMessage(), TransportException.Type.CONNECTION_RESET);
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception in receive for " + this.getMyConnectionID(), e);
            throw new TransportException(e.getMessage(), TransportException.Type.RECEIVE);
        }
    }

    public ObjectInputStream getFromOtherModule() {
        return this.fromOtherModule;
    }

    public void setFromOtherModule(ObjectInputStream fromOtherModule) {
        this.fromOtherModule = fromOtherModule;
    }

    public ObjectOutputStream getToOtherModule() {
        return this.toOtherModule;
    }

    public void setToOtherModule(ObjectOutputStream toOtherModule) {
        this.toOtherModule = toOtherModule;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void shutdownConnection() {
        try {
            if (this.toOtherModule != null) {
                this.toOtherModule.close();
                this.toOtherModule = null;
            }
            if (this.fromOtherModule != null) {
                this.fromOtherModule.close();
                this.fromOtherModule = null;
            }
            if (this.mySocket != null) {
                this.mySocket.close();
                this.mySocket = null;
            }
        }
        catch (Exception exception) {
            this.getLog().log(Log.WARNING, "Shutdown connection - threw exception closing socket", exception);
        }
    }
}

