/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.security;

import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.security.Crypto;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.KeyUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class FileSecurity
implements IStorage {
    public static final String FAILED_TO_ENCRYPT = "FAILED TO ENCRYPT";
    public static final String FAILED_TO_WRITE = "FAILED TO WRITE";
    public static final String FAILED_TO_CREATE_KEY = "FAILED_TO_CREATE_KEY";
    public static final String FAILED_TO_READ_FILE = "FAILED_TO_READ_FILE";
    public static final String FAILED_TO_READ = "FAILED TO READ";
    public static final String NOT_READY_TO_READ = "NOT_READY_TO_READ";
    public static final String NOT_READY_TO_WRITE = "NOT_READY_TO_WRITE";
    public static final String FAILED_TO_INIT_CIPHERS = "FAILED_TO_INIT_CIPHERS";
    public static final String TO_DECRYPT = "FAILED TO DECRYPT";
    public static final String FAILED_TO_DECRYPT = "FAILED_TO_DECRYPT";
    public static final String KEY_FILE_NOT_FOUND = "KEY_FILE_NOT_FOUND";
    private static final String CONTEST_KEY_FILENAME = "contest.key";
    private static final String RECOVERY_KEY_FILENAME = "recovery.key";
    private PBEParameterSpec algorithm;
    private Cipher dcipher;
    private Cipher ecipher;
    private char[] contestPassword;
    private SecretKey contestSecretKey;
    private KeyPair contestKeyPair;
    private static final byte[] PUBLIC_KEY;
    private boolean readyToReadWrite = false;
    private Crypto fileCrypt = null;
    private String contestDirectory = "." + File.separator;

    static {
        byte[] byArray = new byte[162];
        byArray[0] = 48;
        byArray[1] = -127;
        byArray[2] = -97;
        byArray[3] = 48;
        byArray[4] = 13;
        byArray[5] = 6;
        byArray[6] = 9;
        byArray[7] = 42;
        byArray[8] = -122;
        byArray[9] = 72;
        byArray[10] = -122;
        byArray[11] = -9;
        byArray[12] = 13;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[16] = 5;
        byArray[18] = 3;
        byArray[19] = -127;
        byArray[20] = -115;
        byArray[22] = 48;
        byArray[23] = -127;
        byArray[24] = -119;
        byArray[25] = 2;
        byArray[26] = -127;
        byArray[27] = -127;
        byArray[29] = -120;
        byArray[30] = -32;
        byArray[31] = -95;
        byArray[32] = -10;
        byArray[33] = 118;
        byArray[34] = -62;
        byArray[35] = 56;
        byArray[36] = -73;
        byArray[37] = -51;
        byArray[38] = 104;
        byArray[39] = 5;
        byArray[40] = 13;
        byArray[41] = -100;
        byArray[42] = -35;
        byArray[43] = 49;
        byArray[44] = 27;
        byArray[45] = -35;
        byArray[46] = 92;
        byArray[47] = 110;
        byArray[48] = -76;
        byArray[49] = 105;
        byArray[50] = 104;
        byArray[51] = 21;
        byArray[52] = -75;
        byArray[53] = 87;
        byArray[54] = 122;
        byArray[55] = -55;
        byArray[56] = 28;
        byArray[57] = -51;
        byArray[58] = -13;
        byArray[59] = 55;
        byArray[60] = -22;
        byArray[61] = 75;
        byArray[62] = 55;
        byArray[63] = 37;
        byArray[64] = -72;
        byArray[65] = 26;
        byArray[66] = -71;
        byArray[67] = -65;
        byArray[68] = -2;
        byArray[69] = 37;
        byArray[70] = 69;
        byArray[71] = -71;
        byArray[72] = 124;
        byArray[73] = 8;
        byArray[74] = -78;
        byArray[75] = -29;
        byArray[76] = -70;
        byArray[77] = 45;
        byArray[78] = 57;
        byArray[79] = -83;
        byArray[80] = -25;
        byArray[81] = -113;
        byArray[82] = 113;
        byArray[83] = 102;
        byArray[84] = -60;
        byArray[85] = 6;
        byArray[86] = -30;
        byArray[87] = -24;
        byArray[88] = -124;
        byArray[89] = 94;
        byArray[90] = -31;
        byArray[91] = -17;
        byArray[92] = -25;
        byArray[93] = -23;
        byArray[94] = -38;
        byArray[95] = -18;
        byArray[96] = -125;
        byArray[97] = -46;
        byArray[98] = 70;
        byArray[99] = 68;
        byArray[100] = 97;
        byArray[101] = 28;
        byArray[102] = 86;
        byArray[103] = -24;
        byArray[104] = -68;
        byArray[105] = -41;
        byArray[106] = 124;
        byArray[107] = 38;
        byArray[108] = -85;
        byArray[109] = -5;
        byArray[110] = -51;
        byArray[111] = 46;
        byArray[112] = -25;
        byArray[113] = -121;
        byArray[114] = 84;
        byArray[115] = 46;
        byArray[116] = 99;
        byArray[117] = -5;
        byArray[118] = -36;
        byArray[119] = -94;
        byArray[120] = -88;
        byArray[121] = -31;
        byArray[122] = 9;
        byArray[123] = -117;
        byArray[124] = 17;
        byArray[125] = -10;
        byArray[126] = 22;
        byArray[127] = -104;
        byArray[128] = -13;
        byArray[129] = 17;
        byArray[130] = -115;
        byArray[131] = 74;
        byArray[132] = 78;
        byArray[133] = 55;
        byArray[134] = 95;
        byArray[135] = -124;
        byArray[136] = -5;
        byArray[137] = -92;
        byArray[138] = 70;
        byArray[139] = -72;
        byArray[140] = 26;
        byArray[141] = -64;
        byArray[142] = -45;
        byArray[143] = 32;
        byArray[144] = -109;
        byArray[145] = -59;
        byArray[146] = -82;
        byArray[147] = 60;
        byArray[148] = -79;
        byArray[149] = 76;
        byArray[150] = 69;
        byArray[151] = 32;
        byArray[152] = -72;
        byArray[153] = 95;
        byArray[154] = 91;
        byArray[155] = 116;
        byArray[156] = 33;
        byArray[157] = 2;
        byArray[158] = 3;
        byArray[159] = 1;
        byArray[161] = 1;
        PUBLIC_KEY = byArray;
    }

    public FileSecurity(String inContestDirectory) {
        int iteration = 128;
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        this.readyToReadWrite = false;
        this.algorithm = new PBEParameterSpec(salt, iteration);
        Utilities.insureDir(inContestDirectory);
        if (!inContestDirectory.endsWith(File.separator)) {
            inContestDirectory = String.valueOf(inContestDirectory) + File.separator;
        }
        this.contestDirectory = inContestDirectory;
        this.fileCrypt = new Crypto();
        SecretKey sk = this.fileCrypt.generateSecretKey(this.fileCrypt.getPublicKey(), this.fileCrypt.getPrivateKey());
        this.fileCrypt.setSecretKey(sk);
    }

    public String getContestDirectory() {
        return this.contestDirectory;
    }

    public boolean verifyPassword(char[] password) throws FileSecurityException {
        SealedObject objectFromDisk;
        SecretKey secretKey = null;
        KeyPair tmpKeyPair = null;
        if (!Utilities.isFileThere(String.valueOf(this.contestDirectory) + CONTEST_KEY_FILENAME)) {
            throw new FileSecurityException(KEY_FILE_NOT_FOUND);
        }
        try {
            objectFromDisk = (SealedObject)this.readObjectFromFile(String.valueOf(this.contestDirectory) + CONTEST_KEY_FILENAME);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - failed to read file from disk", e);
            throw new FileSecurityException(FAILED_TO_READ_FILE);
        }
        try {
            secretKey = this.makeSecretKey(password);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - failed to create key from password", e);
            throw new FileSecurityException(FAILED_TO_CREATE_KEY);
        }
        this.contestPassword = password;
        this.contestSecretKey = secretKey;
        try {
            this.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - initialize ciphers", e);
            throw new FileSecurityException(FAILED_TO_INIT_CIPHERS);
        }
        try {
            tmpKeyPair = (KeyPair)this.decryptObject(objectFromDisk, secretKey);
        }
        catch (Exception e) {
            if (StaticLog.getLog() != null) {
                StaticLog.getLog().log(Log.INFO, "verify password - failed to decrypt object", e);
            }
            throw new FileSecurityException(FAILED_TO_DECRYPT);
        }
        this.fileCrypt.setMyKeyPair(tmpKeyPair);
        SecretKey sk = this.fileCrypt.generateSecretKey(this.fileCrypt.getPublicKey(), this.fileCrypt.getPrivateKey());
        this.fileCrypt.setSecretKey(sk);
        this.readyToReadWrite = true;
        return true;
    }

    public SecretKey getSecretKey() {
        return this.contestSecretKey;
    }

    public void saveSecretKey(SecretKey theKey, char[] password) throws FileSecurityException {
        this.contestSecretKey = theKey;
        this.contestPassword = password;
        try {
            this.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - initialize ciphers", e);
            throw new FileSecurityException(FAILED_TO_INIT_CIPHERS);
        }
        this.contestKeyPair = this.fileCrypt.getKeyPair();
        this.writePC2RecoveryInfo();
        SealedObject sealedSecretKey = null;
        try {
            sealedSecretKey = this.encryptObject(this.contestKeyPair, this.contestSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to encrypt contestSecretKey", e);
            throw new FileSecurityException(FAILED_TO_ENCRYPT, e);
        }
        try {
            this.writeObjectToFile(String.valueOf(this.contestDirectory) + CONTEST_KEY_FILENAME, sealedSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
        this.readyToReadWrite = true;
    }

    public void saveSecretKey(PublicKey theKey, String filename) throws FileSecurityException {
        try {
            this.writeObjectToFile(String.valueOf(this.contestDirectory) + filename, (Serializable)this.contestPassword);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writePC2RecoveryFile - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
    }

    public void saveSecretKey(char[] password) throws FileSecurityException {
        SealedObject sealedSecretKey = null;
        SecretKey secretKey = null;
        this.contestPassword = password;
        try {
            this.contestSecretKey = this.makeSecretKey(password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - initialize ciphers", e);
            throw new FileSecurityException(FAILED_TO_INIT_CIPHERS);
        }
        this.contestKeyPair = this.fileCrypt.getKeyPair();
        try {
            sealedSecretKey = this.encryptObject(this.contestKeyPair, secretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to encrypt contestSecretKey", e);
            throw new FileSecurityException(FAILED_TO_ENCRYPT, e);
        }
        try {
            this.writeObjectToFile(String.valueOf(this.contestDirectory) + CONTEST_KEY_FILENAME, sealedSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
        this.writePC2RecoveryInfo();
        this.readyToReadWrite = true;
    }

    private void writePC2RecoveryInfo() throws FileSecurityException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(PUBLIC_KEY);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            KeyUtilities.encryptString(String.valueOf(this.contestDirectory) + new String(this.contestPassword), String.valueOf(this.contestDirectory) + RECOVERY_KEY_FILENAME, publicKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writePC2RecoveryFile - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
    }

    public String getPassword() {
        return new String(this.contestPassword);
    }

    public boolean writeSealedFile(String fileName, Serializable objectToWrite) throws FileSecurityException {
        SealedObject sealedObjectToWrite;
        if (!this.readyToReadWrite) {
            throw new FileSecurityException(NOT_READY_TO_WRITE);
        }
        try {
            sealedObjectToWrite = this.fileCrypt.encrypt(objectToWrite);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writeFile - failed to encrypt object", e);
            throw new FileSecurityException(FAILED_TO_ENCRYPT, e);
        }
        try {
            this.writeObjectToFile(fileName, sealedObjectToWrite);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writeFile - failed to write file to disk", e);
            throw new FileSecurityException(FAILED_TO_WRITE, e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable readSealedFile(String fileName) throws FileSecurityException, IOException, ClassNotFoundException {
        SealedObject sealedObjectFromDisk;
        Serializable objectToReturn = null;
        if (!this.readyToReadWrite) {
            throw new FileSecurityException(NOT_READY_TO_READ);
        }
        FileSecurity fileSecurity = this;
        synchronized (fileSecurity) {
            sealedObjectFromDisk = (SealedObject)this.readObjectFromFile(fileName);
        }
        try {
            objectToReturn = this.fileCrypt.decrypt(sealedObjectFromDisk);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "readFile - failed to decrypt object", e);
            throw new FileSecurityException(TO_DECRYPT, e);
        }
        return objectToReturn;
    }

    private SecretKey makeSecretKey(char[] pwd) throws Exception {
        SecretKey key = null;
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(pwd);
            SecretKeyFactory keyBuilder = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            key = keyBuilder.generateSecret(pbeKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return key;
    }

    private void cipherInit() throws Exception {
        try {
            this.ecipher = Cipher.getInstance("PBEWithMD5AndDES");
            this.ecipher.init(1, (Key)this.contestSecretKey, this.algorithm);
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new Exception(e.getMessage());
        }
        try {
            this.dcipher = Cipher.getInstance("PBEWithMD5AndDES");
            this.dcipher.init(2, (Key)this.contestSecretKey, this.algorithm);
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new Exception(e.getMessage());
        }
    }

    private SealedObject encryptObject(Serializable objToEncrypt, SecretKey inSecretKey) throws Exception {
        SealedObject encryptedObject = null;
        try {
            encryptedObject = new SealedObject(objToEncrypt, this.ecipher);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception(e.getMessage());
        }
        return encryptedObject;
    }

    private Serializable decryptObject(SealedObject encryptedObject, SecretKey inSecretKey) throws Exception {
        Serializable decryptedObject = null;
        try {
            decryptedObject = (Serializable)encryptedObject.getObject(this.dcipher);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new Exception(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new Exception(e.getMessage());
        }
        return decryptedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeObjectToFile(String filename, Serializable serializable) throws IOException {
        FileSecurity fileSecurity = this;
        synchronized (fileSecurity) {
            FileOutputStream f = new FileOutputStream(filename);
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(serializable);
            s.flush();
            s.close();
            s = null;
        }
        return true;
    }

    private Object readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        Object object = new Object();
        FileInputStream in = new FileInputStream(filename);
        ObjectInputStream s = new ObjectInputStream(in);
        object = s.readObject();
        in.close();
        s.close();
        return object;
    }

    @Override
    public String getDirectoryName() {
        return this.getContestDirectory();
    }

    @Override
    public Serializable load(String fileName) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.readSealedFile(fileName);
    }

    @Override
    public boolean store(String fileName, Serializable serializable) throws IOException, ClassNotFoundException, FileSecurityException {
        return this.writeSealedFile(fileName, serializable);
    }

    public boolean isReadyToReadWrite() {
        return this.readyToReadWrite;
    }

    public static String getContestKeyFileName() {
        return CONTEST_KEY_FILENAME;
    }
}

