/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReportFile;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.exports.ccs.Teamdata;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TeamsTSVReport
implements IReportFile {
    private static final long serialVersionUID = -8189572973252444134L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "teams.tsv";
    }

    @Override
    public void createReportFile(String filename, Filter aFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
                printWriter.close();
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
        }
    }

    @Override
    public String[] createReport(Filter aFilter) {
        Teamdata teamdata = new Teamdata();
        String[] lines = teamdata.getTeamData(this.contest);
        return lines;
    }

    @Override
    public String createReportXML(Filter aFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public void writeReport(PrintWriter printWriter) throws Exception {
        String[] lines;
        Teamdata teamdata = new Teamdata();
        String[] stringArray = lines = teamdata.getTeamData(this.contest);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            printWriter.println(string);
            ++n2;
        }
    }

    @Override
    public String getReportTitle() {
        return "teams.tsv";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
    }

    @Override
    public boolean suppressHeaderFooter() {
        return true;
    }
}

