/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReportFile;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class SubmissionsTSVReport
implements IReportFile {
    private static final long serialVersionUID = -674666232557526609L;
    private static final String DELIMITER = "\t";
    private static final String DEFAULT_ACRONYM = "??";
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();
    private String[] acronymList = new String[]{"No - Compilation Error;CE", "No - Security Violation;SV", "No - Time Limit Exceeded;TLE", "No - Wrong Output;WA", "Yes;AC", "Accepted;AC", "Wrong Answer;WA"};

    String createLine(Run run) {
        StringBuffer buf = new StringBuffer();
        ClientId clientId = run.getSubmitter();
        buf.append(run.getNumber());
        buf.append(DELIMITER);
        buf.append(clientId.getClientNumber());
        buf.append(DELIMITER);
        Problem problem = this.contest.getProblem(run.getProblemId());
        buf.append(problem.getShortName());
        buf.append(DELIMITER);
        buf.append(run.getElapsedMS());
        buf.append(DELIMITER);
        buf.append(this.getJudgementAcronym(run));
        return buf.toString();
    }

    private String getJudgementAcronym(Run run) {
        String acronym = null;
        JudgementRecord judgementRecord = run.getJudgementRecord();
        if (judgementRecord != null) {
            String judgementText = null;
            Judgement judgement = this.contest.getJudgement(judgementRecord.getJudgementId());
            if (judgement != null) {
                acronym = judgement.getAcronym();
                judgementText = judgement.getDisplayName();
            }
            if (acronym == null || "".equals(acronym.trim())) {
                acronym = run.isSolved() ? "AC" : this.guessAcronym(judgementText);
            }
        } else {
            acronym = "NEW";
        }
        return acronym;
    }

    private String guessAcronym(String judgementText) {
        if (judgementText == null) {
            return DEFAULT_ACRONYM;
        }
        String[] stringArray = this.acronymList;
        int n = this.acronymList.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] fields = line.split(";");
            String name = fields[0];
            String acro = fields[1];
            if (name.trim().toLowerCase().equals(judgementText.trim().toLowerCase())) {
                return acro;
            }
            ++n2;
        }
        return DEFAULT_ACRONYM;
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        String[] lines;
        String[] stringArray = lines = this.getReportLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            printWriter.println(string);
            ++n2;
        }
    }

    private String[] getReportLines() {
        ArrayList<String> list;
        block7: {
            Run[] runs;
            block6: {
                Run run;
                list = new ArrayList<String>();
                runs = this.contest.getRuns();
                Arrays.sort(runs, new RunComparator());
                if (this.filter == null || !this.filter.isFilterOn()) break block6;
                int count = 0;
                Run[] runArray = runs;
                int n = runs.length;
                int n2 = 0;
                while (n2 < n) {
                    run = runArray[n2];
                    if (this.filter.matches(run)) {
                        ++count;
                    }
                    ++n2;
                }
                if (count <= 0) break block7;
                runArray = runs;
                n = runs.length;
                n2 = 0;
                while (n2 < n) {
                    run = runArray[n2];
                    if (this.filter.matches(run)) {
                        list.add(this.createLine(run));
                    }
                    ++n2;
                }
                break block7;
            }
            Run[] runArray = runs;
            int n = runs.length;
            int n3 = 0;
            while (n3 < n) {
                Run run = runArray[n3];
                if (!run.isDeleted()) {
                    list.add(this.createLine(run));
                }
                ++n3;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
                printWriter.close();
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        this.filter = inFilter;
        return this.getReportLines();
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "submissions.tsv";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "submissions.tsv";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public boolean suppressHeaderFooter() {
        return true;
    }
}

