/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.export.RunStatisticsXML;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class RunStatisticsReport
implements IReport {
    private static final long serialVersionUID = -672453617982063041L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    private void writeRow(PrintWriter printWriter, Run run) {
        ClientId clientId = run.getSubmitter();
        printWriter.print("run " + run.getNumber() + " ");
        if (run.isDeleted()) {
            printWriter.print("DELETED ");
        }
        printWriter.print((Object)((Object)run.getStatus()) + " ");
        printWriter.print("s" + run.getSiteNumber() + " ");
        printWriter.print("at " + run.getElapsedMins() + " (" + run.getCreateDate() + ") ");
        printWriter.print(String.valueOf(clientId.getName()) + " (" + this.getClientName(clientId) + ") ");
        printWriter.print(this.contest.getProblem(run.getProblemId()) + " ");
        printWriter.print(this.contest.getLanguage(run.getLanguageId()) + " ");
        if (run.isDeleted()) {
            printWriter.print(" DELETED ");
        }
        printWriter.println();
        ClientId whoCheckedOutId = this.contest.getRunCheckedOutBy(run);
        if (whoCheckedOutId != null) {
            printWriter.println("    Checked out by: " + whoCheckedOutId);
        }
        if (run.getAllJudgementRecords().length > 0) {
            JudgementRecord[] judgementRecordArray = run.getAllJudgementRecords();
            int n = judgementRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                JudgementRecord judgementRecord = judgementRecordArray[n2];
                if (this.contest == null) {
                    printWriter.println("Contest is null");
                }
                if (judgementRecord.getJudgementId() == null) {
                    printWriter.println("Judgement is null for " + run);
                }
                ElementId elmentId = judgementRecord.getJudgementId();
                String judgementText = this.contest.getJudgement(elmentId).toString();
                String validatorJudgementName = judgementRecord.getValidatorResultString();
                if (judgementRecord.isUsedValidator() && validatorJudgementName != null) {
                    if (validatorJudgementName.trim().length() == 0) {
                        validatorJudgementName = "undetermined";
                    }
                    judgementText = validatorJudgementName;
                }
                printWriter.print("     ");
                printWriter.print(" '" + judgementText + "'");
                printWriter.print(" by " + judgementRecord.getJudgerClientId().getName() + "/s" + judgementRecord.getJudgerClientId().getSiteNumber());
                if (judgementRecord.isComputerJudgement()) {
                    printWriter.print("/Computer");
                } else if (judgementRecord.isUsedValidator()) {
                    printWriter.print("/Validator");
                }
                printWriter.print(" at " + judgementRecord.getWhenJudgedTime());
                printWriter.println();
                printWriter.print("     ");
                printWriter.println(" execute time = " + judgementRecord.getExecuteMS() + "ms");
                ++n2;
            }
        }
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        if (this.filter.isFilterOn()) {
            printWriter.println("Filter: " + this.filter.toString());
            printWriter.println();
            int count = this.filter.countRuns(runs);
            if (count == 0) {
                printWriter.println("-- No runs match of " + runs.length + " runs (filtered) --");
            } else {
                printWriter.println("-- " + count + " of " + runs.length + " runs (filtered) --");
                Run[] runArray = runs;
                int n = runs.length;
                int n2 = 0;
                while (n2 < n) {
                    Run run = runArray[n2];
                    if (this.filter.matches(run)) {
                        try {
                            this.writeRow(printWriter, run);
                        }
                        catch (Exception e) {
                            printWriter.println("Exception in report: " + e.getMessage());
                            e.printStackTrace(printWriter);
                        }
                    }
                    ++n2;
                }
            }
        } else {
            printWriter.println("-- " + runs.length + " runs --");
            Run[] runArray = runs;
            int n = runs.length;
            int n3 = 0;
            while (n3 < n) {
                Run run = runArray[n3];
                try {
                    this.writeRow(printWriter, run);
                }
                catch (Exception e) {
                    printWriter.println("Exception in report: " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
                ++n3;
            }
        }
    }

    private String getClientName(ClientId clientId) {
        Account account = this.contest.getAccount(clientId);
        if (account != null) {
            return account.getDisplayName();
        }
        return clientId.getName();
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        RunStatisticsXML runStatisticsXML = new RunStatisticsXML();
        return runStatisticsXML.toXML(this.contest, this.filter);
    }

    @Override
    public String getReportTitle() {
        return "Run Statistics";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Runs Statistics Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

