/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.ParseArguments;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.imports.ContestXML;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ConfigurationIO;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.InternalContest;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.report.AccountPermissionReport;
import edu.csus.ecs.pc2.core.report.AccountsReport;
import edu.csus.ecs.pc2.core.report.AccountsTSVReport;
import edu.csus.ecs.pc2.core.report.AccountsTSVReportTeamAndJudges;
import edu.csus.ecs.pc2.core.report.AllReports;
import edu.csus.ecs.pc2.core.report.AutoJudgingSettingsReport;
import edu.csus.ecs.pc2.core.report.BalloonDeliveryReport;
import edu.csus.ecs.pc2.core.report.BalloonSettingsReport;
import edu.csus.ecs.pc2.core.report.BalloonSummaryReport;
import edu.csus.ecs.pc2.core.report.ClarificationsReport;
import edu.csus.ecs.pc2.core.report.ClientSettingsReport;
import edu.csus.ecs.pc2.core.report.ContestAnalysisReport;
import edu.csus.ecs.pc2.core.report.ContestReport;
import edu.csus.ecs.pc2.core.report.ContestSettingsReport;
import edu.csus.ecs.pc2.core.report.EvaluationReport;
import edu.csus.ecs.pc2.core.report.EventFeed2013Report;
import edu.csus.ecs.pc2.core.report.EventFeedReport;
import edu.csus.ecs.pc2.core.report.ExtractPlaybackLoadFilesReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedSummaryReport;
import edu.csus.ecs.pc2.core.report.FinalizeReport;
import edu.csus.ecs.pc2.core.report.GroupsReport;
import edu.csus.ecs.pc2.core.report.GroupsTSVReport;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.InternalDumpReport;
import edu.csus.ecs.pc2.core.report.JSON2016Report;
import edu.csus.ecs.pc2.core.report.JSONReport;
import edu.csus.ecs.pc2.core.report.JudgementNotificationsReport;
import edu.csus.ecs.pc2.core.report.JudgementReport;
import edu.csus.ecs.pc2.core.report.JudgingAnalysisReport;
import edu.csus.ecs.pc2.core.report.LanguagesReport;
import edu.csus.ecs.pc2.core.report.ListRunLanguages;
import edu.csus.ecs.pc2.core.report.LoginReport;
import edu.csus.ecs.pc2.core.report.NotificationsReport;
import edu.csus.ecs.pc2.core.report.OldRunsReport;
import edu.csus.ecs.pc2.core.report.PasswordsReport;
import edu.csus.ecs.pc2.core.report.PluginsReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.report.ProfileCloneSettingsReport;
import edu.csus.ecs.pc2.core.report.ProfilesReport;
import edu.csus.ecs.pc2.core.report.ResolverEventFeedReport;
import edu.csus.ecs.pc2.core.report.RunJudgementNotificationsReport;
import edu.csus.ecs.pc2.core.report.RunsByTeamReport;
import edu.csus.ecs.pc2.core.report.RunsReport;
import edu.csus.ecs.pc2.core.report.RunsReport5;
import edu.csus.ecs.pc2.core.report.RunsTSVReport;
import edu.csus.ecs.pc2.core.report.ScoreboardTSVReport;
import edu.csus.ecs.pc2.core.report.SitesReport;
import edu.csus.ecs.pc2.core.report.SolutionsByProblemReport;
import edu.csus.ecs.pc2.core.report.StandingsReport;
import edu.csus.ecs.pc2.core.report.SubmissionsTSVReport;
import edu.csus.ecs.pc2.core.report.TeamsTSVReport;
import edu.csus.ecs.pc2.core.report.UserdataTSVReport;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import edu.csus.ecs.pc2.profile.ProfileLoadException;
import edu.csus.ecs.pc2.profile.ProfileManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public final class Reports {
    private String profileName = null;
    private char[] password = null;
    private int siteNumber = 1;
    private String directory = null;
    private boolean usingProfile = true;
    private static final String FILE_OPTION_STRING = "-F";

    public Reports(String profileName, char[] charArray) {
        this.profileName = profileName;
        this.password = charArray;
    }

    public static IReport[] getReports() {
        Vector<IReport> reports = new Vector<IReport>();
        reports.add(new AccountsReport());
        reports.add(new BalloonSummaryReport());
        reports.add(new AllReports());
        reports.add(new ContestSettingsReport());
        reports.add(new ContestReport());
        reports.add(new ContestAnalysisReport());
        reports.add(new SolutionsByProblemReport());
        reports.add(new ListRunLanguages());
        reports.add(new FastestSolvedSummaryReport());
        reports.add(new FastestSolvedReport());
        reports.add(new StandingsReport());
        reports.add(new LoginReport());
        reports.add(new ProfilesReport());
        reports.add(new PluginsReport());
        reports.add(new RunsReport());
        reports.add(new ClarificationsReport());
        reports.add(new ProblemsReport());
        reports.add(new LanguagesReport());
        reports.add(new JudgementReport());
        reports.add(new RunsByTeamReport());
        reports.add(new BalloonSettingsReport());
        reports.add(new ClientSettingsReport());
        reports.add(new GroupsReport());
        reports.add(new EvaluationReport());
        reports.add(new OldRunsReport());
        reports.add(new RunsReport5());
        reports.add(new AccountPermissionReport());
        reports.add(new BalloonDeliveryReport());
        reports.add(new ExtractPlaybackLoadFilesReport());
        reports.add(new RunJudgementNotificationsReport());
        reports.add(new JudgementNotificationsReport());
        reports.add(new ProfileCloneSettingsReport());
        reports.add(new SitesReport());
        reports.add(new EventFeedReport());
        reports.add(new NotificationsReport());
        reports.add(new FinalizeReport());
        reports.add(new InternalDumpReport());
        reports.add(new PasswordsReport());
        reports.add(new AccountsTSVReportTeamAndJudges());
        reports.add(new AccountsTSVReport());
        reports.add(new RunsTSVReport());
        reports.add(new JSONReport());
        reports.add(new EventFeed2013Report());
        reports.add(new UserdataTSVReport());
        reports.add(new GroupsTSVReport());
        reports.add(new TeamsTSVReport());
        reports.add(new ScoreboardTSVReport());
        reports.add(new SubmissionsTSVReport());
        reports.add(new ResolverEventFeedReport());
        reports.add(new AutoJudgingSettingsReport());
        reports.add(new JudgingAnalysisReport());
        reports.add(new JSON2016Report());
        return reports.toArray(new IReport[reports.size()]);
    }

    public static void listReports() {
        int i = 0;
        IReport[] iReportArray = Reports.getReports();
        int n = iReportArray.length;
        int n2 = 0;
        while (n2 < n) {
            IReport report = iReportArray[n2];
            System.out.println("Report " + ++i + " " + report.getReportTitle());
            ++n2;
        }
    }

    public static void usage() {
        String[] lines;
        String[] stringArray = lines = new String[]{"Usage: [options] reportName|## [[reportName|##][...]]", "", "-F filename    - specify command line options in filename", "--profile name - profile name, default uses current profile.  name may be a ## from --listp listing", "--contestPassword padd  - password needed to decrypt pc2 data", "--xml          - output only XML for report", "--list         - list names of reports (and the report numbers)", "--dir name     - alternate base directory name, by default uses profile dir name", "--site ##      - specify the site number", "--listp        - list all profile names with numbers", "--noProfile - do not use profile directory use pre version 9.2 location", "", "reportName - name of report to print (or report number)", "##         - number of report to print (numbers found using --list)", "", "$ pc2reports --listp", "1 - Id: Contest-1526060434834405723 description: Real Contest name: Contest", "2 - Id: Contest 3--613094433664018852 description: Real Contest 3 name: Contest 3", "", "Default name  : Contest", "  Profile ID  : Contest-1526060434834405723", "  Description : Real Contest", "  Path        : profiles\\Pdf812e23-4234-46ee-ad3c-4011c8cb885e", "", "Each of these will print the same report:", "$ pc2report --contestPassword newpass --profile Contest 3--613094433664018852 'Fastest Solution Summary'", "$ pc2report --contestPassword newpass --profile 2 'Fastest Solution Summary'", "$ pc2report --contestPassword newpass --profile Contest 3--613094433664018852 9", "$ pc2report --contestPassword newpass --profile 2 9", "", "Precedence for directory: --dir, --profile, then default profile dir", ""};
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
        VersionInfo info = new VersionInfo();
        System.out.println(info.getSystemVersionInfo());
    }

    protected static int getInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static IReport getReport(String arg) throws Exception {
        int reportNumber = Reports.getInteger(arg);
        IReport selectedReport = null;
        if (reportNumber > 0) {
            IReport[] reports = Reports.getReports();
            if (reportNumber > reports.length) {
                throw new Exception("No such report number " + reportNumber);
            }
            selectedReport = reports[reportNumber - 1];
        } else {
            IReport[] iReportArray = Reports.getReports();
            int n = iReportArray.length;
            int n2 = 0;
            while (n2 < n) {
                IReport report = iReportArray[n2];
                if (report.getReportTitle().startsWith(arg) && selectedReport == null) {
                    selectedReport = report;
                }
                ++n2;
            }
        }
        return selectedReport;
    }

    public String getReportFileName(IReport selectedReport) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String reportName = selectedReport.getReportTitle();
        while (reportName.indexOf(32) > -1) {
            reportName = reportName.replace(" ", "_");
        }
        return "report." + reportName + "." + simpleDateFormat.format(new Date()) + ".txt";
    }

    private void printReport(String arg, boolean outputXML) {
        String dirName = null;
        try {
            if (this.getDirectory() == null) {
                if (this.isUsingProfile()) {
                    ProfileManager manager = new ProfileManager();
                    Profile profile = null;
                    if (this.getProfileName() == null) {
                        profile = manager.getDefaultProfile();
                        System.err.println("Using default profile is: " + profile.getName() + " " + profile.getProfilePath());
                    } else {
                        Profile[] profiles;
                        Profile[] profileArray = profiles = manager.load();
                        int n = profiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Profile checkProfile = profileArray[n2];
                            if (checkProfile.getContestId().equals(this.getProfileName())) {
                                profile = checkProfile;
                            }
                            ++n2;
                        }
                        if (profile == null) {
                            System.err.println("No profile named " + this.getProfileName() + " in " + "profiles.properties");
                            return;
                        }
                    }
                    System.err.println("Using profile " + profile.getName() + " " + profile.getProfilePath());
                    dirName = profile.getProfilePath();
                } else {
                    dirName = ".";
                }
            } else {
                dirName = this.getDirectory();
            }
            dirName = String.valueOf(dirName) + File.separator + "db." + this.getSiteNumber();
            if (!new File(dirName).isDirectory()) {
                System.err.println("Directory does not exist: " + dirName);
                return;
            }
            FileSecurity security = new FileSecurity(dirName);
            security.verifyPassword(this.getPassword());
            FileSecurity storage = security;
            ConfigurationIO configurationIO = new ConfigurationIO(storage);
            if (this.getSiteNumber() == 0) {
                this.setSiteNumber(1);
            }
            InternalContest contest = new InternalContest();
            Log log = new Log("pc2reports.log");
            StaticLog.setLog(log);
            contest.setStorage(storage);
            contest.initializeSubmissions(this.getSiteNumber(), false);
            if (!configurationIO.loadFromDisk(this.getSiteNumber(), contest, log)) {
                System.err.println("Unable to read contest data from disk");
                return;
            }
            ClientId clientId = new ClientId(this.getSiteNumber(), ClientType.Type.ADMINISTRATOR, 1);
            contest.setClientId(clientId);
            IReport report = Reports.getReport(arg);
            if (report == null) {
                System.out.println("Unable to match/find report " + arg);
            } else {
                InternalController controller = new InternalController(contest);
                controller.setLog(log);
                String filename = this.getReportFileName(report);
                report.setContestAndController(contest, controller);
                if (outputXML) {
                    String xml = report.createReportXML(new Filter());
                    this.writeFile(filename, xml);
                } else {
                    report.createReportFile(filename, new Filter());
                }
                this.catfile(filename);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ERROR nothing to print, no pc2 files/profiles found under " + Utilities.getCurrentDirectory());
        }
        catch (FileSecurityException fse) {
            System.err.println("ERROR " + this.getFSEMsg(fse));
            System.err.println("For directory " + dirName);
            fse.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeFile(String filename, String s) throws IOException {
        FileOutputStream fis = new FileOutputStream(filename, false);
        fis.write(s.getBytes());
        fis.close();
        fis = null;
    }

    private String getFSEMsg(FileSecurityException fse) {
        if ("FAILED_TO_DECRYPT".equals(fse.getLocalizedMessage())) {
            return "Invalid password (password does not match)";
        }
        return fse.getLocalizedMessage();
    }

    public String getProfileName() {
        return this.profileName;
    }

    public char[] getPassword() {
        return this.password;
    }

    private void catfile(String filename) {
        try {
            String[] lines;
            String[] stringArray = lines = Utilities.loadFile(filename);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                System.out.println(s);
                ++n2;
            }
        }
        catch (IOException e) {
            System.err.println("Unable to write to file " + filename);
            e.printStackTrace();
        }
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }

    public void setSiteNumber(int siteNumber) {
        this.siteNumber = siteNumber;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    protected static void fatalError(String message, Exception ex) {
        System.err.println(message);
        ex.printStackTrace(System.err);
        System.exit(2);
    }

    protected static void fatalError(String message) {
        Reports.fatalError(message, null);
    }

    public static void main(String[] args) {
        String[] requireArguementArgs = new String[]{"--contestPassword", "--profile", "--dir", "--site", FILE_OPTION_STRING};
        ParseArguments arguments = new ParseArguments(args, requireArguementArgs);
        if (args.length == 0) {
            Reports.usage();
            System.exit(2);
        }
        if (arguments.isOptPresent("--help")) {
            Reports.usage();
            System.exit(0);
        }
        if (arguments.isOptPresent(FILE_OPTION_STRING)) {
            String propertiesFileName = arguments.getOptValue(FILE_OPTION_STRING);
            if (!new File(propertiesFileName).exists()) {
                Reports.fatalError(String.valueOf(propertiesFileName) + " does not exist (pwd: " + Utilities.getCurrentDirectory() + ")", null);
            }
            try {
                arguments.overRideOptions(propertiesFileName);
            }
            catch (IOException e) {
                Reports.fatalError("Unable to read file " + propertiesFileName, e);
            }
        }
        if (arguments.isOptPresent("--list")) {
            Reports.listReports();
            System.exit(0);
        }
        if (arguments.isOptPresent("--listp")) {
            Reports.listProfiles();
            System.exit(0);
        }
        if (arguments.getArgCount() == 0) {
            Reports.fatalError("No reports specified, none printed");
        }
        boolean xmlOutputOption = arguments.isOptPresent("--xml");
        String password = arguments.getOptValue("--contestPassword");
        String profileName = arguments.getOptValue("--profile");
        int number = Reports.getInteger(arguments.getOptValue("--site"));
        if (number == 0) {
            number = 1;
        }
        if (password == null) {
            Reports.fatalError("Contest Password (--contestPassword) is required");
        }
        profileName = Reports.lookupProfileName(profileName);
        Reports reports = new Reports(profileName, password.toCharArray());
        reports.setUsingProfile(!arguments.isOptPresent("--noProfile"));
        reports.setSiteNumber(number);
        int i = 0;
        while (i < arguments.getArgCount()) {
            String arg = arguments.getArg(i);
            reports.printReport(arg, xmlOutputOption);
            ++i;
        }
    }

    private static String lookupProfileName(String name) {
        if (name != null && name.matches("^\\d+$")) {
            try {
                Profile[] list = new ProfileManager().load();
                int profileNumber = Reports.getInteger(name);
                if (list.length > 0 && profileNumber - 1 < list.length) {
                    return list[profileNumber - 1].getContestId();
                }
            }
            catch (Exception exception) {
                return name;
            }
        }
        return name;
    }

    public boolean isUsingProfile() {
        return this.usingProfile;
    }

    public void setUsingProfile(boolean usingProfile) {
        this.usingProfile = usingProfile;
    }

    private static void listProfiles() {
        try {
            Profile profile;
            if (!new File("profiles.properties").exists()) {
                System.err.println("No profiles exist (Profile properties files does not exist: profiles.properties )");
                return;
            }
            Profile[] list = new ProfileManager().load();
            if (list.length > 0) {
                int i = 1;
                Profile[] profileArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Profile profile2 = profileArray[n2];
                    System.out.println(String.valueOf(i) + " - Id: " + profile2.getContestId() + " description: " + profile2.getDescription() + " name: " + profile2.getName());
                    ++i;
                    ++n2;
                }
                System.out.println();
            }
            if ((profile = new ProfileManager().getDefaultProfile()) != null) {
                System.out.println("Default name  : " + profile.getName() + "\n  Profile ID  : " + profile.getContestId() + "\n  Description : " + profile.getDescription() + "\n  Path        : " + profile.getProfilePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        catch (ProfileLoadException e) {
            e.printStackTrace(System.err);
        }
    }

    public static String notImplementedXML(IReport report) throws IOException {
        return Reports.notImplementedXML(report, "");
    }

    public static String notImplementedXML(IReport report, String message) throws IOException {
        ContestXML contestXML = new ContestXML();
        XMLMemento mementoRoot = XMLMemento.createWriteRoot("report");
        IMemento memento = mementoRoot.createChild("message");
        memento.putString("name", "Not implemented");
        if (message != null && message.length() > 0) {
            memento.putString("info", message);
        }
        memento.putString("reportName", report.getReportTitle());
        contestXML.addVersionInfo(mementoRoot, null);
        contestXML.addFileInfo(mementoRoot);
        return mementoRoot.saveToString();
    }
}

