/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;

public class ProblemsReport
implements IReport {
    private static final long serialVersionUID = 977130815676827828L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    private void writeContestTime(PrintWriter printWriter) {
        printWriter.println();
        GregorianCalendar resumeTime = this.contest.getContestTime().getResumeTime();
        if (resumeTime == null) {
            printWriter.println("Contest date/time: never started");
        } else {
            printWriter.println("Contest date/time: " + resumeTime.getTime());
        }
    }

    public void writeRow(PrintWriter printWriter, Problem problem, ProblemDataFiles problemDataFiles) {
        String deletedText = "";
        if (!problem.isActive()) {
            deletedText = " [HIDDEN] ";
        }
        printWriter.println("  Problem '" + problem + deletedText + "' ver=" + problem.getElementId().getVersionNumber() + " id=" + problem.getElementId());
        printWriter.println("       Short name       : " + problem.getShortName());
        printWriter.println("       Letter           : " + problem.getLetter());
        printWriter.println("       Data file name   : " + problem.getDataFileName());
        printWriter.println("       Answer file name : " + problem.getAnswerFileName());
        printWriter.println("       Read from stdin  : " + Utilities.yesNoString(problem.isReadInputDataFromSTDIN()));
        printWriter.println("       Number test cases: " + problem.getNumberTestCases());
        printWriter.println();
        printWriter.print("   Execution time limit : " + problem.getTimeOutInSeconds() + " seconds");
        if (problem.getTimeOutInSeconds() == 0) {
            printWriter.print(" (no time limit when zero seconds)");
        }
        printWriter.println();
        printWriter.println("        Computer Judged : " + problem.isComputerJudged());
        if (problem.isComputerJudged()) {
            printWriter.println("         Manual Review  : " + problem.isManualReview());
        } else {
            printWriter.println("         Manual Review  : true");
        }
        printWriter.println("  Show Prelim Judgement : " + problem.isPrelimaryNotification());
        printWriter.println();
        printWriter.println("        Using validator : " + problem.isValidatedProblem());
        printWriter.println("         Validator name : " + problem.getValidatorProgramName());
        printWriter.println("     Validator cmd line : " + problem.getValidatorCommandLine());
        printWriter.println("     Validator option # : " + problem.getWhichPC2Validator());
        printWriter.println("    Using pc2 validator : " + problem.isUsingPC2Validator());
        printWriter.println("   Using external files : " + problem.isUsingExternalDataFiles() + " path = " + problem.getExternalDataFileLocation());
        printWriter.println("               CCS mode : " + problem.isCcsMode());
        if (problem.getAnswerFileName() != null) {
            if (problemDataFiles != null) {
                if (problemDataFiles.getJudgesAnswerFiles().length == 0) {
                    printWriter.println("                          Warning - no answer files defined (no contents) ");
                }
            } else {
                printWriter.println("                          Warning - no data/answer files defined (null problemDataFiles) ");
            }
        }
        if (problem.getAnswerFileName() != null) {
            if (problemDataFiles != null) {
                if (problemDataFiles.getJudgesDataFiles().length == 0) {
                    printWriter.println("                          Warning - no judges data files defined (no contents) ");
                }
            } else {
                printWriter.println("                          Warning - no data/judge files defined (null problemDataFiles) ");
            }
        }
        if (problem.getNumberTestCases() > 1) {
            int i = 0;
            while (i < problem.getNumberTestCases()) {
                int testCaseNumber = i + 1;
                String datafile = problem.getDataFileName(testCaseNumber);
                String answerfile = problem.getAnswerFileName(testCaseNumber);
                printWriter.println("       Data File name " + testCaseNumber + " : " + datafile);
                printWriter.println("     Answer File name " + testCaseNumber + " : " + answerfile);
                ++i;
            }
        }
        this.writeProblemDataFiles(printWriter, problemDataFiles);
    }

    public void writeProblemDataFiles(PrintWriter printWriter, ProblemDataFiles problemDataFiles) {
        if (problemDataFiles != null) {
            String shaSum;
            String name;
            Integer bytes;
            SerializedFile serializedFile;
            int n;
            int n2;
            SerializedFile[] serializedFileArray;
            SerializedFile[] judgesDataFiles = problemDataFiles.getJudgesDataFiles();
            SerializedFile[] judgesAnswerFiles = problemDataFiles.getJudgesAnswerFiles();
            if (judgesDataFiles != null) {
                printWriter.println("                  " + judgesDataFiles.length + " judge data files");
                if (judgesDataFiles.length > 0) {
                    serializedFileArray = judgesDataFiles;
                    n2 = judgesDataFiles.length;
                    n = 0;
                    while (n < n2) {
                        serializedFile = serializedFileArray[n];
                        bytes = null;
                        name = null;
                        shaSum = null;
                        if (serializedFile != null && serializedFile.getBuffer() != null) {
                            bytes = serializedFile.getBuffer().length;
                            name = serializedFile.getName();
                            shaSum = serializedFile.getSHA1sum();
                        }
                        printWriter.println("                    judge data file '" + name + "' " + bytes + " bytes, " + this.internExternDesc(serializedFile) + " SHA1 = " + shaSum);
                        ++n;
                    }
                }
            } else {
                printWriter.println("                  * No judge's data files *");
            }
            if (judgesAnswerFiles != null) {
                printWriter.println("                  " + judgesAnswerFiles.length + " judge answer files");
                if (judgesAnswerFiles.length > 0) {
                    serializedFileArray = judgesAnswerFiles;
                    n2 = judgesAnswerFiles.length;
                    n = 0;
                    while (n < n2) {
                        serializedFile = serializedFileArray[n];
                        bytes = null;
                        name = null;
                        shaSum = null;
                        if (serializedFile != null && serializedFile.getBuffer() != null) {
                            bytes = serializedFile.getBuffer().length;
                            name = serializedFile.getName();
                            shaSum = serializedFile.getSHA1sum();
                        }
                        printWriter.println("                    judge ans. file '" + name + "' " + bytes + " bytes, " + this.internExternDesc(serializedFile) + " SHA1 = " + shaSum);
                        ++n;
                    }
                }
            } else {
                printWriter.println("                  * No judge's answer files *");
            }
        } else {
            printWriter.println("                  * No judge's data or answer files *");
        }
        if (problemDataFiles != null && problemDataFiles.getValidatorFile() != null) {
            SerializedFile validatorFile = problemDataFiles.getValidatorFile();
            printWriter.println("                  1 validator file");
            int bytes = 0;
            if (validatorFile.getBuffer() != null) {
                bytes = validatorFile.getBuffer().length;
            }
            printWriter.println("                    validator file '" + validatorFile.getName() + "' " + bytes + " bytes " + this.internExternDesc(validatorFile));
        } else {
            printWriter.println("                  * No validator files *");
        }
    }

    private String internExternDesc(SerializedFile serializedFile) {
        if (serializedFile.isExternalFile()) {
            return "External";
        }
        return "Internal";
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- " + this.contest.getProblems().length + " problems --");
        ContestInformation info = this.contest.getContestInformation();
        if (info != null) {
            String judgeCDPBasePath = info.getJudgeCDPBasePath();
            if (judgeCDPBasePath == null) {
                judgeCDPBasePath = "";
            }
            printWriter.println();
            printWriter.println("  Location for Judges CDP / problem config : '" + judgeCDPBasePath + "'");
            String adminCDPPath = info.getAdminCDPBasePath();
            if (adminCDPPath == null) {
                adminCDPPath = "";
            }
            printWriter.println("  Location for  Admin CDP / problem config : '" + adminCDPPath + "'");
        }
        IElementObject[] iElementObjectArray = this.contest.getProblems();
        int n = iElementObjectArray.length;
        int adminCDPPath = 0;
        while (adminCDPPath < n) {
            Problem problem = iElementObjectArray[adminCDPPath];
            printWriter.println();
            ProblemDataFiles problemDataFiles = this.contest.getProblemDataFile(problem);
            this.writeRow(printWriter, problem, problemDataFiles);
            ++adminCDPPath;
        }
        printWriter.println();
        printWriter.println("-- " + this.contest.getProblemDataFiles().length + " problem data file sets --");
        iElementObjectArray = this.contest.getProblemDataFiles();
        n = iElementObjectArray.length;
        adminCDPPath = 0;
        while (adminCDPPath < n) {
            IElementObject problemDataFile = iElementObjectArray[adminCDPPath];
            printWriter.println();
            Problem problem = this.contest.getProblem(((ProblemDataFiles)problemDataFile).getProblemId());
            printWriter.println("  Problem Data File set for " + problem + " id=" + ((ProblemDataFiles)problemDataFile).getProblemId());
            this.writeProblemDataFiles(printWriter, (ProblemDataFiles)problemDataFile);
            ++adminCDPPath;
        }
        Category[] categories = this.contest.getCategories();
        if (categories.length > 0) {
            printWriter.println(" Categories:");
            int i = 0;
            while (i < categories.length) {
                Category category = categories[i];
                printWriter.println("  " + category);
                ++i;
            }
        } else {
            printWriter.println(" Categories: (not defined)");
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
        this.writeContestTime(printWriter);
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Problems";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Problems Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

