/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.playback.PlaybackRecord;
import edu.csus.ecs.pc2.core.model.playback.ReplayEvent;
import edu.csus.ecs.pc2.core.model.playback.ReplayEventDetails;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;

public class PlaybackDumpReport
implements IReport {
    private static final long serialVersionUID = 2976642766561948728L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Playback Dump Info";
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Playback Dump Info Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        PlaybackInfo[] playbackInfos = this.contest.getPlaybackInfos();
        printWriter.println();
        printWriter.println("-- " + playbackInfos.length + " playbacks --");
        PlaybackInfo[] playbackInfoArray = playbackInfos;
        int n = playbackInfos.length;
        int n2 = 0;
        while (n2 < n) {
            PlaybackInfo playbackInfo = playbackInfoArray[n2];
            printWriter.println();
            this.writeRow(printWriter, playbackInfo);
            PlaybackRecord[] records = this.contest.getPlaybackManager().getPlaybackRecords();
            this.dumpPlaybackRecords(printWriter, records);
            ++n2;
        }
    }

    private void dumpPlaybackRecords(PrintWriter printWriter, PlaybackRecord[] records) {
        printWriter.println("   -- " + records.length + " playback records --");
        PlaybackRecord[] playbackRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            PlaybackRecord record = playbackRecordArray[n2];
            printWriter.print("   " + record.getSequenceNumber());
            printWriter.print(" " + (Object)((Object)record.getEventStatus()));
            printWriter.print(" " + (Object)((Object)record.getEventType()));
            ReplayEvent event = record.getReplayEvent();
            printWriter.print(" " + event.getClientId());
            ReplayEventDetails details = event.getEventDetails();
            if (details == null) {
                printWriter.print(" (no event detail)");
            } else {
                Clarification clar;
                Run run = details.getRun();
                if (run != null) {
                    printWriter.print(" details = " + run);
                }
                if ((clar = details.getClarification()) != null) {
                    printWriter.print(" details = " + clar);
                }
            }
            printWriter.println();
            ++n2;
        }
    }

    private void writeRow(PrintWriter printWriter, PlaybackInfo playbackInfo) {
        printWriter.println("   title        : " + playbackInfo.getDisplayName());
        printWriter.println("   started      : " + Utilities.yesNoString(playbackInfo.isStarted()));
        printWriter.println("   date started : " + playbackInfo.getDateStarted());
        printWriter.println("   pacing mx    : " + playbackInfo.getWaitBetweenEventsMS());
        printWriter.println("   min events   : " + playbackInfo.getMinimumPlaybackRecords());
        printWriter.println("   filename     : " + playbackInfo.getFilename());
        printWriter.println("   element id   : " + playbackInfo.getElementId());
    }

    private void writeContestTime(PrintWriter printWriter) {
        printWriter.println();
        GregorianCalendar resumeTime = this.contest.getContestTime().getResumeTime();
        if (resumeTime == null) {
            printWriter.println("Contest date/time: never started");
        } else {
            printWriter.println("Contest date/time: " + resumeTime.getTime());
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
        this.writeContestTime(printWriter);
        printWriter.println();
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }
}

