/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class PasswordsReport
implements IReport {
    private static final long serialVersionUID = -817826475144454899L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = null;

    @Override
    public void writeReport(PrintWriter printWriter) {
        String[] passwords;
        String[] stringArray = passwords = this.getPasswords();
        int n = passwords.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            printWriter.println(string);
            ++n2;
        }
    }

    private String[] getPasswords() {
        ArrayList<String> list = new ArrayList<String>();
        Vector<Account> vector = this.contest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = vector.toArray(new Account[vector.size()]);
        Arrays.sort(accounts, new AccountComparator());
        if (this.filter != null) {
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId;
                Account account = accountArray[n2];
                if (this.filter.matches(account) && ClientType.Type.TEAM.equals((Object)(clientId = account.getClientId()).getClientType())) {
                    list.add(account.getPassword());
                }
                ++n2;
            }
        } else {
            int thisSite = this.contest.getSiteNumber();
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n3 = 0;
            while (n3 < n) {
                Account account = accountArray[n3];
                ClientId clientId = account.getClientId();
                if (thisSite == clientId.getSiteNumber() && ClientType.Type.TEAM.equals((Object)clientId.getClientType())) {
                    list.add(account.getPassword());
                }
                ++n3;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        return this.getPasswords();
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Passwords";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Passwords Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

