/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class LoginReport
implements IReport {
    private static final long serialVersionUID = 8813054233796013087L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    @Override
    public void writeReport(PrintWriter printWriter) {
        ConnectionHandlerID connectionHandlerID;
        ClientId clientId;
        int n;
        int n2;
        ClientId[] clientIdArray;
        ClientId[] clientIds;
        ClientType.Type ctype;
        printWriter.println();
        printWriter.println("-- Local Logins -- ");
        Object[] objectArray = ClientType.Type.values();
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ctype = objectArray[n4];
            clientIds = this.contest.getLocalLoggedInClients(ctype);
            if (clientIds.length > 0) {
                printWriter.println("Logged in " + ctype.toString());
                clientIdArray = clientIds;
                n2 = clientIds.length;
                n = 0;
                while (n < n2) {
                    clientId = clientIdArray[n];
                    try {
                        connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                        printWriter.println("   " + clientId + " on " + connectionHandlerID);
                    }
                    catch (Exception e) {
                        printWriter.println("Exception in report: " + e.getMessage());
                        e.printStackTrace(printWriter);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        printWriter.println();
        printWriter.println("-- Remote Logins -- ");
        objectArray = ClientType.Type.values();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            ctype = objectArray[n4];
            clientIds = this.contest.getRemoteLoggedInClients(ctype);
            if (clientIds.length > 0) {
                printWriter.println("Logged in " + ctype.toString());
                clientIdArray = clientIds;
                n2 = clientIds.length;
                n = 0;
                while (n < n2) {
                    clientId = clientIdArray[n];
                    try {
                        connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                        printWriter.println("   " + clientId + " on " + connectionHandlerID);
                    }
                    catch (Exception e) {
                        printWriter.println("Exception in report: " + e.getMessage());
                        e.printStackTrace(printWriter);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        printWriter.println();
        printWriter.println("-- Connection Ids  -- ");
        objectArray = this.contest.getConnectionHandleIDs();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            ClientType.Type connectionHandlerID2 = objectArray[n4];
            try {
                ClientId clientId2 = this.contest.getClientId((ConnectionHandlerID)((Object)connectionHandlerID2));
                if (clientId2 != null) {
                    printWriter.print(" client " + clientId2);
                }
                printWriter.print("   " + (Object)((Object)connectionHandlerID2));
                printWriter.println();
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            ++n4;
        }
    }

    public void printConnections(PrintWriter printWriter) {
        printWriter.println();
        ConnectionHandlerID[] connectionHandlerIDs = this.contest.getConnectionHandleIDs();
        printWriter.println("-- " + connectionHandlerIDs.length + " Connections --");
        ConnectionHandlerID[] connectionHandlerIDArray = connectionHandlerIDs;
        int n = connectionHandlerIDs.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionHandlerID connectionHandlerID = connectionHandlerIDArray[n2];
            printWriter.println("  " + connectionHandlerID);
            ++n2;
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Logins";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Logins Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

