/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunCompartorByElapsed;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Submission;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class FastestSolvedSummaryReport
implements IReport {
    private static final long serialVersionUID = 3878379207856922664L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Vector<Run> fastestRuns = new Vector<Run>();
        int count = this.filter.countRuns(runs);
        printWriter.println("There are " + count + " runs.");
        printWriter.println();
        Problem[] problems = this.contest.getProblems();
        if (problems == null || problems.length == 0) {
            printWriter.println("No problems defined, nothing to report");
            return;
        }
        int totalSolved = 0;
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (!run.isDeleted() && run.isSolved()) {
                ++totalSolved;
            }
            ++n2;
        }
        if (totalSolved < 1) {
            printWriter.println("No runs have been solved, nothing to report");
            return;
        }
        int solved = 0;
        printWriter.println();
        printWriter.println(" ** Summarized by team");
        printWriter.println();
        printWriter.println("   At Team                                Problem");
        printWriter.println("  --- ----------------------------------- ------------------");
        IElementObject[] iElementObjectArray = problems;
        int n3 = problems.length;
        n = 0;
        while (n < n3) {
            Problem problem = iElementObjectArray[n];
            Run[] runList = this.filterForProblem(runs, problem);
            Arrays.sort(runList, new RunCompartorByElapsed());
            Run[] runArray2 = runList;
            int n4 = runList.length;
            int n5 = 0;
            while (n5 < n4) {
                Run run = runArray2[n5];
                if (!run.isDeleted() && run.isSolved() && this.filter.matches(run)) {
                    fastestRuns.add(run);
                    ++solved;
                    break;
                }
                ++n5;
            }
            ++n;
        }
        runs = fastestRuns.toArray(new Run[fastestRuns.size()]);
        Arrays.sort(runs, new RunCompartorByElapsed());
        iElementObjectArray = runs;
        n3 = runs.length;
        n = 0;
        while (n < n3) {
            IElementObject run = iElementObjectArray[n];
            try {
                Account account = this.contest.getAccount(((Submission)run).getSubmitter());
                String accountName = String.valueOf(((Submission)run).getSubmitter().getName()) + " (site " + ((Submission)run).getSiteNumber() + ")";
                if (account != null) {
                    accountName = account.getDisplayName();
                }
                Problem problem = this.contest.getProblem(((Submission)run).getProblemId());
                printWriter.format("%5d %-35s %s", ((Submission)run).getElapsedMins(), accountName, problem.getDisplayName());
                printWriter.println();
            }
            catch (Exception e) {
                printWriter.println("Run " + run + " Exception " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            ++n;
        }
        printWriter.println("  --- ----------------------------------- ------------------");
        printWriter.println();
        printWriter.println();
        printWriter.println(" ** Summarized by problem");
        printWriter.println();
        printWriter.println("   At Problem                             Team");
        printWriter.println("  --- ----------------------------------- ---------------------------------");
        Vector<Problem> unsolvedProblems = new Vector<Problem>();
        Problem[] problemArray = problems;
        int n6 = problems.length;
        n3 = 0;
        while (n3 < n6) {
            Problem problem = problemArray[n3];
            boolean foundRun = false;
            String hiddenText = "";
            if (!problem.isActive()) {
                hiddenText = " [HIDDEN] ";
            }
            Run[] runArray3 = runs;
            int n7 = runs.length;
            int n8 = 0;
            while (n8 < n7) {
                Run run = runArray3[n8];
                try {
                    if (run.getProblemId().equals(problem.getElementId())) {
                        Account account = this.contest.getAccount(run.getSubmitter());
                        String accountName = String.valueOf(run.getSubmitter().getName()) + " (site " + run.getSiteNumber() + ")";
                        if (account != null) {
                            accountName = account.getDisplayName();
                        }
                        printWriter.format("%5d %-35s %s", run.getElapsedMins(), String.valueOf(hiddenText) + problem.getDisplayName(), accountName);
                        printWriter.println();
                        foundRun = true;
                    }
                }
                catch (Exception e) {
                    printWriter.println("Run " + run + " Exception " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
                ++n8;
            }
            if (!foundRun) {
                printWriter.format("      %-35s %s", String.valueOf(hiddenText) + problem.getDisplayName(), "(Not Solved)");
                printWriter.println();
                unsolvedProblems.add(problem);
            }
            ++n3;
        }
        printWriter.println("  --- ----------------------------------- ---------------------------------");
        printWriter.println();
        int notsolved = problems.length - solved;
        if (notsolved > 0) {
            Problem[] problemList;
            printWriter.println("  ** " + notsolved + " problems were not solved");
            Problem[] problemArray2 = problemList = unsolvedProblems.toArray(new Problem[unsolvedProblems.size()]);
            int n9 = problemList.length;
            int n10 = 0;
            while (n10 < n9) {
                Problem problem = problemArray2[n10];
                String hiddenText = "";
                if (!problem.isActive()) {
                    hiddenText = " [HIDDEN] ";
                }
                printWriter.println("     " + hiddenText + problem.getDisplayName());
                ++n10;
            }
            printWriter.println();
        }
        if (problems.length == solved) {
            printWriter.println("ALL problems solved");
        } else if (solved == 0) {
            printWriter.println("NO problems solved");
        } else {
            printWriter.println("There were " + solved + " of " + problems.length + " problems solved.");
        }
    }

    private Run[] filterForProblem(Run[] runs, Problem problem) {
        Vector<Run> runVector = new Vector<Run>();
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.getProblemId().equals(problem.getElementId())) {
                runVector.addElement(run);
            }
            ++n2;
        }
        return runVector.toArray(new Run[runVector.size()]);
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public String[] createReport(Filter arg0) {
        return null;
    }

    @Override
    public String createReportXML(Filter arg0) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Fastest Solutions Summary";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Fastest Solutions Summary Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

