/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.export.ExportYAML;
import edu.csus.ecs.pc2.core.list.FileComparator;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

public class ExportYamlReport
implements IReport {
    private static final long serialVersionUID = -6693261389633976350L;
    private IInternalContest contest;
    private IInternalController controller;
    private Filter filter = new Filter();
    private String directoryName;
    private String outputfilename;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.controller.logWarning("Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public void writeReport(PrintWriter printWriter) throws Exception {
        ExportYAML exportYAML = new ExportYAML();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.ss.SSS");
        if (this.directoryName == null) {
            this.directoryName = "reports" + File.separator + "yaml" + simpleDateFormat.format(new Date());
        }
        printWriter.println();
        printWriter.println("Writing YAML files to " + this.directoryName);
        if (!new File(this.directoryName).isDirectory()) {
            new File(this.directoryName).mkdirs();
        }
        if (this.outputfilename == null) {
            this.outputfilename = String.valueOf(this.directoryName) + File.separator + "contest.yaml";
        }
        exportYAML.writeContestYAMLFiles(this.contest, this.directoryName, this.outputfilename);
        this.listFiles(printWriter, "  file ", this.directoryName);
        printWriter.println();
        printWriter.println("contest.yaml contents");
        printWriter.println();
        Utilities.catFile(printWriter, this.outputfilename);
        printWriter.println();
    }

    private void listFiles(PrintWriter printWriter, String prefix, String directory) throws Exception {
        File entry;
        File[] entries = new File(directory).listFiles();
        Arrays.sort(entries, new FileComparator());
        File[] fileArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            entry = fileArray[n2];
            if (entry.isFile()) {
                printWriter.println(String.valueOf(prefix) + directory + File.separator + entry.getName());
            }
            ++n2;
        }
        fileArray = entries;
        n = entries.length;
        n2 = 0;
        while (n2 < n) {
            entry = fileArray[n2];
            if (entry.isDirectory()) {
                this.listFiles(printWriter, prefix, String.valueOf(directory) + File.separator + entry.getName());
            }
            ++n2;
        }
    }

    @Override
    public String getPluginTitle() {
        return "Export Contest YAML files";
    }

    @Override
    public String getReportTitle() {
        return "Export Contest YAML files";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
        this.writeContestTime(printWriter);
        printWriter.println();
    }

    private void writeContestTime(PrintWriter printWriter) {
        printWriter.println();
        GregorianCalendar resumeTime = this.contest.getContestTime().getResumeTime();
        if (resumeTime == null) {
            printWriter.println("Contest date/time: never started");
        } else {
            printWriter.println("Contest date/time: " + resumeTime.getTime());
        }
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setOutputfilename(String outputfilename) {
        this.outputfilename = outputfilename;
    }
}

