/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.exports.ccs.EventFeedXML2013;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EventFeed2013Report
implements IReport {
    private static final long serialVersionUID = -2555946890129189222L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    @Override
    public void writeReport(PrintWriter printWriter) throws IOException {
        printWriter.println("-- Start Event Feed XML --");
        printWriter.println(this.createReportXML(this.filter));
        printWriter.println();
        printWriter.println("-- End Event Feed XML --");
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        this.filter = inFilter;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public String[] createReport(Filter inFilter) {
        this.filter = inFilter;
        return new String[0];
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        if (this.contest != null) {
            EventFeedXML2013 eventFeedXML = new EventFeedXML2013();
            return eventFeedXML.toXML(this.contest, this.filter);
        }
        return Reports.notImplementedXML(this, "contest is not set (null)");
    }

    @Override
    public String getReportTitle() {
        return "Event Feed 2013 XML";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Event Feed 2013 XML Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

