/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ClientSettingsComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.JudgementNotification;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;

public class ClientSettingsReport
implements IReport {
    private static final long serialVersionUID = -8850091501021448900L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    private String getProblemlist(Filter inFilter) {
        ElementId[] elementIds = inFilter.getProblemIdList();
        if (elementIds.length == 0) {
            return "(none selected)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            ElementId[] elementIdArray = elementIds;
            int n3 = elementIds.length;
            int n4 = 0;
            while (n4 < n3) {
                ElementId elementId = elementIdArray[n4];
                if (problem.getElementId().equals(elementId)) {
                    stringBuffer.append(problem.getDisplayName());
                    stringBuffer.append(", ");
                }
                ++n4;
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            return new String(stringBuffer).substring(0, stringBuffer.length() - 2);
        }
        return "(none active selected)";
    }

    private String enabledString(boolean b) {
        if (b) {
            return "is ENABLED";
        }
        return "is not enabled";
    }

    private void writeRow(PrintWriter printWriter, ClientSettings clientSettings) {
        printWriter.print(clientSettings.getClientId());
        if (this.isJudge(clientSettings.getClientId())) {
            printWriter.println(" auto judge " + this.enabledString(clientSettings.isAutoJudging()));
            Filter clientFilter = clientSettings.getAutoJudgeFilter();
            if (clientFilter != null) {
                ElementId[] elementIds = clientFilter.getProblemIdList();
                printWriter.println("     Auto judging " + elementIds.length + " problems : " + this.getProblemlist(clientFilter));
            }
        } else {
            printWriter.println();
        }
        Object[] keys = clientSettings.getKeys();
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            printWriter.println("   " + (String)key + "='" + clientSettings.getProperty((String)key) + "'");
            ++n2;
        }
        Hashtable<String, BalloonDeliveryInfo> hashtable = clientSettings.getBalloonList();
        keys = hashtable.keySet().toArray(new String[hashtable.keySet().size()]);
        Arrays.sort(keys);
        Object[] objectArray2 = keys;
        int n3 = keys.length;
        n = 0;
        while (n < n3) {
            Object balloonKey = objectArray2[n];
            BalloonDeliveryInfo balloonDeliveryInfo = hashtable.get(balloonKey);
            ElementId problemElementId = balloonDeliveryInfo.getProblemId();
            ClientId clientId = balloonDeliveryInfo.getClientId();
            Problem problem = this.contest.getProblem(problemElementId);
            BalloonSettings balloonSettings = this.contest.getBalloonSettings(clientId.getSiteNumber());
            String color = "";
            if (balloonSettings != null) {
                color = balloonSettings.getColor(problemElementId);
            }
            printWriter.println("    " + (String)balloonKey + " " + color + " " + problem + " " + clientId);
            ++n;
        }
        NotificationSetting notificationSetting = clientSettings.getNotificationSetting();
        if (notificationSetting == null) {
            printWriter.println("    No notification delivery settings defined.");
        } else {
            JudgementNotification judgementNotification = null;
            judgementNotification = notificationSetting.getPreliminaryNotificationYes();
            printWriter.println("          Prelim Yes send " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting.getPreliminaryNotificationNo();
            printWriter.println("          Prelim No  send " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting.getFinalNotificationYes();
            printWriter.println("          Final  Yes send " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting.getFinalNotificationNo();
            printWriter.println("          Final  No  send " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
        }
    }

    private boolean isJudge(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        ClientSettings[] clientSettings = this.contest.getClientSettingsList();
        Arrays.sort(clientSettings, new ClientSettingsComparator());
        printWriter.println("-- " + clientSettings.length + " client settings --");
        ClientSettings[] clientSettingsArray = clientSettings;
        int n = clientSettings.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings2 = clientSettingsArray[n2];
            this.writeRow(printWriter, clientSettings2);
            ++n2;
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Client Settings";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Client Settings Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

