/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class ClarificationsReport
implements IReport {
    private static final long serialVersionUID = -273649856656225241L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Clarification[] clarifications = this.contest.getClarifications();
        Arrays.sort(clarifications, new ClarificationComparator());
        int count = this.filter.countClarifications(clarifications);
        if (this.filter.isFilterOn()) {
            printWriter.println("Filter is: " + this.filter.toString());
            printWriter.println();
            printWriter.println("-- " + count + " clarifications (filtered) --");
        } else {
            printWriter.println("-- " + clarifications.length + " clarifications --");
        }
        Clarification[] clarificationArray = clarifications;
        int n = clarifications.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clarification = clarificationArray[n2];
            if (this.filter.matches(clarification)) {
                printWriter.println();
                printWriter.println("  Clarification " + clarification.getNumber() + " (Site " + clarification.getSiteNumber() + ") " + clarification.getElementId());
                printWriter.println("           From  : " + clarification.getSubmitter() + " \"" + this.getDisplayName(clarification.getSubmitter()) + "\"");
                printWriter.println("         Problem : " + this.contest.getProblem(clarification.getProblemId()).toString());
                printWriter.println("         Elapsed : " + clarification.getElapsedMins());
                printWriter.print("           State   : " + (Object)((Object)clarification.getState()));
                if (clarification.getWhoJudgedItId() != null) {
                    printWriter.print(" by " + clarification.getWhoJudgedItId());
                }
                if (clarification.getWhoCheckedItOutId() != null) {
                    printWriter.print(" checked out by " + clarification.getWhoCheckedItOutId());
                }
                printWriter.println();
                printWriter.println("         To ALL? : " + clarification.isSendToAll());
                printWriter.println("         Question: " + clarification.getQuestion());
                printWriter.println("         Answer  : " + clarification.getAnswer());
                printWriter.println();
                printWriter.println();
                printWriter.println();
            }
            ++n2;
        }
    }

    private String getDisplayName(ClientId submitter) {
        Account account = this.contest.getAccount(submitter);
        if (account == null) {
            return submitter.getName();
        }
        return account.getDisplayName();
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Clarifications";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Clarifications Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

