/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.BalloonSettingsComparatorbySite;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public class BalloonSettingsReport
implements IReport {
    private static final long serialVersionUID = -3705067685117724687L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        BalloonSettings[] balloonSettings = this.contest.getBalloonSettings();
        Problem[] problems = this.contest.getProblems();
        Arrays.sort(balloonSettings, new BalloonSettingsComparatorbySite());
        printWriter.println("-- " + balloonSettings.length + " BalloonSettings--");
        BalloonSettings[] balloonSettingsArray = balloonSettings;
        int n = balloonSettings.length;
        int n2 = 0;
        while (n2 < n) {
            BalloonSettings balloonSetting = balloonSettingsArray[n2];
            try {
                printWriter.println("Site '" + balloonSetting.getSiteNumber() + "' id=" + balloonSetting.getElementId());
                printWriter.println("      Balloon Client     : " + balloonSetting.getBalloonClient());
                printWriter.println("      Print balloons     : " + balloonSetting.isPrintBalloons());
                printWriter.println("      Print device       : " + balloonSetting.getPrintDevice());
                printWriter.println("      Postscript capable : " + balloonSetting.isPostscriptCapable());
                printWriter.println();
                printWriter.println("      email Balloons     : " + balloonSetting.isEmailBalloons());
                printWriter.println("      email to           : " + balloonSetting.getEmailContact());
                printWriter.println("      SMTP  server       : " + balloonSetting.getMailServer());
                printWriter.println("      Lines Per Page     : " + balloonSetting.getLinesPerPage());
                printWriter.println("      send No judgements : " + balloonSetting.isIncludeNos());
                Properties mailProperties = balloonSetting.getMailProperties();
                Set<Object> set = mailProperties.keySet();
                Object[] keys = set.toArray(new String[set.size()]);
                Arrays.sort(keys);
                printWriter.println("      Mail Properties :");
                Object[] objectArray = keys;
                int n3 = keys.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object key = objectArray[n4];
                    String value = (String)mailProperties.get(key);
                    printWriter.printf("            %-25s : %s\n", key, value);
                    ++n4;
                }
                printWriter.println();
                int counter = 1;
                Problem[] problemArray = problems;
                int n5 = problems.length;
                n3 = 0;
                while (n3 < n5) {
                    Problem problem = problemArray[n3];
                    printWriter.println("      [" + counter + "] " + problem.getDisplayName() + " '" + balloonSetting.getColor(problem) + "'" + " rgb='" + balloonSetting.getColorRGB(problem) + "'");
                    ++counter;
                    ++n3;
                }
                printWriter.println();
            }
            catch (Exception e) {
                e.printStackTrace(printWriter);
            }
            ++n2;
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Notification Settings";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Notification Settings Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

