/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.AccountsTSVReport;
import java.util.Vector;

public class AccountsTSVReportTeamAndJudges
extends AccountsTSVReport {
    private static final long serialVersionUID = 921156175618527895L;
    private IInternalContest contest = null;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.contest = inContest;
    }

    @Override
    public void setFilter(Filter filter) {
        super.setFilter(filter);
        if (!filter.isFilteringAccounts()) {
            Account[] judgeAccounts = this.getAccounts(ClientType.Type.JUDGE);
            filter.addAccounts(judgeAccounts);
            Account[] teamAccounts = this.getAccounts(ClientType.Type.TEAM);
            filter.addAccounts(teamAccounts);
        }
    }

    private Account[] getAccounts(ClientType.Type type) {
        Vector<Account> vector = this.contest.getAccounts(type);
        return vector.toArray(new Account[vector.size()]);
    }

    @Override
    public String getReportTitle() {
        return "accounts.tsv (team and judges)";
    }

    @Override
    public String getPluginTitle() {
        return "accounts.tsv Report (team and judges)";
    }
}

