/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReportFile;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class AccountsTSVReport
implements IReportFile {
    private static final long serialVersionUID = -2573139102854929516L;
    private static final String DELIMITER = "\t";
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    private void writeRow(PrintWriter printWriter, Account account) {
        printWriter.println(this.createRow(account));
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        block10: {
            Account[] accounts;
            block9: {
                Account account;
                printWriter.print("accounts");
                printWriter.print(DELIMITER);
                printWriter.print("1");
                printWriter.print(DELIMITER);
                printWriter.println();
                accounts = this.contest.getAccounts();
                Arrays.sort(accounts, new AccountComparator());
                if (!this.filter.isFilterOn()) break block9;
                int count = 0;
                Account[] accountArray = accounts;
                int n = accounts.length;
                int n2 = 0;
                while (n2 < n) {
                    account = accountArray[n2];
                    if (this.filter.matches(account)) {
                        ++count;
                    }
                    ++n2;
                }
                if (count <= 0) break block10;
                accountArray = accounts;
                n = accounts.length;
                n2 = 0;
                while (n2 < n) {
                    account = accountArray[n2];
                    if (this.filter.matches(account)) {
                        try {
                            this.writeRow(printWriter, account);
                        }
                        catch (Exception e) {
                            printWriter.println("Exception in report: " + e.getMessage());
                            e.printStackTrace(printWriter);
                        }
                    }
                    ++n2;
                }
                break block10;
            }
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n3 = 0;
            while (n3 < n) {
                Account account = accountArray[n3];
                try {
                    this.writeRow(printWriter, account);
                }
                catch (Exception e) {
                    printWriter.println("Exception in report: " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
                ++n3;
            }
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
                printWriter.close();
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        if (inFilter != null) {
            this.filter = inFilter;
        }
        StringBuffer buf = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        buf.append("accounts");
        buf.append(DELIMITER);
        buf.append("1");
        buf.append(DELIMITER);
        list.add(buf.toString());
        buf = new StringBuffer();
        Account[] accounts = this.contest.getAccounts();
        Arrays.sort(accounts, new AccountComparator());
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if (this.filter.matches(account)) {
                list.add(this.createRow(account));
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    private String createRow(Account account) {
        StringBuffer buf = new StringBuffer();
        ClientId clientId = account.getClientId();
        buf.append(clientId.getClientType().toString().toLowerCase());
        buf.append(DELIMITER);
        buf.append(clientId.getClientNumber());
        buf.append(DELIMITER);
        buf.append(account.getDisplayName());
        buf.append(DELIMITER);
        String alias = account.getAliasName();
        if (alias == null || "".equals(alias)) {
            alias = clientId.getName();
        }
        buf.append(alias);
        buf.append(DELIMITER);
        buf.append(account.getPassword());
        return buf.toString();
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "accounts.tsv (all accounts)";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "accounts.tsv Report (all accounts)";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public boolean suppressHeaderFooter() {
        return true;
    }
}

