/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model.playback;

import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.Submission;
import edu.csus.ecs.pc2.core.model.playback.ReplayEvent;

public class ReplayEventDetails
implements IElementObject {
    private static final long serialVersionUID = 5888807626510351852L;
    private ElementId elementId = null;
    private Run run = null;
    private Clarification clarification = null;
    private SerializedFile[] files = new SerializedFile[0];
    private JudgementRecord judgementRecord;
    private ReplayEvent replayEvent;

    private ReplayEventDetails() {
    }

    public ReplayEventDetails(ReplayEvent replayEvent, Run run, JudgementRecord judgementRecord) {
        this.replayEvent = replayEvent;
        this.run = run;
        this.judgementRecord = judgementRecord;
    }

    public ReplayEventDetails(ReplayEvent replayEvent, Run run, SerializedFile[] files) {
        this.replayEvent = replayEvent;
        this.run = run;
        this.files = files;
    }

    public ReplayEventDetails(ReplayEvent replayEvent, Clarification clarification) {
        this.replayEvent = replayEvent;
        this.clarification = clarification;
    }

    @Override
    public void setSiteNumber(int siteNumber) {
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    public Run getRun() {
        return this.run;
    }

    public Clarification getClarification() {
        return this.clarification;
    }

    public SerializedFile[] getFiles() {
        return this.files;
    }

    public JudgementRecord getJudgementRecord() {
        return this.judgementRecord;
    }

    public ReplayEvent getReplayEvent() {
        return this.replayEvent;
    }

    private String toStringDetails() {
        return (Object)((Object)this.replayEvent.getEventType()) + " ";
    }

    public String toString() {
        if (this.run != null) {
            if (this.judgementRecord != null) {
                return String.valueOf(this.toStringDetails()) + this.judgementRecord + " " + this.run;
            }
            return String.valueOf(this.toStringDetails()) + this.run;
        }
        if (this.clarification != null) {
            return String.valueOf(this.toStringDetails()) + this.run;
        }
        return this.toStringDetails();
    }

    public Submission getSubmission() {
        if (this.run != null) {
            return this.run;
        }
        if (this.clarification != null) {
            return this.clarification;
        }
        return null;
    }
}

