/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model.playback;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.playback.ReplayEventDetails;

public class ReplayEvent
implements IElementObject {
    private static final long serialVersionUID = -2096823165590915352L;
    private ElementId elementId = null;
    private int sequenceId = 0;
    private ClientId submitterId;
    private ClientId clientId;
    private long eventTime;
    private EventType eventType = EventType.UNDEFINED;
    private ReplayEventDetails eventDetails = null;

    private ReplayEvent() {
    }

    protected ReplayEvent(ReplayEvent replayEvent) {
        this(replayEvent.getEventType(), replayEvent.getClientId());
        this.setElementId(replayEvent.getElementId());
        this.sequenceId = replayEvent.getSequenceId();
        this.submitterId = replayEvent.getSubmitterId();
        this.eventTime = replayEvent.getEventTime();
        this.eventDetails = null;
    }

    private void setElementId(ElementId elementId) {
        this.elementId = elementId;
    }

    public ReplayEvent(EventType eventType, ClientId clientId) {
        this.eventType = eventType;
        this.clientId = clientId;
        this.elementId = new ElementId("ReplayEvent");
    }

    public ReplayEvent(EventType eventType, ClientId clientId, int sequence) {
        this.eventType = eventType;
        this.clientId = clientId;
        this.sequenceId = sequence;
        this.elementId = new ElementId("ReplayEvent");
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public ClientId getSubmitterId() {
        return this.submitterId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    @Override
    public void setSiteNumber(int siteNumber) {
    }

    public void setSubmitterId(ClientId submitterId) {
        this.submitterId = submitterId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventDetails(ReplayEventDetails eventDetails) {
        this.eventDetails = eventDetails;
    }

    public ReplayEventDetails getEventDetails() {
        return this.eventDetails;
    }

    public ReplayEvent shallowClone(ReplayEvent inEvent) {
        return new ReplayEvent(inEvent);
    }

    public String toString() {
        return "Replay " + (Object)((Object)this.eventType) + " at " + this.eventTime + " by " + this.clientId + " details: " + this.eventDetails;
    }

    public static enum EventType {
        UNDEFINED,
        RUN_SUBMIT,
        RUN_JUDGEMENT,
        CLAR_SUBMIT,
        CLAR_ANSWER;

    }
}

