/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model.playback;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.playback.EventStatus;
import edu.csus.ecs.pc2.core.model.playback.PlaybackParseException;
import edu.csus.ecs.pc2.core.model.playback.PlaybackRecord;
import edu.csus.ecs.pc2.core.model.playback.ReplayEvent;
import edu.csus.ecs.pc2.core.model.playback.ReplayEventDetails;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;

public class PlaybackManager {
    public static final String ACTION_KEY = "action";
    public static final String ID_KEY = "id";
    public static final String SITE_KEY = "site";
    public static final String PROBLEM_KEY = "problem";
    public static final String LANGUAGE_KEY = "language";
    public static final String MAINFILE_KEY = "mainfile";
    public static final String SUBMIT_CLIENT_KEY = "submitclient";
    public static final String ELAPSED_KEY = "elapsed";
    private static final String DELIMITER = "";
    public static final String IS_SOLVED = "solved";
    public static final String IS_PRELIMINARY = "preliminary";
    public static final String JUDGED_ELAPSED_TIME = "judged_elapsed_time";
    public static final String IS_COMPUTER_JUDGED = "computer_judged";
    public static final String JUDGEMENT_TEXT = "judgement";
    public static final String JUDGE_CLIENT_KEY = "judgeclient";
    public static final String JUDGE_CLIENT_SITE = "judgeclientsite";
    public static final String IS_SEND_TO_TEAMS = "senttoteams";
    private PlaybackInfo playbackInfo = new PlaybackInfo();
    private Vector<PlaybackRecord> playbackList = new Vector();
    private boolean playbackRunning = false;

    private ReplayEvent[] load(String filename, IInternalContest contest) throws Exception {
        Vector<ReplayEvent> events = new Vector<ReplayEvent>();
        if (filename == null || DELIMITER.equals(filename)) {
            throw new IllegalArgumentException("Unable to load filename, filename is null");
        }
        if (!new File(filename).exists()) {
            throw new FileNotFoundException(filename);
        }
        String[] lines = Utilities.loadFile(filename);
        String sourceDirectory = Utilities.dirname(filename);
        int invalidLines = 0;
        int lineNumber = 0;
        Exception savedException = null;
        int eventCount = 1;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String s = stringArray[n2];
                try {
                    ++lineNumber;
                    if (s.trim().length() != 0 && !s.trim().startsWith("#")) {
                        ReplayEvent playbackEvent = this.createPlayBackEvent(lineNumber, contest, s, "[|]", sourceDirectory, events, eventCount);
                        if (playbackEvent != null) {
                            events.add(playbackEvent);
                            ++eventCount;
                        } else {
                            ++invalidLines;
                            System.out.println("Line " + lineNumber + ": unable to parse line: " + s);
                        }
                    }
                }
                catch (Exception e) {
                    if (++invalidLines != 1) break block9;
                    savedException = e;
                    System.out.println("Invalid line at: " + lineNumber + " " + s);
                }
            }
            ++n2;
        }
        if (savedException != null) {
            System.out.println("Errors on " + invalidLines + " lines, loading " + filename);
            System.err.println("Load directory: " + Utilities.getCurrentDirectory());
            savedException.printStackTrace();
            throw savedException;
        }
        return events.toArray(new ReplayEvent[events.size()]);
    }

    private static int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected ReplayEvent createPlayBackEvent(int lineNumber, IInternalContest contest, String s, String delimit, String sourceDir, Vector<ReplayEvent> events, int eventCount) throws PlaybackParseException {
        String[] fields = s.split(delimit);
        if (fields.length < 3) {
            throw new PlaybackParseException("line must have 3 or more fields");
        }
        ReplayEvent playbackEvent = null;
        Properties properties = this.mapFieldsNameValuePairs(fields);
        String command = this.getAndCheckValue(properties, ACTION_KEY, "'ACTION' name/value", lineNumber);
        ReplayEvent.EventType eventType = ReplayEvent.EventType.UNDEFINED;
        if (command.equalsIgnoreCase(ReplayEvent.EventType.RUN_SUBMIT.toString())) {
            eventType = ReplayEvent.EventType.RUN_SUBMIT;
            String problemName = this.getAndCheckValue(properties, PROBLEM_KEY, "Problem name", lineNumber);
            String languageName = this.getAndCheckValue(properties, LANGUAGE_KEY, "Language name", lineNumber);
            String mainfileName = this.getAndCheckValue(properties, MAINFILE_KEY, "Main filename", lineNumber);
            String siteId = this.getAndCheckValue(properties, SITE_KEY, "Site number", lineNumber);
            String submitClientName = this.getAndCheckValue(properties, SUBMIT_CLIENT_KEY, "Client id", lineNumber);
            String elapsedTimeStr = this.getAndCheckValue(properties, ELAPSED_KEY, "Elapsed time", false, lineNumber);
            Language language = this.findLanguage(contest, languageName);
            Problem problem = this.findProblem(contest, problemName);
            ClientId clientId = this.findClient(contest, siteId, submitClientName);
            Run run = new Run(clientId, language, problem);
            SerializedFile[] files = new SerializedFile[1];
            try {
                SerializedFile file = new SerializedFile(mainfileName);
                if (file == null || file.getBuffer() == null) {
                    throw new PlaybackParseException(lineNumber, "Could not read/find " + mainfileName);
                }
                if (file.getBuffer().length == 0) {
                    throw new PlaybackParseException(lineNumber, "No bytes for file " + mainfileName);
                }
                files[0] = file;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PlaybackParseException(e);
            }
            String idStr = this.getAndCheckValue(properties, ID_KEY, "run/clar number", lineNumber);
            int number = Integer.parseInt(idStr);
            if (number < 1) {
                throw new PlaybackParseException(lineNumber, "invalid run/clar number: " + idStr);
            }
            run.setSiteNumber(contest.getSiteNumber());
            if (siteId != null) {
                int siteNumber = PlaybackManager.getIntegerValue(siteId);
                run.setSiteNumber(siteNumber);
            }
            run.setElapsedMins(PlaybackManager.getIntegerValue(elapsedTimeStr));
            run.setNumber(number);
            playbackEvent = new ReplayEvent(eventType, clientId, eventCount);
            ReplayEventDetails details = new ReplayEventDetails(playbackEvent, run, files);
            playbackEvent.setEventDetails(details);
        } else if (command.equalsIgnoreCase(ReplayEvent.EventType.RUN_JUDGEMENT.toString())) {
            String judgementText;
            eventType = ReplayEvent.EventType.RUN_JUDGEMENT;
            String siteId = this.getAndCheckValue(properties, SITE_KEY, "Site number", lineNumber);
            String idStr = this.getAndCheckValue(properties, ID_KEY, "run/clar number", lineNumber);
            int number = Integer.parseInt(idStr);
            if (number < 1) {
                throw new PlaybackParseException(lineNumber, "invalid run/clar number: " + idStr);
            }
            String judgeSiteString = this.getAndCheckValue(properties, JUDGE_CLIENT_SITE, "run/clar number", lineNumber);
            String judgeClientName = this.getAndCheckValue(properties, JUDGE_CLIENT_KEY, "Judge Client id", lineNumber);
            ClientId clientId = this.findClient(contest, judgeSiteString, judgeClientName);
            Run run = this.findRun(contest, siteId, number, events);
            if (run == null) {
                throw new PlaybackParseException("Could not find submitted run for judgement run site " + siteId + " run number " + number);
            }
            ClientId judgeClientId = this.findClient(contest, siteId, judgeClientName);
            String solvedString = this.getAndCheckValue(properties, IS_SOLVED, "Solved flag", false, lineNumber);
            boolean solved = solvedString.equalsIgnoreCase("true");
            ElementId judgementElementId = this.findJudgementId(contest, solved, judgementText = this.getAndCheckValue(properties, JUDGEMENT_TEXT, "Judgement", true, lineNumber));
            if (judgementElementId == null) {
                throw new PlaybackParseException("Could not find judgement " + judgementText);
            }
            String computerJudgedString = this.getAndCheckValue(properties, IS_COMPUTER_JUDGED, "Conputer Judged flag", false, lineNumber);
            boolean computerJudged = computerJudgedString.equalsIgnoreCase("true");
            String prelimJudgedString = this.getAndCheckValue(properties, IS_PRELIMINARY, "Preliminary Judged", false, lineNumber);
            boolean preliminaryJudged = prelimJudgedString.equalsIgnoreCase("true");
            String sendToTeamString = this.getAndCheckValue(properties, IS_SEND_TO_TEAMS, "Send to teams", false, lineNumber);
            boolean sendToTeam = sendToTeamString.equalsIgnoreCase("true");
            boolean usedValidator = false;
            JudgementRecord judgementRecord = new JudgementRecord(judgementElementId, judgeClientId, solved, usedValidator, computerJudged);
            judgementRecord.setPreliminaryJudgement(preliminaryJudged);
            judgementRecord.setSendToTeam(sendToTeam);
            playbackEvent = new ReplayEvent(eventType, clientId, eventCount);
            ReplayEventDetails details = new ReplayEventDetails(playbackEvent, run, judgementRecord);
            playbackEvent.setEventDetails(details);
        } else {
            throw new PlaybackParseException(lineNumber, "Unknown event: " + command);
        }
        return playbackEvent;
    }

    private ElementId findJudgementId(IInternalContest contest, boolean solved, String judgementText) {
        Judgement[] judgements = contest.getJudgements();
        if (solved) {
            return judgements[0].getElementId();
        }
        Judgement[] judgementArray = judgements;
        int n = judgements.length;
        int n2 = 0;
        while (n2 < n) {
            Judgement judgement = judgementArray[n2];
            if (judgementText.trim().equalsIgnoreCase(judgement.getDisplayName().trim())) {
                return judgement.getElementId();
            }
            ++n2;
        }
        return null;
    }

    private Run findRun(IInternalContest contest, String siteIdString, int number, Vector<ReplayEvent> events) {
        if (events == null) {
            return null;
        }
        int siteId = PlaybackManager.getIntegerValue(siteIdString);
        for (ReplayEvent event : events) {
            Run run;
            if (!event.getEventType().equals((Object)ReplayEvent.EventType.RUN_SUBMIT) || (run = event.getEventDetails().getRun()).getNumber() != number || run.getSiteNumber() != siteId) continue;
            return run;
        }
        return null;
    }

    private ClientId findClient(IInternalContest contest, String siteId, String loginName) throws PlaybackParseException {
        int siteNumber = PlaybackManager.getIntegerValue(siteId);
        if (loginName.startsWith("team") && loginName.length() > 4) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(4));
            return new ClientId(siteNumber, ClientType.Type.TEAM, number);
        }
        if (loginName.startsWith("t") && loginName.length() > 1) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(1));
            return new ClientId(siteNumber, ClientType.Type.TEAM, number);
        }
        if (loginName.startsWith("judge") && loginName.length() > 5) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(5));
            return new ClientId(siteNumber, ClientType.Type.JUDGE, number);
        }
        throw new PlaybackParseException("Could not find/match client: " + loginName);
    }

    private Problem findProblem(IInternalContest contest, String problemName) throws PlaybackParseException {
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.getDisplayName().trim().equalsIgnoreCase(problemName.trim())) {
                return problem;
            }
            ++n2;
        }
        throw new PlaybackParseException("Could not find/match problem: " + problemName);
    }

    private Language findLanguage(IInternalContest contest, String languageName) throws PlaybackParseException {
        Language[] languageArray = contest.getLanguages();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            if (language.getDisplayName().trim().equalsIgnoreCase(languageName.trim())) {
                return language;
            }
            ++n2;
        }
        throw new PlaybackParseException("Could not find/match language: " + languageName);
    }

    private String getAndCheckValue(Properties properties, String key, String message, int lineNumber) throws PlaybackParseException {
        return this.getAndCheckValue(properties, key, message, true, lineNumber);
    }

    private String getAndCheckValue(Properties properties, String key, String message, boolean requiredOption, int lineNumber) throws PlaybackParseException {
        String value = properties.getProperty(key);
        if (value == null && requiredOption) {
            throw new PlaybackParseException(lineNumber, String.valueOf(message) + " value missing (key = " + key + ")");
        }
        return value;
    }

    private Properties mapFieldsNameValuePairs(String[] fields) throws PlaybackParseException {
        Properties properties = new Properties();
        int fieldNumber = 0;
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            ++fieldNumber;
            if (field.trim().length() != 0) {
                int index = field.indexOf("=");
                if (index == -1) {
                    throw new PlaybackParseException("Missing = in name/value pair, field " + fieldNumber + ": " + field);
                }
                String key = field.substring(0, index).trim().toLowerCase();
                String value = field.substring(index + 1);
                properties.put(key, value);
            }
            ++n2;
        }
        return properties;
    }

    public void sendToJudgesAndOthers(IInternalController controller, Packet packet, boolean sendToServers) {
        controller.sendToAdministrators(packet);
        controller.sendToJudges(packet);
        controller.sendToScoreboards(packet);
        if (sendToServers) {
            controller.sendToServers(packet);
        }
    }

    private void writeValues(String key, long number) {
        System.out.print(String.valueOf(key) + "=" + number + " ");
    }

    private void writeValues(String key, String value) {
        System.out.print(String.valueOf(key) + "=" + value + " ");
    }

    private void dump(String message, PlaybackRecord playbackRecord) {
        ReplayEventDetails details = playbackRecord.getReplayEvent().getEventDetails();
        System.out.println(message);
        if (details != null && details.getRun() != null) {
            Run run = details.getRun();
            this.writeValues(ACTION_KEY, playbackRecord.getEventType().toString());
            this.writeValues(ID_KEY, run.getNumber());
            this.writeValues(ELAPSED_KEY, run.getElapsedMins());
            this.writeValues(LANGUAGE_KEY, run.getLanguageId().toString());
            this.writeValues(PROBLEM_KEY, run.getProblemId().toString());
            this.writeValues(SITE_KEY, run.getSiteNumber());
            this.writeValues(SUBMIT_CLIENT_KEY, run.getSubmitter().getName());
            this.writeValues("File size", details.getFiles()[0].getBuffer().length);
        } else {
            System.out.println(" No run details for playback event " + playbackRecord.getSequenceNumber());
        }
        System.out.println();
    }

    public PlaybackRecord executeNextEvent(IInternalContest contest, IInternalController controller) throws Exception {
        PlaybackRecord playbackRecord = this.playbackList.elementAt(this.playbackInfo.getSequenceNumber());
        ReplayEvent event = playbackRecord.getReplayEvent();
        ReplayEventDetails details = event.getEventDetails();
        if (Utilities.isDebugMode()) {
            this.dump("in executeEvent", playbackRecord);
        }
        switch (playbackRecord.getEventType()) {
            case RUN_SUBMIT: {
                SerializedFile file = details.getFiles()[0];
                SerializedFile[] files = new SerializedFile[]{file};
                RunFiles runFiles = new RunFiles(details.getRun(), file, new SerializedFile[0]);
                Run theRun = details.getRun();
                long savedElapsed = theRun.getElapsedMS();
                Run newRun = contest.acceptRun(theRun, runFiles);
                newRun.setPlaybackSequenceNumber(playbackRecord.getSequenceNumber());
                if (savedElapsed > 0L) {
                    newRun.setElapsedMS(savedElapsed);
                }
                playbackRecord.setEventStatus(EventStatus.COMPLETED);
                contest.updatePlaybackInfo(this.playbackInfo);
                ClientId fromId = contest.getClientId();
                Packet confirmPacket = PacketFactory.createRunSubmissionConfirm(contest.getClientId(), fromId, newRun);
                controller.sendToClient(confirmPacket);
                this.sendToJudgesAndOthers(controller, confirmPacket, true);
                break;
            }
            case RUN_JUDGEMENT: {
                Run run = details.getRun();
                this.sendStatusMessge(contest, controller, run, RunExecutionStatus.COMPILING);
                this.sendStatusMessge(contest, controller, run, RunExecutionStatus.EXECUTING);
                this.sendStatusMessge(contest, controller, run, RunExecutionStatus.VALIDATING);
                JudgementRecord judgement = details.getJudgementRecord();
                Run runToUpdate = contest.getRun(run.getElementId());
                runToUpdate.addJudgement(judgement);
                ClientId whoChangedRun = judgement.getJudgerClientId();
                runToUpdate.setStatus(Run.RunStates.JUDGED);
                contest.updateRun(runToUpdate, whoChangedRun);
                Run updatedRun = contest.getRun(run.getElementId());
                Packet runUpdatedPacket = PacketFactory.createRunUpdateNotification(contest.getClientId(), PacketFactory.ALL_SERVERS, updatedRun, whoChangedRun);
                this.sendToJudgesAndOthers(controller, runUpdatedPacket, true);
                if (updatedRun.isJudged() && updatedRun.getJudgementRecord().isSendToTeam()) {
                    Packet notifyPacket = PacketFactory.clonePacket(contest.getClientId(), run.getSubmitter(), runUpdatedPacket);
                    this.sendJudgementToTeam(controller, contest, notifyPacket, updatedRun);
                }
                playbackRecord.setEventStatus(EventStatus.COMPLETED);
                contest.updatePlaybackInfo(this.playbackInfo);
                break;
            }
            default: {
                throw new Exception("Event " + (Object)((Object)playbackRecord.getEventType()) + " not implemented, yet");
            }
        }
        this.playbackInfo.incrementSequenceNumber();
        return playbackRecord;
    }

    public void startPlayback(final IInternalContest contest, final IInternalController controller, final Runnable callback) {
        this.playbackInfo.setStarted(true);
        this.insureMinimumPlaybackRecords(this.playbackInfo.getMinimumPlaybackRecords());
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlaybackManager.this.setPlaybackRunning(true);
                int waitTime = PlaybackManager.this.playbackInfo.getWaitBetweenEventsMS();
                while (!PlaybackManager.this.allEventsExecuted() && PlaybackManager.this.isPlaybackRunning()) {
                    try {
                        PlaybackManager.this.executeNextEvent(contest, controller);
                        if (callback != null) {
                            callback.run();
                        }
                        if (waitTime <= 0) continue;
                        Thread.sleep(waitTime);
                    }
                    catch (Exception e) {
                        PlaybackManager.this.setPlaybackRunning(false);
                        if (callback != null) {
                            callback.run();
                        }
                        e.printStackTrace();
                    }
                }
                PlaybackManager.this.setPlaybackRunning(false);
                if (callback != null) {
                    callback.run();
                }
            }
        }).start();
    }

    private void sendStatusMessge(IInternalContest contest, IInternalController controller, Run run, RunExecutionStatus status) {
        if (contest.isSendAdditionalRunStatusMessages()) {
            Packet sendPacket = PacketFactory.createRunStatusPacket(contest.getClientId(), contest.getClientId(), run, contest.getClientId(), status);
            this.sendToSpectatorsAndSites(controller, sendPacket, true);
        }
    }

    public void sendToSpectatorsAndSites(IInternalController controller, Packet packet, boolean sendToServers) {
        controller.sendToSpectators(packet);
        if (sendToServers) {
            controller.sendToServers(packet);
        }
    }

    private void sendJudgementToTeam(IInternalController controller, IInternalContest contest, Packet judgementPacket, Run run) {
        if (run.isJudged() && run.getJudgementRecord().isSendToTeam()) {
            JudgementNotificationsList judgementNotificationsList = contest.getContestInformation().getJudgementNotificationsList();
            if (!RunUtilities.supppressJudgement(judgementNotificationsList, run, contest.getContestTime())) {
                controller.sendToClient(judgementPacket);
            } else {
                controller.getLog().info("Notification not sent to " + run.getSubmitter() + " for run " + run);
            }
        } else {
            controller.getLog().warning("Attempted to send back unjudged run to team " + run);
        }
    }

    public int getSequenceNumber() {
        return this.playbackInfo.getSequenceNumber();
    }

    public void rewind() {
        this.playbackInfo.rewind();
    }

    public PlaybackInfo createPlaybackInfo(String inputFilename, IInternalContest contest) throws Exception {
        ReplayEvent[] list = this.load(inputFilename, contest);
        this.playbackInfo = new PlaybackInfo("Default Playback Name", list);
        this.playbackInfo.setSiteNumber(contest.getSiteNumber());
        this.playbackInfo.setFilename(inputFilename);
        int nextSequence = 1;
        PlaybackRecord[] playbackRecords = new PlaybackRecord[list.length];
        int i = 0;
        while (i < list.length) {
            playbackRecords[i] = new PlaybackRecord(list[i], nextSequence);
            ++nextSequence;
            ++i;
        }
        this.playbackList.addAll(Arrays.asList(playbackRecords));
        return this.playbackInfo;
    }

    public PlaybackRecord[] insureMinimumPlaybackRecords(int minimumNumberOfRecords) {
        int numberRecordsToCreate = minimumNumberOfRecords - this.getPlaybackRecords().length;
        ReplayEvent[] replays = this.playbackInfo.getReplayList();
        int maxReplayRecords = replays.length;
        if (numberRecordsToCreate > 0 && maxReplayRecords > 0) {
            PlaybackRecord[] playbackRecords = new PlaybackRecord[numberRecordsToCreate];
            int offset = this.getPlaybackRecords().length % maxReplayRecords;
            int nextSequence = this.getPlaybackRecords().length + 1;
            int i = 0;
            while (i < numberRecordsToCreate) {
                if (offset >= maxReplayRecords) {
                    offset = 0;
                }
                playbackRecords[i] = new PlaybackRecord(replays[offset], nextSequence);
                ++nextSequence;
                ++offset;
                ++i;
            }
            this.playbackList.addAll(Arrays.asList(playbackRecords));
        }
        return this.getPlaybackRecords();
    }

    public PlaybackRecord[] getPlaybackRecords() {
        return this.playbackList.toArray(new PlaybackRecord[this.playbackList.size()]);
    }

    public boolean allEventsExecuted() {
        return this.playbackInfo.getSequenceNumber() > this.getPlaybackRecords().length;
    }

    public PlaybackInfo getPlaybackInfo() {
        return this.playbackInfo;
    }

    public boolean isPlaybackRunning() {
        return this.playbackRunning;
    }

    public void setPlaybackRunning(boolean playbackRunning) {
        this.playbackRunning = playbackRunning;
    }

    public PlaybackRecord getCurrentPlaybackRecord() {
        return this.getPlaybackRecords()[this.getSequenceNumber()];
    }
}

