/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.RunTestCase;
import edu.csus.ecs.pc2.core.model.Submission;
import java.util.Vector;

public class Run
extends Submission {
    private static final long serialVersionUID = 4643865629642121895L;
    private Vector<JudgementRecord> judgementList = new Vector();
    private Vector<RunTestCase> testcases = new Vector();
    private boolean deleted;
    private RunStates status = RunStates.INITIAL;
    private String systemOS = null;
    private long originalElapsedMS = -1L;
    private long overRideElapsedTimeMS;
    private int overrideNumber = 0;

    public Run(ClientId submitter, Language languageId, Problem problemId) {
        this.setSubmitter(submitter);
        this.setLanguageId(languageId.getElementId());
        this.setProblemId(problemId.getElementId());
        this.status = problemId.isComputerJudged() ? RunStates.QUEUED_FOR_COMPUTER_JUDGEMENT : RunStates.NEW;
        this.setElementId(new ElementId("Run"));
        this.systemOS = System.getProperty("os.name", "?");
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public RunStates getStatus() {
        return this.status;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setStatus(RunStates status) {
        this.status = status;
    }

    public boolean isJudged() {
        return this.status == RunStates.JUDGED || this.status == RunStates.BEING_RE_JUDGED || this.status == RunStates.MANUAL_REVIEW;
    }

    public JudgementRecord getJudgementRecord() {
        if (this.judgementList.size() == 0) {
            return null;
        }
        if (this.judgementList.size() == 1) {
            return this.judgementList.elementAt(0);
        }
        int i = this.judgementList.size() - 1;
        while (i >= 0) {
            JudgementRecord judgement = this.judgementList.elementAt(i);
            if (judgement.isActive()) {
                return judgement;
            }
            --i;
        }
        return null;
    }

    public boolean isSolved() {
        JudgementRecord judgementRecord = this.getJudgementRecord();
        if (judgementRecord == null) {
            return false;
        }
        return judgementRecord.isSolved();
    }

    public JudgementRecord[] getAllJudgementRecords() {
        return this.judgementList.toArray(new JudgementRecord[this.judgementList.size()]);
    }

    public void addJudgement(JudgementRecord judgement) {
        if (judgement == null) {
            throw new IllegalArgumentException("Input judgement is null");
        }
        JudgementRecord lastJudgement = this.getJudgementRecord();
        if (lastJudgement != null) {
            lastJudgement.setActive(false);
            if (lastJudgement.isComputerJudgement() && !judgement.isComputerJudgement()) {
                judgement.setPreviousComputerJudgementId(judgement.getElementId());
            }
        }
        this.judgementList.addElement(judgement);
    }

    public JudgementRecord getComputerJudgementRecord() {
        if (this.judgementList.size() == 0) {
            return null;
        }
        if (this.judgementList.size() == 1) {
            JudgementRecord judgementRecord = this.judgementList.elementAt(0);
            if (judgementRecord.isComputerJudgement()) {
                return judgementRecord;
            }
            return null;
        }
        int i = this.judgementList.size() - 1;
        while (i >= 0) {
            JudgementRecord judgement = this.judgementList.elementAt(i);
            if (judgement.isActive() && judgement.isComputerJudgement()) {
                return judgement;
            }
            --i;
        }
        return null;
    }

    public long getJudgedMinutes() {
        JudgementRecord judgement = this.getJudgementRecord();
        if (judgement == null) {
            return 0L;
        }
        return judgement.getJudgedMinutes();
    }

    public String getCommentsForTeam() {
        JudgementRecord judgementRecord = this.getJudgementRecord();
        if (judgementRecord == null) {
            return "";
        }
        if (judgementRecord.getCommentForTeam() == null) {
            return "";
        }
        return judgementRecord.getCommentForTeam().getComment();
    }

    public String getCommentsForJudge() {
        JudgementRecord judgementRecord = this.getJudgementRecord();
        if (judgementRecord == null) {
            return "";
        }
        if (judgementRecord.getCommentForJudge() == null) {
            return "";
        }
        return judgementRecord.getCommentForJudge().getComment();
    }

    public boolean isSendToTeams() {
        JudgementRecord judgementRecord = this.getJudgementRecord();
        if (judgementRecord != null) {
            return judgementRecord.isSendToTeam();
        }
        return false;
    }

    public String getSystemOS() {
        return this.systemOS;
    }

    public String toString() {
        return "Run " + this.getNumber() + " " + (Object)((Object)this.getStatus()) + " " + this.getElapsedMins() + " min " + this.getElapsedMS() + "ms from " + this.getSubmitter() + " id " + this.getElementId().toString() + " problem " + this.getProblemId() + " lang " + this.getLanguageId();
    }

    public long getOriginalElapsedMS() {
        return this.originalElapsedMS;
    }

    @Override
    public void setElapsedMS(long elapsedMS) {
        if (this.getOriginalElapsedMS() == -1L) {
            this.originalElapsedMS = elapsedMS;
            if (this.overRideElapsedTimeMS > 0L) {
                elapsedMS = this.overRideElapsedTimeMS;
            }
        }
        super.setElapsedMS(elapsedMS);
    }

    public void setOverRideElapsedTimeMS(long overRideElapsedTimeMS) {
        this.overRideElapsedTimeMS = overRideElapsedTimeMS;
    }

    public long getOverRideElapsedTimeMS() {
        return this.overRideElapsedTimeMS;
    }

    public boolean isSameAs(Run run) {
        block13: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    if (this.getElapsedMins() == run.getElapsedMins()) break block8;
                                    return false;
                                }
                                catch (Exception exception) {
                                    return false;
                                }
                            }
                            if (this.isDeleted() == run.isDeleted()) break block9;
                            return false;
                        }
                        if (this.getSubmitter().equals(run.getSubmitter())) break block10;
                        return false;
                    }
                    if (this.getProblemId().equals(run.getProblemId())) break block11;
                    return false;
                }
                if (this.getLanguageId().equals(run.getLanguageId())) break block12;
                return false;
            }
            if (this.getStatus() == run.getStatus()) break block13;
            return false;
        }
        return this.getJudgementRecord().equals(run.getJudgementRecord());
    }

    @Override
    public int getNumber() {
        if (this.overrideNumber > 0) {
            return this.overrideNumber;
        }
        return super.getNumber();
    }

    public int internalRunId() {
        return super.getNumber();
    }

    public void setOverRideNumber(int number) {
        this.overrideNumber = number;
    }

    public RunTestCase[] getRunTestCases() {
        return this.testcases.toArray(new RunTestCase[this.testcases.size()]);
    }

    public void addTestCase(RunTestCase runTestCase) {
        this.testcases.add(runTestCase);
    }

    public static enum RunStates {
        INITIAL,
        NEW,
        CHECKED_OUT,
        BEING_JUDGED,
        BEING_RE_JUDGED,
        HOLD,
        REJUDGE,
        JUDGED,
        QUEUED_FOR_COMPUTER_JUDGEMENT,
        BEING_COMPUTER_JUDGED,
        MANUAL_REVIEW;

    }
}

