/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import java.io.File;

public final class ProblemFilesUtilities {
    private ProblemFilesUtilities() {
    }

    public static boolean verifyProblemFiles(IInternalContest contest, Problem problem) {
        if (problem.getNumberTestCases() == 0) {
            return false;
        }
        if (problem.isUsingExternalDataFiles()) {
            return ProblemFilesUtilities.verifyExternalProblemFiles(contest, problem);
        }
        return ProblemFilesUtilities.verifyInternalProblemFiles(contest, problem);
    }

    private static boolean verifyExternalProblemFiles(IInternalContest contest, Problem problem) {
        int i = 1;
        while (i <= problem.getNumberTestCases()) {
            if (!new File(problem.getDataFileName(i)).isFile()) {
                return false;
            }
            if (!new File(problem.getAnswerFileName(i)).isFile()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean verifyInternalProblemFiles(IInternalContest contest, Problem problem) {
        ProblemDataFiles files = contest.getProblemDataFile(problem);
        if (files == null) {
            return false;
        }
        if (problem.getNumberTestCases() != files.getJudgesAnswerFiles().length || problem.getNumberTestCases() != files.getJudgesDataFiles().length) {
            return false;
        }
        return false;
    }

    public static boolean verifyValidator(IInternalContest contest, Problem problem) {
        ProblemDataFiles files = contest.getProblemDataFile(problem);
        if (files.getValidatorFile() == null) {
            return true;
        }
        if (problem.getValidatorProgramName() == null) {
            return false;
        }
        return new File(problem.getValidatorProgramName()).isFile();
    }
}

