/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ProblemDataFiles
implements IElementObject {
    private static final long serialVersionUID = -3590638930073985058L;
    private ElementId elementId = new ElementId("ProblemDF");
    private ElementId problemId = null;
    private SerializedFile validatorRunCommand;
    private SerializedFile validatorFile;
    private SerializedFile validatorRunFile;
    private SerializedFile[] validatorFiles;
    private SerializedFile[] judgesDataFiles = new SerializedFile[0];
    private SerializedFile[] judgesAnswerFiles = new SerializedFile[0];

    public ProblemDataFiles(Problem problem) {
        this.problemId = problem.getElementId();
    }

    public ProblemDataFiles copy(Problem problem) throws CloneNotSupportedException {
        ProblemDataFiles clone = new ProblemDataFiles(problem);
        clone.setSiteNumber(this.getSiteNumber());
        clone.elementId = this.elementId;
        clone.problemId = this.getProblemId();
        clone.setValidatorFile(this.cloneSerializedFile(this.getValidatorFile()));
        clone.setValidatorRunCommand(this.getValidatorRunCommand());
        clone.setValidatorFile(this.cloneSerializedFile(this.getValidatorRunFile()));
        clone.setJudgesAnswerFiles(this.cloneSFArray(this.getJudgesAnswerFiles()));
        clone.setJudgesDataFiles(this.cloneSFArray(this.getJudgesDataFiles()));
        clone.setValidatorFiles(this.getValidatorFiles());
        return clone;
    }

    private SerializedFile[] cloneSFArray(SerializedFile[] fileArray) throws CloneNotSupportedException {
        SerializedFile[] clone;
        if (fileArray != null) {
            clone = new SerializedFile[fileArray.length];
            int i = 0;
            while (i < fileArray.length) {
                clone[i] = this.cloneSerializedFile(fileArray[i]);
                ++i;
            }
        } else {
            clone = null;
        }
        return clone;
    }

    private SerializedFile cloneSerializedFile(SerializedFile file) throws CloneNotSupportedException {
        SerializedFile clone = null;
        if (file != null) {
            clone = (SerializedFile)file.clone();
        }
        return clone;
    }

    public SerializedFile[] getJudgesAnswerFiles() {
        return this.judgesAnswerFiles;
    }

    public SerializedFile[] getJudgesDataFiles() {
        return this.judgesDataFiles;
    }

    public void setJudgesAnswerFiles(SerializedFile[] judgesAnswerFiles) {
        this.judgesAnswerFiles = judgesAnswerFiles;
    }

    public void setJudgesAnswerFile(SerializedFile judgesAnswerFile) {
        SerializedFile[] files = new SerializedFile[]{judgesAnswerFile};
        this.setJudgesAnswerFiles(files);
    }

    public void setJudgesDataFiles(SerializedFile[] judgesDataFiles) {
        this.judgesDataFiles = judgesDataFiles;
    }

    public void setJudgesDataFile(SerializedFile judgesDataFile) {
        SerializedFile[] files = new SerializedFile[]{judgesDataFile};
        this.setJudgesDataFiles(files);
    }

    public SerializedFile getJudgesDataFile() {
        SerializedFile[] files = this.getJudgesDataFiles();
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    public SerializedFile getJudgesAnswerFile() {
        SerializedFile[] files = this.getJudgesAnswerFiles();
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public ElementId getProblemId() {
        return this.problemId;
    }

    protected void setProblemId(ElementId problemId) {
        this.problemId = problemId;
    }

    public SerializedFile getValidatorRunCommand() {
        return this.validatorRunCommand;
    }

    public void setValidatorRunCommand(SerializedFile validatorRunCommand) {
        this.validatorRunCommand = validatorRunCommand;
    }

    public SerializedFile getValidatorFile() {
        return this.validatorFile;
    }

    public void setValidatorFile(SerializedFile validatorFile) {
        this.validatorFile = validatorFile;
    }

    private boolean compareSerializedFiles(SerializedFile oldFile, SerializedFile newFile) {
        if (oldFile == null) {
            return newFile == null;
        }
        if (newFile == null) {
            return false;
        }
        if (!oldFile.getSHA1sum().equals(newFile.getSHA1sum())) {
            return false;
        }
        if (!oldFile.getAbsolutePath().equals(newFile.getAbsolutePath())) {
            return false;
        }
        byte[] oldBuffer = oldFile.getBuffer();
        byte[] newBuffer = newFile.getBuffer();
        if (oldBuffer == null ? newBuffer != null : newBuffer == null) {
            return false;
        }
        if (oldBuffer.length != newBuffer.length) {
            return false;
        }
        int i = 0;
        while (i < newBuffer.length) {
            if (newBuffer[i] != oldBuffer[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean compareSerializedFileArrays(SerializedFile[] oldList, SerializedFile[] newList) {
        if (oldList == null) {
            return newList == null;
        }
        if (newList == null) {
            return false;
        }
        if (oldList.length != newList.length) {
            return false;
        }
        int i = 0;
        while (i < oldList.length) {
            if (!this.compareSerializedFiles(oldList[i], newList[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSameAs(ProblemDataFiles newProblemDataFiles) {
        block7: {
            block6: {
                block5: {
                    try {
                        if (newProblemDataFiles != null) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (this.compareSerializedFileArrays(this.judgesAnswerFiles, newProblemDataFiles.getJudgesAnswerFiles())) break block6;
                return false;
            }
            if (this.compareSerializedFileArrays(this.judgesDataFiles, newProblemDataFiles.getJudgesDataFiles())) break block7;
            return false;
        }
        return this.compareSerializedFiles(this.validatorFile, newProblemDataFiles.getValidatorFile());
    }

    public String toString() {
        SerializedFile file;
        SerializedFile[] list;
        StringBuffer buf = new StringBuffer();
        buf.append(this.problemId);
        buf.append(" ");
        int numDataFiles = this.judgesDataFiles.length;
        int numAnsFiles = this.judgesAnswerFiles.length;
        buf.append(numDataFiles);
        buf.append(" data files, ");
        buf.append(numAnsFiles);
        buf.append(" answer files. ");
        buf.append("Data: ");
        SerializedFile[] serializedFileArray = list = this.judgesDataFiles;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            file = serializedFileArray[n2];
            buf.append(file.getName());
            buf.append(" ");
            ++n2;
        }
        buf.append("Answer: ");
        serializedFileArray = list = this.judgesAnswerFiles;
        n = list.length;
        n2 = 0;
        while (n2 < n) {
            file = serializedFileArray[n2];
            buf.append(file.getName());
            buf.append(" ");
            ++n2;
        }
        buf.append(" Validator: ");
        if (this.validatorFile != null) {
            buf.append(this.validatorFile.getName());
        }
        return buf.toString();
    }

    public SerializedFile getValidatorRunFile() {
        return this.validatorRunFile;
    }

    public void setValidatorRunFile(SerializedFile validatorRunFile) {
        this.validatorRunFile = validatorRunFile;
    }

    public void setValidatorFiles(SerializedFile[] validatorFiles) {
        this.validatorFiles = validatorFiles;
    }

    public SerializedFile[] getValidatorFiles() {
        return this.validatorFiles;
    }

    public String[] getFullJudgesDataFilenames(IInternalContest contest, String executableDir) {
        return Utilities.fullJudgesDataFilenames(contest, this, executableDir);
    }

    public String[] getFullJudgesAnswerFilenames(IInternalContest contest, String executableDir) {
        return Utilities.fullJudgesAnswerFilenames(contest, this, executableDir);
    }

    public void checkAndCreateFiles(IInternalContest contest, String executableDir) throws FileNotFoundException {
        Utilities.insureDir(executableDir);
        String[] datafilenames = this.getFullJudgesDataFilenames(contest, executableDir);
        int i = 0;
        while (i < datafilenames.length) {
            String filename = datafilenames[i];
            if (!new File(filename).exists()) {
                SerializedFile file = this.judgesDataFiles[i];
                if (file.isExternalFile()) {
                    throw new FileNotFoundException(filename);
                }
                try {
                    file.writeFile(filename);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to write " + filename, e);
                }
                if (!new File(filename).exists()) {
                    throw new FileNotFoundException(filename);
                }
            }
            ++i;
        }
        String[] answerfilenames = this.getFullJudgesAnswerFilenames(contest, executableDir);
        int i2 = 0;
        while (i2 < answerfilenames.length) {
            String filename = answerfilenames[i2];
            if (!new File(filename).exists()) {
                SerializedFile file = this.judgesAnswerFiles[i2];
                if (file.isExternalFile()) {
                    throw new FileNotFoundException(filename);
                }
                try {
                    file.writeFile(filename);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to write " + filename, e);
                }
                if (!new File(filename).exists()) {
                    throw new FileNotFoundException(filename);
                }
            }
            ++i2;
        }
    }

    public void removeDataSet(int index) {
        int i;
        int newIdx;
        SerializedFile[] newDataFiles = new SerializedFile[]{};
        SerializedFile[] newAnswerFiles = new SerializedFile[]{};
        int curDataFileCount = this.judgesDataFiles.length;
        int curAnswerFileCount = this.judgesAnswerFiles.length;
        if (curDataFileCount > 1) {
            newDataFiles = new SerializedFile[this.judgesDataFiles.length - 1];
            newIdx = 0;
            i = 0;
            while (i < this.judgesDataFiles.length) {
                if (index != i) {
                    newDataFiles[newIdx] = this.judgesDataFiles[i];
                    ++newIdx;
                }
                ++i;
            }
        }
        if (curAnswerFileCount > 1) {
            newAnswerFiles = new SerializedFile[this.judgesAnswerFiles.length - 1];
            newIdx = 0;
            i = 0;
            while (i < this.judgesAnswerFiles.length) {
                if (index != i) {
                    newAnswerFiles[newIdx] = this.judgesAnswerFiles[i];
                    ++newIdx;
                }
                ++i;
            }
        }
        this.judgesDataFiles = newDataFiles;
        this.judgesAnswerFiles = newAnswerFiles;
    }

    public void removeAll() {
        this.judgesDataFiles = new SerializedFile[0];
        this.judgesAnswerFiles = new SerializedFile[0];
    }
}

